/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;

public class BinaryResource
implements Resource {
    private String a = null;
    private String b = null;
    private byte[] c;
    private URLConnection d = null;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public final Resource makeResource(Configuration configuration, AbstractResourceCollection.InputDetails inputDetails) {
            return new BinaryResource(inputDetails);
        }
    };

    public BinaryResource(AbstractResourceCollection.InputDetails inputDetails) {
        this.b = inputDetails.contentType;
        this.a = inputDetails.resourceUri;
        this.c = inputDetails.binaryContent;
    }

    public BinaryResource(String string, String string2, byte[] byArray) {
        this.b = string2;
        this.a = string;
        this.c = byArray;
    }

    public void setData(byte[] byArray) {
        this.c = byArray;
    }

    public byte[] getData() {
        return this.c;
    }

    @Override
    public String getResourceURI() {
        return this.a;
    }

    private byte[] a(URLConnection object) {
        this.d = object;
        try {
            int n2;
            int n3;
            object = this.d.getInputStream();
            int n4 = this.d.getContentLength();
            object = new BufferedInputStream((InputStream)object);
            if (n4 < 0) {
                byte[] byArray = BinaryResource.readBinaryFromStream((InputStream)object, this.d.getURL().getPath());
                ((InputStream)object).close();
                return byArray;
            }
            byte[] byArray = new byte[n4];
            for (n2 = 0; n2 < n4 && (n3 = ((InputStream)object).read(byArray, n2, byArray.length - n2)) != -1; n2 += n3) {
            }
            ((InputStream)object).close();
            if (n2 != n4) {
                throw new XPathException("Only read " + n2 + " bytes; Expected " + n4 + " bytes");
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    public static byte[] readBinaryFromStream(InputStream inputStream, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[16384];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new XPathException("Failed to read: " + string + " " + iOException);
        }
    }

    public Item getItem(XPathContext object) {
        if (this.c != null) {
            return new Base64BinaryValue(this.c);
        }
        if (this.d != null) {
            this.c = this.a(this.d);
            return new Base64BinaryValue(this.c);
        }
        try {
            object = new URI(this.a).toURL();
            this.d = ((URL)object).openConnection();
            this.c = this.a(this.d);
            return new Base64BinaryValue(this.c);
        }
        catch (IOException | URISyntaxException exception) {
            throw new XPathException(exception);
        }
    }

    @Override
    public String getContentType() {
        return this.b;
    }
}

