/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.DataURIScheme;
import net.sf.saxon.resource.FailedResource;
import net.sf.saxon.resource.StandardCollectionFinder;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MappingJavaIterator;

public class CatalogCollection
extends AbstractResourceCollection {
    private boolean a;
    private SpaceStrippingRule b;

    public CatalogCollection(Configuration configuration, String string) {
        super(configuration);
        this.collectionURI = string;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext xPathContext) {
        StandardCollectionFinder.checkNotNull(this.collectionURI, xPathContext);
        CatalogCollection catalogCollection = this;
        return catalogCollection.catalogContents(catalogCollection.collectionURI, xPathContext);
    }

    public Iterator<Resource> getResources(XPathContext xPathContext) {
        StandardCollectionFinder.checkNotNull(this.collectionURI, xPathContext);
        Iterator<String> iterator = this.getResourceURIs(xPathContext);
        return new MappingJavaIterator<String, Resource>(iterator, string -> {
            try {
                if (string.startsWith("data:")) {
                    try {
                        Resource resource = DataURIScheme.decode(new URI((String)string));
                        return this.makeTypedResource(xPathContext.getConfiguration(), resource);
                    }
                    catch (IllegalArgumentException | URISyntaxException exception) {
                        throw new XPathException(exception);
                    }
                }
                AbstractResourceCollection.InputDetails inputDetails = this.getInputDetails((String)string);
                this.getInputDetails((String)string).parseOptions = new ParseOptions(xPathContext.getConfiguration().getParseOptions());
                inputDetails.parseOptions.setSpaceStrippingRule(this.b);
                inputDetails.resourceUri = string;
                return this.makeResource(xPathContext.getConfiguration(), inputDetails);
            }
            catch (XPathException xPathException) {
                int n2 = this.params == null ? 1 : this.params.getOnError();
                if (n2 == 1) {
                    return new FailedResource((String)string, xPathException);
                }
                if (n2 == 2) {
                    xPathContext.getController().warning("collection(): failed to parse " + string + ": " + xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), null);
                    return null;
                }
                return null;
            }
        });
    }

    @Override
    public boolean isStable(XPathContext xPathContext) {
        return this.a;
    }

    public static StringBuilder makeStringBuilderFromStream(InputStream closeable, String charSequence) {
        closeable = new InputStreamReader((InputStream)closeable, Charset.forName((String)charSequence));
        charSequence = new StringBuilder();
        closeable = new BufferedReader((Reader)closeable);
        String string = ((BufferedReader)closeable).readLine();
        while (string != null) {
            ((StringBuilder)charSequence).append(string);
            string = ((BufferedReader)closeable).readLine();
        }
        ((BufferedReader)closeable).close();
        return charSequence;
    }

    protected Iterator<String> catalogContents(String object, XPathContext xPathContext) {
        Object object2 = DocumentFn.resolveURI((String)object, null, null, xPathContext);
        Object object3 = new ParseOptions();
        ((ParseOptions)object3).setSchemaValidationMode(4);
        ((ParseOptions)object3).setDTDValidationMode(4);
        object2 = xPathContext.getConfiguration().buildDocumentTree((Source)object2, (ParseOptions)object3);
        if (object2 == null) {
            object = new XPathException("Failed to load collection catalog " + (String)object);
            ((XPathException)object).setErrorCode("FODC0004");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
        object = object2.getRootNode().iterateAxis((byte)3, NodeKindTest.ELEMENT);
        if ((object2 = object.next()) == null || !"collection".equals(object2.getLocalPart()) || !object2.getURI().isEmpty()) {
            object = object2 == null ? "No outermost element found in collection catalog" : "Outermost element of collection catalog should be Q{}collection (found Q{" + object2.getURI() + "}" + object2.getLocalPart() + ")";
            object = new XPathException((String)object);
            ((XPathException)object).setErrorCode("FODC0004");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
        object.close();
        object = object2.getAttributeValue("", "stable");
        if (object != null) {
            if ("true".equals(object)) {
                this.a = true;
            } else if ("false".equals(object)) {
                this.a = false;
            } else {
                object = new XPathException("The 'stable' attribute of element <collection> must be true or false");
                ((XPathException)object).setErrorCode("FODC0004");
                ((XPathException)object).setXPathContext(xPathContext);
                throw object;
            }
        }
        object = object2.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        object2 = new ArrayList();
        while ((object3 = object.next()) != null) {
            Object object4;
            Object object5;
            if (!"doc".equals(object3.getLocalPart()) || !object3.getURI().isEmpty()) {
                object5 = new XPathException("Children of <collection> element must be <doc> elements");
                ((XPathException)object5).setErrorCode("FODC0004");
                ((XPathException)object5).setXPathContext(xPathContext);
                throw object5;
            }
            object5 = object3.getAttributeValue("", "href");
            if (object5 == null) {
                object4 = new XPathException("A <doc> element in the collection catalog has no @href attribute");
                ((XPathException)object4).setErrorCode("FODC0004");
                ((XPathException)object4).setXPathContext(xPathContext);
                throw object4;
            }
            try {
                object4 = new URI(object3.getBaseURI()).resolve((String)object5).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                object = new XPathException("Invalid base URI or href URI in collection catalog: (" + object3.getBaseURI() + ", " + (String)object5 + ")");
                ((XPathException)object).setErrorCode("FODC0004");
                ((XPathException)object).setXPathContext(xPathContext);
                throw object;
            }
            object2.add(object4);
        }
        return object2.iterator();
    }
}

