/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.FailedResource;
import net.sf.saxon.resource.MetadataResource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MappingJavaIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class DirectoryCollection
extends AbstractResourceCollection {
    private File a;
    private SpaceStrippingRule b;

    public DirectoryCollection(Configuration configuration, String string, File file, URIQueryParameters uRIQueryParameters) {
        super(configuration);
        if (string == null) {
            throw new NullPointerException();
        }
        this.collectionURI = string;
        this.a = file;
        if (uRIQueryParameters == null) {
            this.params = new URIQueryParameters("", configuration);
            return;
        }
        this.params = uRIQueryParameters;
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule spaceStrippingRule) {
        this.b = spaceStrippingRule;
        return true;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext xPathContext) {
        DirectoryCollection directoryCollection = this;
        return directoryCollection.directoryContents(directoryCollection.a, this.params);
    }

    public Iterator<Resource> getResources(XPathContext xPathContext) {
        DirectoryCollection directoryCollection = this;
        ParseOptions parseOptions = directoryCollection.optionsFromQueryParameters(directoryCollection.params, xPathContext);
        parseOptions.setSpaceStrippingRule(this.b);
        Boolean bl2 = this.params.getMetaData();
        boolean bl3 = bl2 != null && bl2 != false;
        Iterator<String> iterator = this.getResourceURIs(xPathContext);
        return new MappingJavaIterator<String, Resource>(iterator, string -> {
            try {
                AbstractResourceCollection.InputDetails inputDetails = this.getInputDetails((String)string);
                this.getInputDetails((String)string).parseOptions = parseOptions;
                parseOptions = this.makeResource(xPathContext.getConfiguration(), inputDetails);
                if (parseOptions != null) {
                    if (bl3) {
                        return DirectoryCollection.a((Resource)((Object)parseOptions), inputDetails);
                    }
                    return parseOptions;
                }
                return null;
            }
            catch (XPathException xPathException) {
                int n2 = this.params.getOnError();
                if (n2 == 1) {
                    return new FailedResource((String)string, xPathException);
                }
                if (n2 == 2) {
                    xPathContext.getController().warning("collection(): failed to parse " + string + ": " + xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), null);
                    return null;
                }
                return null;
            }
        });
    }

    private static MetadataResource a(Resource resource, AbstractResourceCollection.InputDetails object) {
        HashMap hashMap;
        block6: {
            hashMap = new HashMap();
            try {
                URI uRI = new URI(resource.getResourceURI());
                if (((AbstractResourceCollection.InputDetails)object).contentType != null) {
                    hashMap.put("content-type", StringValue.makeStringValue(((AbstractResourceCollection.InputDetails)object).contentType));
                }
                if (((AbstractResourceCollection.InputDetails)object).encoding != null) {
                    hashMap.put("encoding", StringValue.makeStringValue(((AbstractResourceCollection.InputDetails)object).encoding));
                }
                if (!"file".equals(uRI.getScheme())) break block6;
                object = new File(uRI);
                hashMap.put("path", StringValue.makeStringValue(((File)object).getPath()));
                hashMap.put("absolute-path", StringValue.makeStringValue(((File)object).getAbsolutePath()));
                hashMap.put("canonical-path", StringValue.makeStringValue(((File)object).getCanonicalPath()));
                hashMap.put("can-read", BooleanValue.get(((File)object).canRead()));
                hashMap.put("can-write", BooleanValue.get(((File)object).canWrite()));
                hashMap.put("can-execute", BooleanValue.get(((File)object).canExecute()));
                hashMap.put("is-hidden", BooleanValue.get(((File)object).isHidden()));
                try {
                    hashMap.put("last-modified", DateTimeValue.fromJavaTime(((File)object).lastModified()));
                }
                catch (XPathException xPathException) {}
                hashMap.put("length", new Int64Value(((File)object).length()));
            }
            catch (IOException | URISyntaxException exception) {}
        }
        return new MetadataResource(resource.getResourceURI(), resource, hashMap);
    }

    protected Iterator<String> directoryContents(File file, URIQueryParameters object) {
        Object object2;
        Object object3 = null;
        boolean bl2 = false;
        if (object != null) {
            object2 = ((URIQueryParameters)object).getFilenameFilter();
            if (object2 != null) {
                object3 = object2;
            }
            if ((object = ((URIQueryParameters)object).getRecurse()) != null) {
                bl2 = (Boolean)object;
            }
        }
        object2 = new Stack<Iterator<File>>();
        ((Stack)object2).push(Arrays.asList(file.listFiles((FilenameFilter)object3)).iterator());
        return new a((Stack<Iterator<File>>)object2, bl2, (FilenameFilter)object3);
    }

    private static final class a
    implements Iterator<String> {
        private Stack<Iterator<File>> a;
        private FilenameFilter b;
        private boolean c;
        private String d = null;

        public a(Stack<Iterator<File>> stack, boolean bl2, FilenameFilter filenameFilter) {
            this.a = stack;
            this.c = bl2;
            this.b = filenameFilter;
            this.a();
        }

        @Override
        public final boolean hasNext() {
            return this.d != null;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private void a() {
            if (this.a.isEmpty()) {
                this.d = null;
                return;
            }
            Iterator<File> iterator = this.a.peek();
            while (!iterator.hasNext()) {
                this.a.pop();
                if (this.a.isEmpty()) {
                    this.d = null;
                    return;
                }
                iterator = this.a.peek();
            }
            if (((File)((Object)(iterator = iterator.next()))).isDirectory()) {
                if (this.c) {
                    this.a.push(Arrays.asList(((File)((Object)iterator)).listFiles(this.b)).iterator());
                }
                this.a();
                return;
            }
            this.d = ((File)((Object)iterator)).toURI().toString();
        }

        @Override
        public final /* synthetic */ Object next() {
            a a2 = this;
            String string = a2.d;
            a2.a();
            return string;
        }
    }
}

