/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.FailedResource;
import net.sf.saxon.resource.MetadataResource;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class JarCollection
extends AbstractResourceCollection {
    private XPathContext a;
    private String b;
    private SpaceStrippingRule c;

    public JarCollection(XPathContext xPathContext, String string, URIQueryParameters uRIQueryParameters) {
        super(xPathContext.getConfiguration());
        this.a = xPathContext;
        this.b = string;
        this.params = uRIQueryParameters;
    }

    @Override
    public boolean stripWhitespace(SpaceStrippingRule spaceStrippingRule) {
        this.c = spaceStrippingRule;
        return true;
    }

    @Override
    public String getCollectionURI() {
        return this.b;
    }

    @Override
    public Iterator<String> getResourceURIs(XPathContext object) {
        Serializable serializable;
        Object object2;
        object = null;
        if (this.params != null) {
            object2 = this.params.getFilenameFilter();
            if (object2 != null) {
                object = object2;
            }
            if ((serializable = this.params.getRecurse()) != null) {
                ((Boolean)serializable).booleanValue();
            }
        }
        object2 = this.a();
        serializable = new ArrayList();
        try {
            Object object3;
            String string = "";
            while ((object3 = ((ZipInputStream)object2).getNextEntry()) != null) {
                if (((ZipEntry)object3).isDirectory()) {
                    string = ((ZipEntry)object3).getName();
                }
                if (!((ZipEntry)object3).isDirectory()) {
                    object3 = ((ZipEntry)object3).getName();
                    if (object != null) {
                        if (string.equals("") || !((String)object3).contains(string)) {
                            string = ((String)object3).contains("/") ? ((String)object3).substring(0, ((String)object3).lastIndexOf("/")) : "";
                        }
                        if (object.accept(new File(string), (String)object3)) {
                            serializable.add(this.a((String)object3));
                        }
                    } else {
                        serializable.add(this.a((String)object3));
                    }
                }
                ((ZipInputStream)object2).getNextEntry();
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Unable to extract entry in JAR/ZIP file: " + this.b, iOException);
        }
        return serializable.iterator();
    }

    private ZipInputStream a() {
        Object object;
        try {
            object = new URL(this.b);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException("Malformed JAR/ZIP file URI: " + this.b, malformedURLException);
        }
        try {
            object = ((URL)object).openConnection();
        }
        catch (IOException iOException) {
            throw new XPathException("Unable to open connection to JAR/ZIP file URI: " + this.b, iOException);
        }
        try {
            object = ((URLConnection)object).getInputStream();
        }
        catch (IOException iOException) {
            throw new XPathException("Unable to get input stream for JAR/ZIP file connection: " + this.b, iOException);
        }
        return new ZipInputStream((InputStream)object);
    }

    public Iterator<Resource> getResources(XPathContext object) {
        Object object2;
        object = null;
        if (this.params != null) {
            object2 = this.params.getFilenameFilter();
            if (object2 != null) {
                object = object2;
            }
            if ((object2 = this.params.getRecurse()) != null) {
                ((Boolean)object2).booleanValue();
            }
        }
        object2 = this.a();
        JarCollection jarCollection = this;
        return new a(jarCollection, jarCollection.a, (ZipInputStream)object2, (FilenameFilter)object);
    }

    private String a(String string) {
        return (this.b.startsWith("jar:") ? "" : "jar:") + this.b + "!/" + string;
    }

    protected Map<String, GroundedValue<?>> makeProperties(ZipEntry zipEntry) {
        HashMap hashMap = new HashMap(10);
        hashMap.put("comment", StringValue.makeStringValue(zipEntry.getComment()));
        hashMap.put("compressed-size", new Int64Value(zipEntry.getCompressedSize()));
        hashMap.put("crc", new Int64Value(zipEntry.getCrc()));
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            hashMap.put("extra", new Base64BinaryValue(byArray));
        }
        hashMap.put("compression-method", new Int64Value(zipEntry.getMethod()));
        hashMap.put("entry-name", StringValue.makeStringValue(zipEntry.getName()));
        hashMap.put("size", new Int64Value(zipEntry.getSize()));
        try {
            hashMap.put("last-modified", DateTimeValue.fromJavaTime(zipEntry.getTime()));
        }
        catch (XPathException xPathException) {}
        return hashMap;
    }

    private final class a
    implements Closeable,
    Iterator<Resource> {
        private FilenameFilter a;
        private Resource b = null;
        private XPathContext c;
        private ZipInputStream d;
        private String e = "";
        private ParseOptions f;
        private boolean g;
        private /* synthetic */ JarCollection h;

        public a(JarCollection jarCollection, XPathContext xPathContext, ZipInputStream zipInputStream, FilenameFilter filenameFilter) {
            this.h = jarCollection;
            this.c = xPathContext;
            this.a = filenameFilter;
            this.d = zipInputStream;
            JarCollection jarCollection2 = jarCollection;
            this.f = jarCollection2.optionsFromQueryParameters(jarCollection2.params, xPathContext);
            this.f.setSpaceStrippingRule(jarCollection.c);
            jarCollection = jarCollection.params == null ? null : jarCollection.params.getMetaData();
            this.g = jarCollection != null && ((Boolean)((Object)jarCollection)).booleanValue();
            this.b();
        }

        @Override
        public final boolean hasNext() {
            boolean bl2 = this.b != null;
            if (!bl2) {
                try {
                    this.d.close();
                }
                catch (IOException iOException) {
                    throw new UncheckedXPathException(new XPathException(iOException));
                }
            }
            return bl2;
        }

        private Resource a() {
            Resource resource = this.b;
            this.b();
            return resource;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        private void b() {
            while (true) {
                ZipEntry zipEntry;
                try {
                    zipEntry = this.d.getNextEntry();
                    if (zipEntry == null) {
                        this.b = null;
                        return;
                    }
                }
                catch (IOException iOException) {
                    this.b = new FailedResource(null, new XPathException(iOException));
                    return;
                }
                if (zipEntry.isDirectory()) {
                    this.e = zipEntry.getName();
                    continue;
                }
                String string = zipEntry.getName();
                if (this.a != null) {
                    if (this.e.equals("") || !string.contains(this.e)) {
                        this.e = string.contains("/") ? string.substring(0, string.lastIndexOf("/")) : "";
                    }
                    if (!this.a.accept(new File(this.e), string)) continue;
                }
                string = null;
                try {
                    Object object;
                    ZipInputStream zipInputStream = this.d;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try {
                        int n2;
                        object = new byte[4096];
                        while ((n2 = ((InputStream)zipInputStream).read((byte[])object)) > 0) {
                            byteArrayOutputStream.write((byte[])object, 0, n2);
                        }
                    }
                    catch (IOException iOException) {
                        throw new UncheckedXPathException(new XPathException(iOException));
                    }
                    finally {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            this.b = new FailedResource(null, new XPathException(iOException));
                        }
                    }
                    object = new AbstractResourceCollection.InputDetails();
                    new AbstractResourceCollection.InputDetails().binaryContent = byteArrayOutputStream.toByteArray();
                    object.contentType = this.h.guessContentTypeFromName(zipEntry.getName());
                    if (object.contentType == null) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(object.binaryContent);
                        object.contentType = this.h.guessContentTypeFromContent(byteArrayInputStream);
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException) {
                            object.contentType = null;
                        }
                    }
                    object.parseOptions = this.f;
                    object.resourceUri = string = this.h.a(zipEntry.getName());
                    this.b = this.h.makeResource(this.c.getConfiguration(), (AbstractResourceCollection.InputDetails)object);
                    if (this.g) {
                        Map<String, GroundedValue<?>> map = this.h.makeProperties(zipEntry);
                        this.b = new MetadataResource(string, this.b, map);
                    }
                    return;
                }
                catch (XPathException xPathException) {
                    this.b = new FailedResource(string, xPathException);
                    continue;
                }
                break;
            }
        }

        @Override
        public final void close() {
            this.d.close();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.a();
        }
    }
}

