/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.URIQueryParameters;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.ResourceCollection;
import net.sf.saxon.lib.StandardCollectionURIResolver;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.resource.DirectoryCollection;
import net.sf.saxon.resource.JarCollection;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;

public class StandardCollectionFinder
implements CollectionFinder {
    private Map<String, ResourceCollection> a = new HashMap<String, ResourceCollection>(2);

    public void registerCollection(String string, ResourceCollection resourceCollection) {
        this.a.put(string, resourceCollection);
    }

    @Override
    public ResourceCollection findCollection(XPathContext xPathContext, String string) {
        URI uRI;
        Object object;
        StandardCollectionFinder.checkNotNull(string, xPathContext);
        Object object2 = this.a.get(string);
        if (object2 != null) {
            return object2;
        }
        object2 = null;
        try {
            object = new URI(ResolveURI.escapeSpaces(string));
            object = ((URI)object).getQuery();
            if (object != null) {
                int n2 = string.indexOf(63);
                object2 = new URIQueryParameters((String)object, xPathContext.getConfiguration());
                string = ResolveURI.escapeSpaces(string.substring(0, n2));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            XPathException xPathException = new XPathException("Invalid relative URI " + Err.wrap(string, 4) + " passed to collection() function");
            xPathException.setErrorCode("FODC0004");
            xPathException.setXPathContext(xPathContext);
            throw xPathException;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException(uRISyntaxException);
        }
        if ("file".equals(uRI.getScheme())) {
            object = new File(uRI);
            StandardCollectionURIResolver.checkFileExists((File)object, uRI, xPathContext);
            if (((File)object).isDirectory()) {
                return new DirectoryCollection(xPathContext.getConfiguration(), string, (File)object, (URIQueryParameters)object2);
            }
        }
        if (this.isJarFileURI(string)) {
            return new JarCollection(xPathContext, string, (URIQueryParameters)object2);
        }
        return new CatalogCollection(xPathContext.getConfiguration(), string);
    }

    public static void checkNotNull(String object, XPathContext xPathContext) {
        if (object == null) {
            object = new XPathException("No default collection has been defined");
            ((XPathException)object).setErrorCode("FODC0002");
            ((XPathException)object).setXPathContext(xPathContext);
            throw object;
        }
    }

    protected boolean isJarFileURI(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip") || string.startsWith("jar:");
    }
}

