/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.BinaryResource;
import net.sf.saxon.trans.XPathException;

public class UnknownResource
implements Resource {
    private Configuration a;
    private AbstractResourceCollection.InputDetails b;
    public static final ResourceFactory FACTORY = UnknownResource::new;

    public UnknownResource(Configuration configuration, AbstractResourceCollection.InputDetails inputDetails) {
        this.a = configuration;
        this.b = inputDetails;
    }

    @Override
    public String getResourceURI() {
        return this.b.resourceUri;
    }

    public Item getItem(XPathContext xPathContext) {
        String string;
        Object object;
        if (this.b.binaryContent != null) {
            object = new ByteArrayInputStream(this.b.binaryContent);
        } else {
            try {
                object = this.b.getInputStream();
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
        if (object == null) {
            throw new XPathException("Unable to dereference resource URI " + this.b.resourceUri);
        }
        try {
            if (!((InputStream)object).markSupported()) {
                object = new BufferedInputStream((InputStream)object);
            }
            string = URLConnection.guessContentTypeFromStream((InputStream)object);
        }
        catch (IOException iOException) {
            string = null;
        }
        if (string == null) {
            string = this.a.getMediaTypeForFileExtension("");
        }
        if (string == null || string.equals("application/unknown")) {
            string = "application/binary";
        }
        this.b.contentType = string;
        this.b.binaryContent = BinaryResource.readBinaryFromStream((InputStream)object, this.b.resourceUri);
        object = this.a.getResourceFactoryForMediaType(string);
        object = object.makeResource(this.a, this.b);
        return object.getItem(xPathContext);
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }
}

