/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.resource.CatalogCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedTextResource
implements Resource {
    private String a;
    private String b;
    private String c = null;
    private String d = null;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public final Resource makeResource(Configuration configuration, AbstractResourceCollection.InputDetails inputDetails) {
            return new UnparsedTextResource(inputDetails);
        }
    };

    public UnparsedTextResource(AbstractResourceCollection.InputDetails inputDetails) {
        this.c = inputDetails.resourceUri;
        this.a = inputDetails.contentType;
        this.b = inputDetails.encoding;
        if (inputDetails.characterContent != null) {
            this.d = inputDetails.characterContent;
            return;
        }
        if (inputDetails.binaryContent != null) {
            if (inputDetails.encoding == null) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(inputDetails.binaryContent);
                    inputDetails.encoding = StandardUnparsedTextResolver.inferStreamEncoding(byteArrayInputStream, null);
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (IOException iOException) {
                    throw new XPathException(iOException);
                }
            }
            try {
                this.d = new String(inputDetails.binaryContent, inputDetails.encoding);
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XPathException(unsupportedEncodingException);
            }
        }
    }

    @Override
    public String getResourceURI() {
        return this.c;
    }

    public String getEncoding() {
        return this.b;
    }

    public String getContent() {
        if (this.d == null) {
            try {
                Object object = new URL(this.c);
                object = ((URL)object).openConnection();
                object = ((URLConnection)object).getInputStream();
                String string = this.b;
                if (string == null) {
                    string = StandardUnparsedTextResolver.inferStreamEncoding((InputStream)object, null);
                }
                object = CatalogCollection.makeStringBuilderFromStream((InputStream)object, string);
                this.d = ((StringBuilder)object).toString();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XPathException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
        return this.d;
    }

    public Item getItem(XPathContext xPathContext) {
        return new StringValue(this.getContent());
    }

    @Override
    public String getContentType() {
        if (this.a == null) {
            return "text/plain";
        }
        return this.a;
    }
}

