/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.lib.ResourceFactory;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.resource.AbstractResourceCollection;
import net.sf.saxon.trans.XPathException;

public class XmlResource
implements Resource {
    private NodeInfo a;
    private Configuration b;
    private AbstractResourceCollection.InputDetails c;
    public static final ResourceFactory FACTORY = new ResourceFactory(){

        @Override
        public final Resource makeResource(Configuration configuration, AbstractResourceCollection.InputDetails inputDetails) {
            return new XmlResource(configuration, inputDetails);
        }
    };

    public XmlResource(NodeInfo nodeInfo) {
        this.b = nodeInfo.getConfiguration();
        this.a = nodeInfo;
    }

    public XmlResource(Configuration configuration, NodeInfo nodeInfo) {
        this.b = configuration;
        this.a = nodeInfo;
        if (configuration != nodeInfo.getConfiguration()) {
            throw new IllegalArgumentException("Supplied node belongs to wrong configuration");
        }
    }

    public XmlResource(Configuration configuration, AbstractResourceCollection.InputDetails inputDetails) {
        this.b = configuration;
        this.c = inputDetails;
    }

    @Override
    public String getResourceURI() {
        if (this.a == null) {
            return this.c.resourceUri;
        }
        return this.a.getSystemId();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Item getItem(XPathContext object) {
        if (this.a != null) return this.a;
        Object object2 = this.c.resourceUri;
        ParseOptions parseOptions = this.c.parseOptions;
        if (parseOptions == null) {
            parseOptions = this.b.getParseOptions();
        }
        if (this.c.characterContent != null) {
            object2 = new StreamSource(new StringReader(this.c.characterContent), (String)object2);
        } else if (this.c.binaryContent != null) {
            object2 = new StreamSource(new ByteArrayInputStream(this.c.binaryContent), (String)object2);
        } else {
            try {
                InputStream inputStream = this.c.getInputStream();
                object2 = new StreamSource(inputStream, (String)object2);
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
        this.a = this.b.buildDocumentTree((Source)object2, parseOptions).getRootNode();
        if (((StreamSource)object2).getInputStream() == null) return this.a;
        try {
            ((StreamSource)object2).getInputStream().close();
            return this.a;
        }
        catch (IOException iOException) {}
        return this.a;
        catch (XPathException xPathException) {
            try {
                if (this.c.onError == 1) {
                    object = new XPathException("collection(): failed to parse XML file " + ((StreamSource)object2).getSystemId() + ": " + xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
                    throw object;
                }
                if (this.c.onError == 2) {
                    object.getController().warning("collection(): failed to parse XML file " + ((StreamSource)object2).getSystemId() + ": " + xPathException.getMessage(), xPathException.getErrorCodeLocalPart(), null);
                }
                this.a = null;
                if (((StreamSource)object2).getInputStream() == null) return this.a;
            }
            catch (Throwable throwable) {
                if (((StreamSource)object2).getInputStream() == null) throw throwable;
                try {
                    ((StreamSource)object2).getInputStream().close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((StreamSource)object2).getInputStream().close();
                return this.a;
            }
            catch (IOException iOException) {}
            return this.a;
        }
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }
}

