/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.net.URI;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.BuildingContentHandler;
import net.sf.saxon.s9api.BuildingStreamWriterImpl;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;

public class DocumentBuilder {
    private Configuration a;
    private SchemaValidator b;
    private boolean c;
    private boolean d;
    private TreeModel e = TreeModel.TINY_TREE;
    private WhitespaceStrippingPolicy f = WhitespaceStrippingPolicy.UNSPECIFIED;
    private URI g;
    private XQueryExecutable h;

    protected DocumentBuilder(Configuration configuration) {
        this.a = configuration;
    }

    public void setTreeModel(TreeModel treeModel) {
        this.e = treeModel;
    }

    public TreeModel getTreeModel() {
        return this.e;
    }

    public void setLineNumbering(boolean bl2) {
        this.d = bl2;
    }

    public boolean isLineNumbering() {
        return this.d;
    }

    public void setSchemaValidator(SchemaValidator schemaValidator) {
        this.b = schemaValidator;
    }

    public SchemaValidator getSchemaValidator() {
        return this.b;
    }

    public void setDTDValidation(boolean bl2) {
        this.c = bl2;
    }

    public boolean isDTDValidation() {
        return this.c;
    }

    public void setWhitespaceStrippingPolicy(WhitespaceStrippingPolicy whitespaceStrippingPolicy) {
        this.f = whitespaceStrippingPolicy;
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return this.f;
    }

    public void setBaseURI(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.g = uRI;
    }

    public URI getBaseURI() {
        return this.g;
    }

    public void setDocumentProjectionQuery(XQueryExecutable xQueryExecutable) {
        this.h = xQueryExecutable;
    }

    public XQueryExecutable getDocumentProjectionQuery() {
        return this.h;
    }

    public XdmNode build(Source source) {
        Object object;
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (this.f != WhitespaceStrippingPolicy.UNSPECIFIED && this.f != WhitespaceStrippingPolicy.IGNORABLE && this.f.ordinal() != 4) {
            if (this.c) {
                throw new SaxonApiException("When DTD validation is used, the whitespace stripping policy must be IGNORABLE");
            }
            if (this.b != null) {
                throw new SaxonApiException("When schema validation is used, the whitespace stripping policy must be IGNORABLE");
            }
        }
        ParseOptions parseOptions = new ParseOptions(this.a.getParseOptions());
        parseOptions.setDTDValidationMode(this.c ? 1 : 4);
        if (this.b != null) {
            parseOptions.setSchemaValidationMode(this.b.isLax() ? 2 : 1);
            if (this.b.getDocumentElementName() != null) {
                object = this.b.getDocumentElementName();
                parseOptions.setTopLevelElement(new StructuredQName(((QName)object).getPrefix(), ((QName)object).getNamespaceURI(), ((QName)object).getLocalName()));
            }
            if (this.b.getDocumentElementType() != null) {
                parseOptions.setTopLevelType(this.b.getDocumentElementType());
            }
        }
        if (this.e != null) {
            parseOptions.setModel(this.e);
        }
        if (this.f != null && this.f != WhitespaceStrippingPolicy.UNSPECIFIED) {
            int n2 = this.f.ordinal();
            if (n2 == 4) {
                parseOptions.setSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                parseOptions.addFilter(this.f.makeStripper());
            } else {
                parseOptions.setSpaceStrippingRule(this.f.getSpaceStrippingRule());
            }
        }
        parseOptions.setLineNumbering(this.d);
        if (source.getSystemId() == null && this.g != null) {
            source.setSystemId(this.g.toString());
        }
        if (this.h != null) {
            object = this.h.getUnderlyingCompiledQuery();
            if ((object = this.a.makeDocumentProjector((XQueryExpression)object)) != null) {
                parseOptions.addFilter((FilterFactory)object);
            }
        }
        try {
            object = this.a.buildDocumentTree(source, parseOptions);
            return new XdmNode(object.getRootNode());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XdmNode build(File file) {
        return this.build(new StreamSource(file));
    }

    public BuildingContentHandler newBuildingContentHandler() {
        Object object = this.a.makePipelineConfiguration();
        object = this.e.makeBuilder((PipelineConfiguration)object);
        if (this.g != null) {
            ((Builder)object).setSystemId(this.g.toASCIIString());
        }
        ((Builder)object).setLineNumbering(this.d);
        Object object2 = object;
        object2 = new NamespaceReducer((Receiver)object2);
        object2 = this.a((NamespaceReducer)object2, (Builder)object);
        return new a((Receiver)object2, (Builder)object);
    }

    private Receiver a(NamespaceReducer namespaceReducer, Builder object) {
        if (this.b != null) {
            object = ((Builder)object).getPipelineConfiguration();
            Receiver receiver = this.b.getReceiver((PipelineConfiguration)object, this.a.obtainDefaultSerializationProperties());
            receiver.setPipelineConfiguration((PipelineConfiguration)object);
            if (receiver instanceof ProxyReceiver) {
                ((ProxyReceiver)receiver).setUnderlyingReceiver(namespaceReducer);
            }
            return receiver;
        }
        return namespaceReducer;
    }

    public BuildingStreamWriterImpl newBuildingStreamWriter() {
        Object object = this.a.makePipelineConfiguration();
        object = this.e.makeBuilder((PipelineConfiguration)object);
        ((Builder)object).setLineNumbering(this.d);
        Object object2 = object;
        object2 = new NamespaceReducer((Receiver)object2);
        object2 = this.a((NamespaceReducer)object2, (Builder)object);
        return new BuildingStreamWriterImpl((Receiver)object2, (Builder)object);
    }

    public XdmNode wrap(Object object) {
        if (object instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)object;
            if (nodeInfo.getConfiguration().isCompatible(this.a)) {
                return new XdmNode(nodeInfo);
            }
            throw new IllegalArgumentException("Supplied NodeInfo was created using a different Configuration");
        }
        try {
            JPConverter jPConverter = JPConverter.allocate(object.getClass(), null, this.a);
            object = (NodeInfo)jPConverter.convert(object, new EarlyEvaluationContext(this.a));
            return XdmItem.wrapItem((NodeInfo)object);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
    }

    private static final class a
    extends ReceivingContentHandler
    implements BuildingContentHandler {
        private Builder a;

        public a(Receiver receiver, Builder builder) {
            this.setReceiver(receiver);
            this.setPipelineConfiguration(receiver.getPipelineConfiguration());
            this.a = builder;
        }

        @Override
        public final XdmNode getDocumentNode() {
            return new XdmNode(this.a.getCurrentRoot());
        }
    }
}

