/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public abstract class ItemType {
    private static ConversionRules a = new ConversionRules();
    public static ItemType ANY_ITEM;
    public static ItemType ANY_FUNCTION;
    public static final ItemType ANY_NODE;
    public static final ItemType ATTRIBUTE_NODE;
    public static final ItemType COMMENT_NODE;
    public static final ItemType TEXT_NODE;
    public static final ItemType ELEMENT_NODE;
    public static final ItemType DOCUMENT_NODE;
    public static final ItemType NAMESPACE_NODE;
    public static final ItemType PROCESSING_INSTRUCTION_NODE;
    public static final ItemType ANY_MAP;
    public static final ItemType ANY_ARRAY;
    public static final ItemType ANY_ATOMIC_VALUE;
    public static final ItemType STRING;
    public static final ItemType BOOLEAN;
    public static final ItemType DURATION;
    public static final ItemType DATE_TIME;
    public static final ItemType DATE;
    public static final ItemType TIME;
    public static final ItemType G_YEAR_MONTH;
    public static final ItemType G_MONTH;
    public static final ItemType G_MONTH_DAY;
    public static final ItemType G_YEAR;
    public static final ItemType G_DAY;
    public static final ItemType HEX_BINARY;
    public static final ItemType BASE64_BINARY;
    public static final ItemType ANY_URI;
    public static final ItemType QNAME;
    public static final ItemType NOTATION;
    public static final ItemType UNTYPED_ATOMIC;
    public static final ItemType DECIMAL;
    public static final ItemType FLOAT;
    public static final ItemType DOUBLE;
    public static final ItemType INTEGER;
    public static final ItemType NON_POSITIVE_INTEGER;
    public static final ItemType NEGATIVE_INTEGER;
    public static final ItemType LONG;
    public static final ItemType INT;
    public static final ItemType SHORT;
    public static final ItemType BYTE;
    public static final ItemType NON_NEGATIVE_INTEGER;
    public static final ItemType POSITIVE_INTEGER;
    public static final ItemType UNSIGNED_LONG;
    public static final ItemType UNSIGNED_INT;
    public static final ItemType UNSIGNED_SHORT;
    public static final ItemType UNSIGNED_BYTE;
    public static final ItemType YEAR_MONTH_DURATION;
    public static final ItemType DAY_TIME_DURATION;
    public static final ItemType NORMALIZED_STRING;
    public static final ItemType TOKEN;
    public static final ItemType LANGUAGE;
    public static final ItemType NAME;
    public static final ItemType NMTOKEN;
    public static final ItemType NCNAME;
    public static final ItemType ID;
    public static final ItemType IDREF;
    public static final ItemType ENTITY;
    public static final ItemType DATE_TIME_STAMP;
    public static final ItemType NUMERIC;

    private static a a(BuiltInAtomicType builtInAtomicType, ConversionRules conversionRules) {
        return new a(builtInAtomicType, conversionRules);
    }

    public ConversionRules getConversionRules() {
        return a;
    }

    public abstract boolean matches(XdmItem var1);

    public abstract boolean subsumes(ItemType var1);

    public abstract net.sf.saxon.type.ItemType getUnderlyingItemType();

    public QName getTypeName() {
        Object object = this.getUnderlyingItemType();
        if (object instanceof SchemaType) {
            if ((object = ((SchemaType)object).getStructuredQName()) == null) {
                return null;
            }
            return new QName((StructuredQName)object);
        }
        return null;
    }

    public final boolean equals(Object object) {
        return object instanceof ItemType && this.getUnderlyingItemType().equals(((ItemType)object).getUnderlyingItemType());
    }

    public final int hashCode() {
        return this.getUnderlyingItemType().hashCode();
    }

    public String toString() {
        Object object = this.getUnderlyingItemType();
        if (object instanceof SchemaType) {
            String string = "";
            object = (SchemaType)object;
            do {
                StructuredQName structuredQName;
                if ((structuredQName = object.getStructuredQName()) != null) {
                    return string + structuredQName.getEQName();
                }
                string = "<";
            } while ((object = object.getBaseType()) != null);
            return "Q{http://www.w3.org/2001/XMLSchema}anyType";
        }
        return object.toString();
    }

    static {
        a.setStringToDoubleConverter(StringToDouble.getInstance());
        a.setNotationSet(null);
        a.setURIChecker(StandardURIChecker.getInstance());
        ANY_ITEM = new ItemType(){

            @Override
            public final ConversionRules getConversionRules() {
                return a;
            }

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return true;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return true;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return AnyItemType.getInstance();
            }
        };
        ANY_FUNCTION = new ItemType(){

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof Function;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType() instanceof FunctionItemType;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return AnyFunctionType.getInstance();
            }
        };
        ANY_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof NodeInfo;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType() instanceof NodeTest;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return AnyNodeTest.getInstance();
            }
        };
        ATTRIBUTE_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 2;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.ATTRIBUTE;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.ATTRIBUTE;
            }
        };
        COMMENT_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 8;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.COMMENT;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.COMMENT;
            }
        };
        TEXT_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 3;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.TEXT;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.TEXT;
            }
        };
        ELEMENT_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 1;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.ELEMENT;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.ELEMENT;
            }
        };
        DOCUMENT_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 9;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.DOCUMENT;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.DOCUMENT;
            }
        };
        NAMESPACE_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 13;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.NAMESPACE;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.NAMESPACE;
            }
        };
        PROCESSING_INSTRUCTION_NODE = new ItemType(){

            @Override
            public final boolean matches(XdmItem iterable) {
                return (iterable = iterable.getUnderlyingValue()) instanceof NodeInfo && ((NodeInfo)iterable).getNodeKind() == 7;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType().getUType() == UType.PI;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NodeKindTest.PROCESSING_INSTRUCTION;
            }
        };
        ANY_MAP = new ItemType(){

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof MapItem;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType() instanceof MapType;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return MapType.ANY_MAP_TYPE;
            }
        };
        ANY_ARRAY = new ItemType(){

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof ArrayItem;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType() instanceof ArrayItemType;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return ArrayItemType.ANY_ARRAY_TYPE;
            }
        };
        ANY_ATOMIC_VALUE = new ItemType(){

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof AtomicValue;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return itemType.getUnderlyingItemType() instanceof AtomicType;
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        };
        STRING = ItemType.a(BuiltInAtomicType.STRING, a);
        BOOLEAN = ItemType.a(BuiltInAtomicType.BOOLEAN, a);
        DURATION = ItemType.a(BuiltInAtomicType.DURATION, a);
        DATE_TIME = ItemType.a(BuiltInAtomicType.DATE_TIME, a);
        DATE = ItemType.a(BuiltInAtomicType.DATE, a);
        TIME = ItemType.a(BuiltInAtomicType.TIME, a);
        G_YEAR_MONTH = ItemType.a(BuiltInAtomicType.G_YEAR_MONTH, a);
        G_MONTH = ItemType.a(BuiltInAtomicType.G_MONTH, a);
        G_MONTH_DAY = ItemType.a(BuiltInAtomicType.G_MONTH_DAY, a);
        G_YEAR = ItemType.a(BuiltInAtomicType.G_YEAR, a);
        G_DAY = ItemType.a(BuiltInAtomicType.G_DAY, a);
        HEX_BINARY = ItemType.a(BuiltInAtomicType.HEX_BINARY, a);
        BASE64_BINARY = ItemType.a(BuiltInAtomicType.BASE64_BINARY, a);
        ANY_URI = ItemType.a(BuiltInAtomicType.ANY_URI, a);
        QNAME = ItemType.a(BuiltInAtomicType.QNAME, a);
        NOTATION = ItemType.a(BuiltInAtomicType.NOTATION, a);
        UNTYPED_ATOMIC = ItemType.a(BuiltInAtomicType.UNTYPED_ATOMIC, a);
        DECIMAL = ItemType.a(BuiltInAtomicType.DECIMAL, a);
        FLOAT = ItemType.a(BuiltInAtomicType.FLOAT, a);
        DOUBLE = ItemType.a(BuiltInAtomicType.DOUBLE, a);
        INTEGER = ItemType.a(BuiltInAtomicType.INTEGER, a);
        NON_POSITIVE_INTEGER = ItemType.a(BuiltInAtomicType.NON_POSITIVE_INTEGER, a);
        NEGATIVE_INTEGER = ItemType.a(BuiltInAtomicType.NEGATIVE_INTEGER, a);
        LONG = ItemType.a(BuiltInAtomicType.LONG, a);
        INT = ItemType.a(BuiltInAtomicType.INT, a);
        SHORT = ItemType.a(BuiltInAtomicType.SHORT, a);
        BYTE = ItemType.a(BuiltInAtomicType.BYTE, a);
        NON_NEGATIVE_INTEGER = ItemType.a(BuiltInAtomicType.NON_NEGATIVE_INTEGER, a);
        POSITIVE_INTEGER = ItemType.a(BuiltInAtomicType.POSITIVE_INTEGER, a);
        UNSIGNED_LONG = ItemType.a(BuiltInAtomicType.UNSIGNED_LONG, a);
        UNSIGNED_INT = ItemType.a(BuiltInAtomicType.UNSIGNED_INT, a);
        UNSIGNED_SHORT = ItemType.a(BuiltInAtomicType.UNSIGNED_SHORT, a);
        UNSIGNED_BYTE = ItemType.a(BuiltInAtomicType.UNSIGNED_BYTE, a);
        YEAR_MONTH_DURATION = ItemType.a(BuiltInAtomicType.YEAR_MONTH_DURATION, a);
        DAY_TIME_DURATION = ItemType.a(BuiltInAtomicType.DAY_TIME_DURATION, a);
        NORMALIZED_STRING = ItemType.a(BuiltInAtomicType.NORMALIZED_STRING, a);
        TOKEN = ItemType.a(BuiltInAtomicType.TOKEN, a);
        LANGUAGE = ItemType.a(BuiltInAtomicType.LANGUAGE, a);
        NAME = ItemType.a(BuiltInAtomicType.NAME, a);
        NMTOKEN = ItemType.a(BuiltInAtomicType.NMTOKEN, a);
        NCNAME = ItemType.a(BuiltInAtomicType.NCNAME, a);
        ID = ItemType.a(BuiltInAtomicType.ID, a);
        IDREF = ItemType.a(BuiltInAtomicType.IDREF, a);
        ENTITY = ItemType.a(BuiltInAtomicType.ENTITY, a);
        DATE_TIME_STAMP = ItemType.a(BuiltInAtomicType.DATE_TIME_STAMP, a);
        NUMERIC = new ItemType(){

            @Override
            public final ConversionRules getConversionRules() {
                return a;
            }

            @Override
            public final boolean matches(XdmItem xdmItem) {
                return xdmItem.getUnderlyingValue() instanceof NumericValue;
            }

            @Override
            public final boolean subsumes(ItemType itemType) {
                return DECIMAL.subsumes(itemType) || DOUBLE.subsumes(itemType) || FLOAT.subsumes(itemType);
            }

            @Override
            public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
                return NumericType.getInstance();
            }
        };
    }

    static final class a
    extends ItemType {
        private BuiltInAtomicType a;
        private ConversionRules b;

        public a(BuiltInAtomicType builtInAtomicType, ConversionRules conversionRules) {
            this.a = builtInAtomicType;
            this.b = conversionRules;
        }

        public static a a(a a2, ConversionRules conversionRules) {
            return new a(a2.a, conversionRules);
        }

        @Override
        public final ConversionRules getConversionRules() {
            return this.b;
        }

        @Override
        public final boolean matches(XdmItem object) {
            if (!((object = ((XdmItem)object).getUnderlyingValue()) instanceof AtomicValue)) {
                return false;
            }
            object = ((AtomicValue)object).getItemType();
            return this.a((AtomicType)object);
        }

        @Override
        public final boolean subsumes(ItemType object) {
            if (!(object = ((ItemType)object).getUnderlyingItemType()).isPlainType()) {
                return false;
            }
            object = (AtomicType)object;
            return this.a((AtomicType)object);
        }

        private boolean a(AtomicType schemaType) {
            SchemaType schemaType2 = schemaType = schemaType instanceof BuiltInAtomicType ? (BuiltInAtomicType)schemaType : (BuiltInAtomicType)schemaType.getBuiltInBaseType();
            while (!schemaType2.isSameType(this.a)) {
                if (!((schemaType = ((BuiltInAtomicType)schemaType).getBaseType()) instanceof BuiltInAtomicType)) {
                    return false;
                }
                schemaType2 = (BuiltInAtomicType)schemaType;
            }
            return true;
        }

        @Override
        public final net.sf.saxon.type.ItemType getUnderlyingItemType() {
            return this.a;
        }
    }
}

