/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.b;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;

public class ItemTypeFactory {
    private Processor a;

    public ItemTypeFactory(Processor processor) {
        this.a = processor;
    }

    public ItemType getAtomicType(QName qName) {
        Object object = qName.getNamespaceURI();
        Object object2 = qName.getLocalName();
        if ("http://www.w3.org/2001/XMLSchema".equals(object)) {
            int n2 = StandardNames.getFingerprint((String)object, (String)object2);
            object2 = this.a.getUnderlyingConfiguration();
            if (((Configuration)object2).getXsdVersion() == 10 && ((Configuration)object2).getXMLVersion() == 10) {
                return this.a(n2);
            }
            return ItemType.a.a((ItemType.a)this.a(n2), ((Configuration)object2).getConversionRules());
        }
        object = this.a.getUnderlyingConfiguration();
        object2 = ((Configuration)object).getSchemaType(new StructuredQName("", qName.getNamespaceURI(), (String)object2));
        if (object2 == null || !object2.isAtomicType()) {
            throw new SaxonApiException("Unknown atomic type " + qName.getClarkName());
        }
        return new b((AtomicType)object2, this.a);
    }

    private ItemType a(int n2) {
        switch (n2) {
            case 632: {
                return ItemType.ANY_ATOMIC_VALUE;
            }
            case 513: {
                return ItemType.STRING;
            }
            case 514: {
                return ItemType.BOOLEAN;
            }
            case 518: {
                return ItemType.DURATION;
            }
            case 519: {
                return ItemType.DATE_TIME;
            }
            case 521: {
                return ItemType.DATE;
            }
            case 520: {
                return ItemType.TIME;
            }
            case 522: {
                return ItemType.G_YEAR_MONTH;
            }
            case 526: {
                return ItemType.G_MONTH;
            }
            case 524: {
                return ItemType.G_MONTH_DAY;
            }
            case 523: {
                return ItemType.G_YEAR;
            }
            case 525: {
                return ItemType.G_DAY;
            }
            case 527: {
                return ItemType.HEX_BINARY;
            }
            case 528: {
                return ItemType.BASE64_BINARY;
            }
            case 529: {
                return ItemType.ANY_URI;
            }
            case 530: {
                return ItemType.QNAME;
            }
            case 531: {
                return ItemType.NOTATION;
            }
            case 631: {
                return ItemType.UNTYPED_ATOMIC;
            }
            case 515: {
                return ItemType.DECIMAL;
            }
            case 516: {
                return ItemType.FLOAT;
            }
            case 517: {
                return ItemType.DOUBLE;
            }
            case 533: {
                return ItemType.INTEGER;
            }
            case 534: {
                return ItemType.NON_POSITIVE_INTEGER;
            }
            case 535: {
                return ItemType.NEGATIVE_INTEGER;
            }
            case 536: {
                return ItemType.LONG;
            }
            case 537: {
                return ItemType.INT;
            }
            case 538: {
                return ItemType.SHORT;
            }
            case 539: {
                return ItemType.BYTE;
            }
            case 540: {
                return ItemType.NON_NEGATIVE_INTEGER;
            }
            case 541: {
                return ItemType.POSITIVE_INTEGER;
            }
            case 542: {
                return ItemType.UNSIGNED_LONG;
            }
            case 543: {
                return ItemType.UNSIGNED_INT;
            }
            case 544: {
                return ItemType.UNSIGNED_SHORT;
            }
            case 545: {
                return ItemType.UNSIGNED_BYTE;
            }
            case 633: {
                return ItemType.YEAR_MONTH_DURATION;
            }
            case 634: {
                return ItemType.DAY_TIME_DURATION;
            }
            case 553: {
                return ItemType.NORMALIZED_STRING;
            }
            case 554: {
                return ItemType.TOKEN;
            }
            case 555: {
                return ItemType.LANGUAGE;
            }
            case 558: {
                return ItemType.NAME;
            }
            case 556: {
                return ItemType.NMTOKEN;
            }
            case 559: {
                return ItemType.NCNAME;
            }
            case 560: {
                return ItemType.ID;
            }
            case 561: {
                return ItemType.IDREF;
            }
            case 563: {
                return ItemType.ENTITY;
            }
            case 565: {
                return ItemType.DATE_TIME_STAMP;
            }
        }
        throw new SaxonApiException("Unknown atomic type " + this.a.getUnderlyingConfiguration().getNamePool().getClarkName(n2));
    }

    public ItemType getNodeKindTest(XdmNodeKind xdmNodeKind) {
        switch (xdmNodeKind) {
            case DOCUMENT: {
                return ItemType.DOCUMENT_NODE;
            }
            case ELEMENT: {
                return ItemType.ELEMENT_NODE;
            }
            case ATTRIBUTE: {
                return ItemType.ATTRIBUTE_NODE;
            }
            case TEXT: {
                return ItemType.TEXT_NODE;
            }
            case COMMENT: {
                return ItemType.COMMENT_NODE;
            }
            case PROCESSING_INSTRUCTION: {
                return ItemType.PROCESSING_INSTRUCTION_NODE;
            }
            case NAMESPACE: {
                return ItemType.NAMESPACE_NODE;
            }
        }
        throw new IllegalArgumentException("XdmNodeKind");
    }

    public ItemType getItemType(XdmNodeKind xdmNodeKind, QName qName) {
        int n2 = xdmNodeKind.getNumber();
        if (n2 == 1 || n2 == 2 || n2 == 7) {
            if (n2 == 7 && qName.getNamespaceURI().isEmpty()) {
                throw new IllegalArgumentException("The name of a processing instruction must not be in a namespace");
            }
            NameTest nameTest = new NameTest(n2, qName.getNamespaceURI(), qName.getLocalName(), this.a.getUnderlyingConfiguration().getNamePool());
            return new b(nameTest, this.a);
        }
        throw new IllegalArgumentException("Node kind must be element, attribute, or processing-instruction");
    }

    public ItemType getSchemaElementTest(QName object) {
        Object object2 = this.a.getUnderlyingConfiguration();
        if ((object2 = ((Configuration)object2).getElementDeclaration(((QName)object).getStructuredQName())) == null) {
            throw new SaxonApiException("No global declaration found for element " + ((QName)object).getClarkName());
        }
        try {
            object = object2.makeSchemaNodeTest();
            return new b((net.sf.saxon.type.ItemType)object, this.a);
        }
        catch (MissingComponentException missingComponentException) {
            throw new SaxonApiException(missingComponentException);
        }
    }

    public ItemType getElementTest(QName object, QName qName, boolean bl2) {
        Configuration configuration = this.a.getUnderlyingConfiguration();
        NameTest nameTest = null;
        ContentTypeTest contentTypeTest = null;
        if (object != null) {
            int n2 = configuration.getNamePool().allocateFingerprint(((QName)object).getNamespaceURI(), ((QName)object).getLocalName());
            nameTest = new NameTest(1, n2, configuration.getNamePool());
        }
        if (qName != null) {
            object = configuration.getSchemaType(new StructuredQName("", qName.getNamespaceURI(), qName.getLocalName()));
            if (object == null) {
                throw new SaxonApiException("Unknown schema type " + qName.getClarkName());
            }
            contentTypeTest = new ContentTypeTest(1, (SchemaType)object, configuration, bl2);
        }
        if (contentTypeTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ELEMENT);
            }
            return new b(nameTest, this.a);
        }
        if (nameTest == null) {
            return new b(contentTypeTest, this.a);
        }
        object = new CombinedNodeTest(nameTest, 23, contentTypeTest);
        return new b((net.sf.saxon.type.ItemType)object, this.a);
    }

    public ItemType getSchemaAttributeTest(QName object) {
        Object object2 = this.a.getUnderlyingConfiguration();
        StructuredQName structuredQName = new StructuredQName("", ((QName)object).getNamespaceURI(), ((QName)object).getLocalName());
        if ((object2 = ((Configuration)object2).getAttributeDeclaration(structuredQName)) == null) {
            throw new SaxonApiException("No global declaration found for attribute " + ((QName)object).getClarkName());
        }
        try {
            object = object2.makeSchemaNodeTest();
            return new b((net.sf.saxon.type.ItemType)object, this.a);
        }
        catch (MissingComponentException missingComponentException) {
            throw new SaxonApiException(missingComponentException);
        }
    }

    public ItemType getAttributeTest(QName object, QName qName) {
        NameTest nameTest = null;
        ContentTypeTest contentTypeTest = null;
        Configuration configuration = this.a.getUnderlyingConfiguration();
        if (object != null) {
            int n2 = configuration.getNamePool().allocateFingerprint(((QName)object).getNamespaceURI(), ((QName)object).getLocalName());
            nameTest = new NameTest(2, n2, configuration.getNamePool());
        }
        if (qName != null) {
            object = configuration.getSchemaType(new StructuredQName("", qName.getNamespaceURI(), qName.getLocalName()));
            if (object == null) {
                throw new SaxonApiException("Unknown schema type " + qName.getClarkName());
            }
            contentTypeTest = new ContentTypeTest(2, (SchemaType)object, configuration, false);
        }
        if (contentTypeTest == null) {
            if (nameTest == null) {
                return this.getNodeKindTest(XdmNodeKind.ATTRIBUTE);
            }
            return new b(nameTest, this.a);
        }
        if (nameTest == null) {
            return new b(contentTypeTest, this.a);
        }
        object = new CombinedNodeTest(nameTest, 23, contentTypeTest);
        return new b((net.sf.saxon.type.ItemType)object, this.a);
    }

    public ItemType getDocumentTest(ItemType object) {
        if ((object = ((ItemType)object).getUnderlyingItemType()).getPrimitiveType() != 1) {
            throw new IllegalArgumentException("Supplied itemType is not an element test");
        }
        object = new DocumentNodeTest((NodeTest)object);
        return new b((net.sf.saxon.type.ItemType)object, this.a);
    }

    public ItemType getExternalObjectType(Class object) {
        object = this.a.getUnderlyingConfiguration().getJavaExternalObjectType((Class)object);
        return new b((net.sf.saxon.type.ItemType)object, this.a);
    }

    public XdmItem getExternalObject(Object object) {
        return (XdmItem)XdmItem.wrap(new ObjectValue<Object>(object));
    }

    public ItemType getMapType(ItemType itemType, SequenceType sequenceType) {
        if (!(itemType.getUnderlyingItemType() instanceof AtomicType)) {
            throw new IllegalArgumentException("Map key must be atomic");
        }
        return new b(new MapType((AtomicType)itemType.getUnderlyingItemType(), sequenceType.getUnderlyingSequenceType()), this.a);
    }

    public ItemType getArrayType(SequenceType sequenceType) {
        return new b(new ArrayItemType(sequenceType.getUnderlyingSequenceType()), this.a);
    }

    public XdmMap newMap(Map<?, ?> map) {
        try {
            return XdmMap.makeMap(map);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SaxonApiException(illegalArgumentException);
        }
    }

    public ItemType getItemType(XdmItem iterable) {
        if (((XdmItem)iterable).isAtomicValue()) {
            iterable = (AtomicValue)((XdmItem)iterable).getUnderlyingValue();
            AtomicType atomicType = ((AtomicValue)iterable).getItemType();
            return new b(atomicType, this.a);
        }
        if (((XdmItem)iterable).getUnderlyingValue() instanceof NodeInfo) {
            iterable = (NodeInfo)((XdmItem)iterable).getUnderlyingValue();
            int n2 = iterable.getNodeKind();
            if (iterable.getLocalPart().isEmpty()) {
                return new b(NodeKindTest.makeNodeKindTest(n2), this.a);
            }
            return new b(new SameNameTest((NodeInfo)iterable), this.a);
        }
        if ((iterable = ((XdmItem)iterable).getUnderlyingValue()) instanceof MapItem) {
            return ItemType.ANY_MAP;
        }
        if (iterable instanceof ArrayItem) {
            return ItemType.ANY_ARRAY;
        }
        if (iterable instanceof ExternalObject) {
            return new b(ExternalObjectType.THE_INSTANCE, this.a);
        }
        return ItemType.ANY_FUNCTION;
    }

    public ItemType exposeItemType(net.sf.saxon.type.ItemType itemType) {
        return new b(itemType, this.a);
    }
}

