/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Objects;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.trans.XPathException;

public class Processor
implements Configuration.ApiProvider {
    private Configuration a;
    private SchemaManager b;

    public Processor(boolean bl2) {
        if (bl2) {
            this.a = Configuration.newConfiguration();
            if (this.a.getEditionCode().equals("EE")) {
                this.b = null;
            }
        } else {
            this.a = new Configuration();
        }
        this.a.setProcessor(this);
    }

    public Processor(Configuration configuration) {
        this.a = configuration;
        if (configuration.getEditionCode().equals("EE")) {
            this.b = null;
        }
    }

    public Processor(Source source) {
        try {
            this.a = Configuration.readConfiguration(source);
            this.b = null;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        this.a.setProcessor(this);
    }

    public DocumentBuilder newDocumentBuilder() {
        return new DocumentBuilder(this.a);
    }

    public XPathCompiler newXPathCompiler() {
        return new XPathCompiler(this);
    }

    public XsltCompiler newXsltCompiler() {
        return new XsltCompiler(this);
    }

    public XQueryCompiler newXQueryCompiler() {
        return new XQueryCompiler(this);
    }

    public Serializer newSerializer() {
        return new Serializer(this);
    }

    public Serializer newSerializer(OutputStream outputStream) {
        Serializer serializer = new Serializer(this);
        serializer.setOutputStream(outputStream);
        return serializer;
    }

    public Serializer newSerializer(Writer writer) {
        Serializer serializer = new Serializer(this);
        serializer.setOutputWriter(writer);
        return serializer;
    }

    public Serializer newSerializer(File file) {
        Serializer serializer = new Serializer(this);
        serializer.setOutputFile(file);
        return serializer;
    }

    public void registerExtensionFunction(ExtensionFunction object) {
        object = new a((ExtensionFunction)object);
        this.registerExtensionFunction((ExtensionFunctionDefinition)object);
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition extensionFunctionDefinition) {
        try {
            this.a.registerExtensionFunction(extensionFunctionDefinition);
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public SchemaManager getSchemaManager() {
        return this.b;
    }

    public boolean isSchemaAware() {
        return this.a.isLicensedFeature(1);
    }

    public String getSaxonProductVersion() {
        return Version.getProductVersion();
    }

    public String getSaxonEdition() {
        return this.a.getEditionCode();
    }

    public void setXmlVersion(String string) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 48563: {
                if (!string.equals("1.0")) break;
                n2 = 0;
                break;
            }
            case 48564: {
                if (!string.equals("1.1")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                this.a.setXMLVersion(10);
                return;
            }
            case 1: {
                this.a.setXMLVersion(11);
                return;
            }
        }
        throw new IllegalArgumentException("XmlVersion");
    }

    public String getXmlVersion() {
        if (this.a.getXMLVersion() == 10) {
            return "1.0";
        }
        return "1.1";
    }

    public void setConfigurationProperty(String string, Object object) {
        if (string.equals("http://saxon.sf.net/feature/configuration")) {
            this.a = (Configuration)object;
            return;
        }
        this.a.setConfigurationProperty(string, object);
    }

    public Object getConfigurationProperty(String string) {
        return this.a.getConfigurationProperty(string);
    }

    public <T> void setConfigurationProperty(Feature<T> feature, T t2) {
        if (feature == Feature.CONFIGURATION) {
            this.a = (Configuration)t2;
            return;
        }
        this.a.setConfigurationProperty(feature, t2);
    }

    public <T> T getConfigurationProperty(Feature<T> feature) {
        return this.a.getConfigurationProperty(feature);
    }

    public void declareCollation(String string, Comparator object) {
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new IllegalArgumentException("Cannot redeclare the Unicode codepoint collation URI");
        }
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/html-ascii-case-insensitive")) {
            throw new IllegalArgumentException("Cannot redeclare the HTML5 caseblind collation URI");
        }
        object = object instanceof RuleBasedCollator ? new RuleBasedSubstringMatcher(string, (RuleBasedCollator)object) : new SimpleCollation(string, (Comparator)object);
        this.a.registerCollation(string, (StringCollator)object);
    }

    public Configuration getUnderlyingConfiguration() {
        return this.a;
    }

    public void writeXdmValue(XdmValue object, Destination destination) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(destination);
        try {
            if (!(destination instanceof Serializer)) {
                Receiver receiver = destination.getReceiver(this.a.makePipelineConfiguration(), this.a.obtainDefaultSerializationProperties());
                receiver = new NamespaceReducer(receiver);
                receiver = new TreeReceiver(receiver);
                ((SequenceReceiver)receiver).open();
                ((TreeReceiver)receiver).startDocument(0);
                object = ((XdmValue)object).iterator();
                while (object.hasNext()) {
                    XdmItem xdmItem = (XdmItem)object.next();
                    ((SequenceReceiver)receiver).append((Item)xdmItem.getUnderlyingValue(), ExplicitLocation.UNKNOWN_LOCATION, 524288);
                }
                ((TreeReceiver)receiver).endDocument();
                ((TreeReceiver)receiver).close();
                destination.closeAndNotify();
                return;
            }
            ((Serializer)destination).serializeXdmValue((XdmValue)object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    private static final class a
    extends ExtensionFunctionDefinition {
        private ExtensionFunction a;

        public a(ExtensionFunction extensionFunction) {
            this.a = extensionFunction;
        }

        @Override
        public final StructuredQName getFunctionQName() {
            return this.a.getName().getStructuredQName();
        }

        @Override
        public final int getMinimumNumberOfArguments() {
            return this.a.getArgumentTypes().length;
        }

        @Override
        public final int getMaximumNumberOfArguments() {
            return this.a.getArgumentTypes().length;
        }

        @Override
        public final net.sf.saxon.value.SequenceType[] getArgumentTypes() {
            SequenceType[] sequenceTypeArray = this.a.getArgumentTypes();
            net.sf.saxon.value.SequenceType[] sequenceTypeArray2 = new net.sf.saxon.value.SequenceType[sequenceTypeArray.length];
            for (int i2 = 0; i2 < sequenceTypeArray.length; ++i2) {
                sequenceTypeArray2[i2] = net.sf.saxon.value.SequenceType.makeSequenceType(sequenceTypeArray[i2].getItemType().getUnderlyingItemType(), sequenceTypeArray[i2].getOccurrenceIndicator().getCardinality());
            }
            return sequenceTypeArray2;
        }

        @Override
        public final net.sf.saxon.value.SequenceType getResultType(net.sf.saxon.value.SequenceType[] object) {
            object = this.a.getResultType();
            return net.sf.saxon.value.SequenceType.makeSequenceType(((SequenceType)object).getItemType().getUnderlyingItemType(), ((SequenceType)object).getOccurrenceIndicator().getCardinality());
        }

        @Override
        public final boolean trustResultType() {
            return false;
        }

        @Override
        public final boolean dependsOnFocus() {
            return false;
        }

        @Override
        public final boolean hasSideEffects() {
            return false;
        }

        @Override
        public final ExtensionFunctionCall makeCallExpression() {
            return new ExtensionFunctionCall(this){
                private /* synthetic */ a a;
                {
                    this.a = a2;
                }

                @Override
                public final Sequence<?> call(XPathContext xdmValueArray, Sequence[] sequenceArray) {
                    xdmValueArray = new XdmValue[sequenceArray.length];
                    for (int i2 = 0; i2 < xdmValueArray.length; ++i2) {
                        GroundedValue groundedValue = sequenceArray[i2].materialize();
                        xdmValueArray[i2] = XdmValue.wrap(groundedValue);
                    }
                    try {
                        XdmValue xdmValue = this.a.a.call(xdmValueArray);
                        return xdmValue.getUnderlyingValue();
                    }
                    catch (SaxonApiException saxonApiException) {
                        throw new XPathException(saxonApiException);
                    }
                }
            };
        }
    }
}

