/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.CloseNotifier;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceNormalizer;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.AbstractDestination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;

public class Serializer
extends AbstractDestination {
    private Processor a;
    private Map<StructuredQName, String> b = new HashMap<StructuredQName, String>(10);
    private StreamResult c = new StreamResult();
    private CharacterMapIndex d = null;
    private boolean e = false;
    private static Map<String, Property> f = new HashMap<String, Property>();

    protected Serializer(Processor processor) {
        this.setProcessor(processor);
    }

    public void setProcessor(Processor processor) {
        this.a = Objects.requireNonNull(processor);
    }

    public Processor getProcessor() {
        return this.a;
    }

    public void setOutputProperties(Properties properties) {
        for (String string : properties.stringPropertyNames()) {
            this.b.put(StructuredQName.fromClarkName(string), properties.getProperty(string));
        }
    }

    public void setOutputProperties(SerializationProperties serializationProperties) {
        this.setOutputProperties(serializationProperties.getProperties());
        this.setCharacterMap(serializationProperties.getCharacterMapIndex());
    }

    public void setCloseOnCompletion(boolean bl2) {
        this.e = bl2;
    }

    public void setCharacterMap(CharacterMapIndex object) {
        CharacterMapIndex characterMapIndex = this.d;
        if (characterMapIndex == null || characterMapIndex.isEmpty()) {
            characterMapIndex = object;
        } else if (object != null && !((CharacterMapIndex)object).isEmpty() && characterMapIndex != object) {
            characterMapIndex = characterMapIndex.copy();
            object = ((CharacterMapIndex)object).iterator();
            while (object.hasNext()) {
                CharacterMap characterMap = (CharacterMap)object.next();
                characterMapIndex.putCharacterMap(characterMap.getName(), characterMap);
            }
        }
        this.d = characterMapIndex;
    }

    public void setOutputProperty(Property property, String string) {
        SerializerFactory serializerFactory = this.a.getUnderlyingConfiguration().getSerializerFactory();
        try {
            string = serializerFactory.checkOutputProperty(property.toString(), string);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
        if (string == null) {
            this.b.remove(property.getQName().getStructuredQName());
            return;
        }
        this.b.put(property.getQName().getStructuredQName(), string);
    }

    public String getOutputProperty(Property property) {
        return this.b.get(property.getQName().getStructuredQName());
    }

    public void setOutputProperty(QName qName, String string) {
        SerializerFactory serializerFactory = this.a.getUnderlyingConfiguration().getSerializerFactory();
        String string2 = qName.getNamespaceURI();
        if (string2.isEmpty() || string2.equals("http://saxon.sf.net/")) {
            try {
                string = serializerFactory.checkOutputProperty(qName.getClarkName(), string);
            }
            catch (XPathException xPathException) {
                throw new IllegalArgumentException(xPathException.getMessage());
            }
            if (string2.equals("http://saxon.sf.net/") && qName.getLocalName().equals("next-in-chain")) {
                throw new IllegalArgumentException("saxon:next-in-chain is not a serialization property");
            }
        }
        if (string == null) {
            this.b.remove(qName.getStructuredQName());
            return;
        }
        this.b.put(qName.getStructuredQName(), string);
    }

    public String getOutputProperty(QName qName) {
        return this.b.get(qName.getStructuredQName());
    }

    public void setOutputWriter(Writer writer) {
        this.c.setOutputStream(null);
        this.c.setSystemId((String)null);
        this.c.setWriter(writer);
        this.e = false;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.c.setWriter(null);
        this.c.setSystemId((String)null);
        this.c.setOutputStream(outputStream);
        this.e = false;
    }

    public void setOutputFile(File file) {
        this.c.setOutputStream(null);
        this.c.setWriter(null);
        this.c.setSystemId(file);
        this.setDestinationBaseURI(file.toURI());
        this.e = true;
    }

    public void serializeNode(XdmNode xdmNode) {
        StreamResult streamResult = this.c;
        if (streamResult.getOutputStream() == null && streamResult.getWriter() == null && streamResult.getSystemId() == null) {
            throw new IllegalStateException("Either an outputStream, or a Writer, or a File must be supplied");
        }
        this.a(xdmNode, streamResult);
    }

    public void serializeXdmValue(XdmValue xdmValue) {
        if (xdmValue instanceof XdmNode) {
            this.serializeNode((XdmNode)xdmValue);
        } else {
            try {
                SerializationProperties serializationProperties = new SerializationProperties(this.getLocallyDefinedProperties(), this.d);
                QueryResult.serializeSequence(xdmValue.getUnderlyingValue().iterate(), this.a.getUnderlyingConfiguration(), (Result)this.c, serializationProperties);
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException(xPathException);
            }
        }
        this.closeAndNotify();
    }

    public String serializeNodeToString(XdmNode xdmNode) {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        this.a(xdmNode, streamResult);
        return stringWriter.toString();
    }

    private void a(XdmNode xdmNode, Result result) {
        try {
            QueryResult.serialize(xdmNode.getUnderlyingNode(), result, this.getLocallyDefinedProperties());
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public StreamWriterToReceiver getXMLStreamWriter() {
        Object object = this.a.getUnderlyingConfiguration().makePipelineConfiguration();
        object = this.getReceiver((PipelineConfiguration)object, this.getSerializationProperties());
        object = new NamespaceReducer((Receiver)object);
        return new StreamWriterToReceiver((Receiver)object);
    }

    public ContentHandler getContentHandler() {
        Object object = this.a.getUnderlyingConfiguration().makePipelineConfiguration();
        object = this.getReceiver((PipelineConfiguration)object, this.getSerializationProperties());
        object = new NamespaceReducer((Receiver)object);
        ReceivingContentHandler receivingContentHandler = new ReceivingContentHandler();
        receivingContentHandler.setReceiver((Receiver)object);
        receivingContentHandler.setPipelineConfiguration(object.getPipelineConfiguration());
        return receivingContentHandler;
    }

    public Object getOutputDestination() {
        if (this.c.getOutputStream() != null) {
            return this.c.getOutputStream();
        }
        if (this.c.getWriter() != null) {
            return this.c.getWriter();
        }
        String string = this.c.getSystemId();
        if (string != null) {
            try {
                return new File(new URI(string));
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Receiver getReceiver(PipelineConfiguration object, SerializationProperties serializationProperties) {
        try {
            SerializerFactory serializerFactory = ((PipelineConfiguration)object).getConfiguration().getSerializerFactory();
            serializationProperties = this.getSerializationProperties().combineWith(serializationProperties);
            object = serializerFactory.getReceiver((Result)this.c, serializationProperties, (PipelineConfiguration)object);
            if (this.helper.getListeners() != null) {
                if (object instanceof SequenceNormalizer) {
                    ((SequenceNormalizer)object).onClose(this.helper.getListeners());
                } else {
                    object = new CloseNotifier((Receiver)object, this.helper.getListeners());
                }
            }
            if (object.getSystemId() == null && this.getDestinationBaseURI() != null) {
                object.setSystemId(this.getDestinationBaseURI().toASCIIString());
            }
            return object;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public Properties getCombinedOutputProperties(Properties properties) {
        properties = properties == null ? new Properties() : new Properties(properties);
        for (StructuredQName structuredQName : this.b.keySet()) {
            String string = this.b.get(structuredQName);
            properties.setProperty(structuredQName.getClarkName(), string);
        }
        return properties;
    }

    protected Properties getLocallyDefinedProperties() {
        Properties properties = new Properties();
        for (StructuredQName structuredQName : this.b.keySet()) {
            String string = this.b.get(structuredQName);
            properties.setProperty(structuredQName.getClarkName(), string);
        }
        return properties;
    }

    public SerializationProperties getSerializationProperties() {
        return new SerializationProperties(this.getLocallyDefinedProperties(), this.d);
    }

    protected Result getResult() {
        return this.c;
    }

    @Override
    public void close() {
        if (this.e) {
            Closeable closeable = this.c.getOutputStream();
            if (closeable != null) {
                try {
                    ((OutputStream)closeable).close();
                }
                catch (IOException iOException) {
                    throw new SaxonApiException("Failed while closing output file", iOException);
                }
            }
            if ((closeable = this.c.getWriter()) != null) {
                try {
                    ((Writer)closeable).close();
                    return;
                }
                catch (IOException iOException) {
                    throw new SaxonApiException("Failed while closing output file", iOException);
                }
            }
        }
    }

    public static Property getProperty(QName object) {
        Property property = f.get(object = ((QName)object).getClarkName());
        if (property != null) {
            return property;
        }
        throw new IllegalArgumentException("Unknown serialization property " + (String)object);
    }

    public boolean isMustCloseAfterUse() {
        return this.e;
    }

    static {
        for (Property property : Property.values()) {
            f.put(property.a, property);
        }
    }

    public static enum Property {
        METHOD("method"),
        VERSION("version"),
        ENCODING("encoding"),
        OMIT_XML_DECLARATION("omit-xml-declaration"),
        STANDALONE("standalone"),
        DOCTYPE_PUBLIC("doctype-public"),
        DOCTYPE_SYSTEM("doctype-system"),
        CDATA_SECTION_ELEMENTS("cdata-section-elements"),
        INDENT("indent"),
        MEDIA_TYPE("media-type"),
        USE_CHARACTER_MAPS("use-character-maps"),
        INCLUDE_CONTENT_TYPE("include-content-type"),
        UNDECLARE_PREFIXES("undeclare-prefixes"),
        ESCAPE_URI_ATTRIBUTES("escape-uri-attributes"),
        BYTE_ORDER_MARK("byte-order-mark"),
        NORMALIZATION_FORM("normalization-form"),
        ITEM_SEPARATOR("item-separator"),
        HTML_VERSION("html-version"),
        BUILD_TREE("build-tree"),
        SAXON_INDENT_SPACES("{http://saxon.sf.net/}indent-spaces"),
        SAXON_LINE_LENGTH("{http://saxon.sf.net/}line-length"),
        SAXON_ATTRIBUTE_ORDER("{http://saxon.sf.net/}attribute-order"),
        SAXON_CANONICAL("{http://saxon.sf.net/}canonical"),
        SAXON_NEWLINE("{http://saxon.sf.net/}newline"),
        SAXON_SUPPRESS_INDENTATION("suppress-indentation"),
        SAXON_DOUBLE_SPACE("{http://saxon.sf.net/}double-space"),
        SAXON_STYLESHEET_VERSION("{http://saxon.sf.net/}stylesheet-version"),
        SAXON_CHARACTER_REPRESENTATION("{http://saxon.sf.net/}character-representation"),
        SAXON_RECOGNIZE_BINARY("{http://saxon.sf.net/}recognize-binary"),
        SAXON_REQUIRE_WELL_FORMED("{http://saxon.sf.net/}require-well-formed"),
        SAXON_WRAP("{http://saxon.sf.net/}wrap-result-sequence"),
        SAXON_IMPLICIT_RESULT_DOCUMENT("{http://saxon.sf.net/}implicit-result-document"),
        SAXON_SUPPLY_SOURCE_LOCATOR("{http://saxon.sf.net/}supply-source-locator");

        private String a;

        private Property(String string2) {
            this.a = string2;
        }

        public final String toString() {
            return this.a;
        }

        public final QName getQName() {
            return QName.fromClarkName(this.a);
        }

        public static Property get(String string) {
            for (Property property : Property.values()) {
                if (!property.a.equals(string)) continue;
                return property;
            }
            return null;
        }
    }
}

