/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.DecimalSymbols;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XPathCompiler {
    private Processor a;
    private XPathEvaluator b;
    private IndependentContext c;
    private ItemType d;
    private Map<String, XPathExecutable> e = null;

    protected XPathCompiler(Processor processor) {
        this.a = processor;
        this.b = new XPathEvaluator(processor.getUnderlyingConfiguration());
        this.c = (IndependentContext)this.b.getStaticContext();
    }

    public Processor getProcessor() {
        return this.a;
    }

    public void setBackwardsCompatible(boolean bl2) {
        if (this.e != null) {
            this.e.clear();
        }
        this.c.setBackwardsCompatibilityMode(bl2);
    }

    public boolean isBackwardsCompatible() {
        return this.c.isInBackwardsCompatibleMode();
    }

    public void setSchemaAware(boolean bl2) {
        if (bl2 && !this.a.getUnderlyingConfiguration().isLicensedFeature(1)) {
            throw new UnsupportedOperationException("Schema processing requires a licensed Saxon-EE configuration");
        }
        this.c.setSchemaAware(bl2);
    }

    public boolean isSchemaAware() {
        return this.c.getPackageData().isSchemaAware();
    }

    public void setLanguageVersion(String string) {
        int n2;
        if (this.e != null) {
            this.e.clear();
        }
        if ("1.0".equals(string)) {
            n2 = 20;
            this.c.setBackwardsCompatibilityMode(true);
        } else if ("2.0".equals(string)) {
            n2 = 20;
        } else if ("3.0".equals(string) || "3.05".equals(string)) {
            n2 = 30;
        } else if ("3.1".equals(string)) {
            n2 = 31;
        } else {
            throw new IllegalArgumentException("XPath version");
        }
        this.c.setXPathLanguageLevel(n2);
        this.c.setDefaultFunctionLibrary(n2);
    }

    public String getLanguageVersion() {
        if (this.c.getXPathVersion() == 20) {
            return "2.0";
        }
        if (this.c.getXPathVersion() == 30) {
            return "3.0";
        }
        if (this.c.getXPathVersion() == 31) {
            return "3.1";
        }
        throw new IllegalStateException("Unknown XPath version " + this.c.getXPathVersion());
    }

    public void setBaseURI(URI uRI) {
        if (this.e != null) {
            this.e.clear();
        }
        if (uRI == null) {
            this.c.setBaseURI(null);
            return;
        }
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.c.setBaseURI(uRI.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.c.getStaticBaseURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public void declareNamespace(String string, String string2) {
        if (this.e != null) {
            this.e.clear();
        }
        this.c.declareNamespace(string, string2);
    }

    public void importSchemaNamespace(String string) {
        if (this.e != null) {
            this.e.clear();
        }
        this.c.getImportedSchemaNamespaces().add(string);
        this.c.setSchemaAware(true);
    }

    public void setAllowUndeclaredVariables(boolean bl2) {
        if (this.e != null) {
            this.e.clear();
        }
        this.c.setAllowUndeclaredVariables(bl2);
    }

    public boolean isAllowUndeclaredVariables() {
        return this.c.isAllowUndeclaredVariables();
    }

    public void declareVariable(QName qName) {
        if (this.e != null) {
            this.e.clear();
        }
        this.c.declareVariable(qName.getNamespaceURI(), qName.getLocalName());
    }

    public void declareVariable(QName object, ItemType itemType, OccurrenceIndicator occurrenceIndicator) {
        if (this.e != null) {
            this.e.clear();
        }
        object = this.c.declareVariable(((QName)object).getNamespaceURI(), ((QName)object).getLocalName());
        ((XPathVariable)object).setRequiredType(SequenceType.makeSequenceType(itemType.getUnderlyingItemType(), occurrenceIndicator.getCardinality()));
    }

    public void setRequiredContextItemType(ItemType itemType) {
        this.d = itemType;
        this.c.setRequiredContextItemType(itemType.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.d;
    }

    public void declareDefaultCollation(String string) {
        StringCollator stringCollator;
        try {
            stringCollator = this.getProcessor().getUnderlyingConfiguration().getCollation(string);
        }
        catch (XPathException xPathException) {
            stringCollator = null;
        }
        if (stringCollator == null) {
            throw new IllegalStateException("Unknown collation " + string);
        }
        this.c.setDefaultCollationName(string);
    }

    public void setCaching(boolean bl2) {
        if (bl2) {
            if (this.e == null) {
                this.e = new ConcurrentHashMap<String, XPathExecutable>();
                return;
            }
        } else {
            this.e = null;
        }
    }

    public boolean isCaching() {
        return this.e != null;
    }

    public void setFastCompilation(boolean bl2) {
        if (bl2) {
            this.c.setOptimizerOptions(new OptimizerOptions(0));
            return;
        }
        this.c.setOptimizerOptions(this.getProcessor().getUnderlyingConfiguration().getOptimizerOptions());
    }

    public boolean isFastCompilation() {
        return this.c.getOptimizerOptions().getOptions() == 0;
    }

    public XPathExecutable compile(String string) {
        Objects.requireNonNull(string);
        if (this.e != null) {
            XPathCompiler xPathCompiler = this;
            synchronized (xPathCompiler) {
                XPathExecutable xPathExecutable = this.e.get(string);
                if (xPathExecutable == null) {
                    xPathExecutable = this.a(string);
                    this.e.put(string, xPathExecutable);
                }
                return xPathExecutable;
            }
        }
        return this.a(string);
    }

    private XPathExecutable a(String string) {
        Object object;
        try {
            this.c.getDecimalFormatManager().checkConsistency();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        XPathEvaluator xPathEvaluator = this.b;
        IndependentContext independentContext = this.c;
        if (independentContext.isAllowUndeclaredVariables()) {
            xPathEvaluator = new XPathEvaluator(this.a.getUnderlyingConfiguration());
            independentContext = new IndependentContext(this.c);
            xPathEvaluator.setStaticContext(independentContext);
            object = this.c.iterateExternalVariables();
            while (object.hasNext()) {
                XPathVariable xPathVariable = (XPathVariable)object.next();
                XPathVariable xPathVariable2 = independentContext.declareVariable(xPathVariable.getVariableQName());
                xPathVariable2.setRequiredType(xPathVariable.getRequiredType());
            }
        }
        try {
            object = xPathEvaluator.createExpression(string);
            return new XPathExecutable((XPathExpression)object, this.a, independentContext);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XdmValue evaluate(String object, XdmItem xdmItem) {
        Objects.requireNonNull(object);
        object = this.compile((String)object).load();
        if (xdmItem != null) {
            ((XPathSelector)object).setContextItem(xdmItem);
        }
        return ((XPathSelector)object).evaluate();
    }

    public XdmItem evaluateSingle(String object, XdmItem xdmItem) {
        Objects.requireNonNull(object);
        object = this.compile((String)object).load();
        if (xdmItem != null) {
            ((XPathSelector)object).setContextItem(xdmItem);
        }
        return ((XPathSelector)object).evaluateSingle();
    }

    public XPathExecutable compilePattern(String object) {
        Objects.requireNonNull(object);
        try {
            this.c.getDecimalFormatManager().checkConsistency();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        try {
            object = this.b.createPattern((String)object);
            return new XPathExecutable((XPathExpression)object, this.a, this.c);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void setDecimalFormatProperty(QName object, String string, String string2) {
        Object object2 = this.c.getDecimalFormatManager();
        if (object2 == null) {
            object2 = new DecimalFormatManager(54, this.c.getXPathVersion());
            this.c.setDecimalFormatManager((DecimalFormatManager)object2);
        }
        object = ((DecimalFormatManager)object2).obtainNamedDecimalFormat(((QName)object).getStructuredQName());
        try {
            switch (string) {
                case "decimal-separator": {
                    ((DecimalSymbols)object).setDecimalSeparator(string2);
                    break;
                }
                case "grouping-separator": {
                    ((DecimalSymbols)object).setGroupingSeparator(string2);
                    break;
                }
                case "exponent-separator": {
                    ((DecimalSymbols)object).setExponentSeparator(string2);
                    break;
                }
                case "infinity": {
                    ((DecimalSymbols)object).setInfinity(string2);
                    break;
                }
                case "NaN": {
                    ((DecimalSymbols)object).setNaN(string2);
                    break;
                }
                case "minus-sign": {
                    ((DecimalSymbols)object).setMinusSign(string2);
                    break;
                }
                case "percent": {
                    ((DecimalSymbols)object).setPercent(string2);
                    break;
                }
                case "per-mille": {
                    ((DecimalSymbols)object).setPerMille(string2);
                    break;
                }
                case "zero-digit": {
                    ((DecimalSymbols)object).setZeroDigit(string2);
                    break;
                }
                case "digit": {
                    ((DecimalSymbols)object).setDigit(string2);
                    break;
                }
                case "pattern-separator": {
                    ((DecimalSymbols)object).setPatternSeparator(string2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown decimal format attribute " + string);
                }
            }
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public StaticContext getUnderlyingStaticContext() {
        return this.c;
    }
}

