/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.Map;
import javax.xml.transform.URIResolver;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.XdmStream;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;

public class XPathSelector
implements Iterable<XdmItem> {
    private XPathExpression a;
    private XPathDynamicContext b;
    private Map<StructuredQName, XPathVariable> c;

    protected XPathSelector(XPathExpression xPathExpression, Map<StructuredQName, XPathVariable> map) {
        this.a = xPathExpression;
        this.c = map;
        this.b = xPathExpression.createDynamicContext();
    }

    public void setContextItem(XdmItem xdmItem) {
        Object t2;
        if (xdmItem == null) {
            throw new NullPointerException("contextItem");
        }
        if (!this.a.getInternalExpression().getPackageData().isSchemaAware() && (t2 = xdmItem.getUnderlyingValue().head()) instanceof NodeInfo && ((NodeInfo)t2).getTreeInfo().isTyped()) {
            throw new SaxonApiException("The supplied node has been schema-validated, but the XPath expression was compiled without schema-awareness");
        }
        try {
            this.b.setContextItem((Item<?>)xdmItem.getUnderlyingValue());
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XdmItem getContextItem() {
        return XdmItem.wrapItem(this.b.getContextItem());
    }

    public void setVariable(QName qName, XdmValue xdmValue) {
        Object object = qName.getStructuredQName();
        if ((object = this.c.get(object)) == null) {
            throw new SaxonApiException(new XPathException("Variable has not been declared: " + qName));
        }
        try {
            this.b.setVariable((XPathVariable)object, xdmValue.getUnderlyingValue());
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.b.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.b.getURIResolver();
    }

    public XdmValue evaluate() {
        GroundedValue<?> groundedValue;
        try {
            groundedValue = this.a.iterate(this.b).materialize();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        return XdmValue.wrap(groundedValue);
    }

    public XdmItem evaluateSingle() {
        try {
            Item item = this.a.evaluateSingle(this.b);
            if (item == null) {
                return null;
            }
            return (XdmItem)XdmValue.wrap(item);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    @Override
    public XdmSequenceIterator<XdmItem> iterator() {
        try {
            return new XdmSequenceIterator<XdmItem>(this.a.iterate(this.b));
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public XdmStream<XdmItem> stream() {
        return ((XdmSequenceIterator)this.iterator()).stream();
    }

    public boolean effectiveBooleanValue() {
        try {
            return this.a.effectiveBooleanValue(this.b);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XPathDynamicContext getUnderlyingXPathContext() {
        return this.b;
    }
}

