/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.StaticError;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.b;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class XQueryCompiler {
    private Processor a;
    private StaticQueryContext b;
    private ItemType c;
    private String d;

    protected XQueryCompiler(Processor processor) {
        this.a = processor;
        this.b = processor.getUnderlyingConfiguration().newStaticQueryContext();
    }

    public Processor getProcessor() {
        return this.a;
    }

    public void setBaseURI(URI uRI) {
        if (uRI == null) {
            this.b.setBaseURI(null);
            return;
        }
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Base URI must be an absolute URI: " + uRI);
        }
        this.b.setBaseURI(uRI.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.b.getBaseURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.b.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.b.getErrorListener();
    }

    public void setCompileWithTracing(boolean bl2) {
        this.b.setCompileWithTracing(bl2);
    }

    public boolean isCompileWithTracing() {
        return this.b.isCompileWithTracing();
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.b.setModuleURIResolver(moduleURIResolver);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.b.getModuleURIResolver();
    }

    public void setEncoding(String string) {
        this.d = string;
    }

    public String getEncoding() {
        return this.d;
    }

    public void setUpdatingEnabled(boolean bl2) {
        if (bl2 && !this.b.getConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("XQuery Update is not supported in this Saxon Configuration");
        }
        this.b.setUpdatingEnabled(bl2);
    }

    public boolean isUpdatingEnabled() {
        return this.b.isUpdatingEnabled();
    }

    public void setSchemaAware(boolean bl2) {
        if (bl2 && !this.a.getUnderlyingConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("Schema-awareness requires a Saxon-EE license");
        }
        this.b.setSchemaAware(bl2);
    }

    public boolean isSchemaAware() {
        return this.b.isSchemaAware();
    }

    public void setStreaming(boolean bl2) {
        this.b.setStreaming(bl2);
        if (bl2 && !this.a.getUnderlyingConfiguration().isLicensedFeature(4)) {
            throw new UnsupportedOperationException("Streaming requires a Saxon-EE license");
        }
        if (bl2) {
            this.setRequiredContextItemType(new b(NodeKindTest.DOCUMENT, this.getProcessor()));
        }
    }

    public boolean isStreaming() {
        return this.b.isStreaming();
    }

    public void setLanguageVersion(String string) {
        if (!"3.1".equals(string)) {
            this.b.getErrorListener().warning(new XPathException("XQuery version ignored: only \"3.1\" is recognized"));
        }
        this.b.setLanguageVersion(31);
    }

    public String getLanguageVersion() {
        return "3.1";
    }

    public void declareNamespace(String string, String string2) {
        this.b.declareNamespace(string, string2);
    }

    public void declareDefaultCollation(String string) {
        this.b.declareDefaultCollation(string);
    }

    public void setRequiredContextItemType(ItemType itemType) {
        this.c = itemType;
        this.b.setRequiredContextItemType(itemType.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.c;
    }

    public void setFastCompilation(boolean bl2) {
        if (bl2) {
            this.b.setOptimizerOptions(new OptimizerOptions(0));
            return;
        }
        this.b.setOptimizerOptions(this.getProcessor().getUnderlyingConfiguration().getOptimizerOptions());
    }

    public boolean isFastCompilation() {
        return this.b.getOptimizerOptions().getOptions() == 0;
    }

    public void compileLibrary(String string) {
        try {
            this.b.compileLibrary(string);
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void compileLibrary(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                String string = this.b.getBaseURI();
                this.b.setBaseURI(file.toURI().toString());
                this.b.compileLibrary(fileInputStream, this.d);
                this.b.setBaseURI(string);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileInputStream.close();
                    }
                    throw throwable4;
                }
            }
            fileInputStream.close();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void compileLibrary(Reader reader) {
        try {
            this.b.compileLibrary(reader);
            return;
        }
        catch (IOException | XPathException exception) {
            throw new SaxonApiException(exception);
        }
    }

    public void compileLibrary(InputStream inputStream) {
        try {
            this.b.compileLibrary(inputStream, this.d);
            return;
        }
        catch (IOException | XPathException exception) {
            throw new SaxonApiException(exception);
        }
    }

    public XQueryExecutable compile(String string) {
        try {
            return new XQueryExecutable(this.a, this.b.compileQuery(string));
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XQueryExecutable compile(File object) {
        FileInputStream fileInputStream = new FileInputStream((File)object);
        Throwable throwable = null;
        try {
            String string = this.b.getBaseURI();
            this.b.setBaseURI(((File)object).toURI().toString());
            object = new XQueryExecutable(this.a, this.b.compileQuery(fileInputStream, this.d));
            this.b.setBaseURI(string);
        }
        catch (Throwable throwable2) {
            try {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        fileInputStream.close();
                    }
                    throw throwable4;
                }
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException(xPathException);
            }
        }
        fileInputStream.close();
        return object;
    }

    public XQueryExecutable compile(InputStream inputStream) {
        try {
            return new XQueryExecutable(this.a, this.b.compileQuery(inputStream, this.d));
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XQueryExecutable compile(Reader reader) {
        try {
            return new XQueryExecutable(this.a, this.b.compileQuery(reader));
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public StaticQueryContext getUnderlyingStaticContext() {
        return this.b;
    }

    public void setErrorList(List<StaticError> list) {
        this.b.setErrorListener(new ErrorGatherer(list));
    }
}

