/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.RegularSequenceChecker;
import net.sf.saxon.event.SequenceNormalizer;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.AbstractDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XQueryEvaluator
extends AbstractDestination
implements Iterable<XdmItem> {
    private Processor a;
    private XQueryExpression b;
    private DynamicQueryContext c;
    private Controller d;
    private Destination e;
    private Set<XdmNode> f;
    private Builder g;

    protected XQueryEvaluator(Processor processor, XQueryExpression xQueryExpression) {
        this.a = processor;
        this.b = xQueryExpression;
        this.c = new DynamicQueryContext(xQueryExpression.getConfiguration());
    }

    public void setSchemaValidationMode(ValidationMode validationMode) {
        if (validationMode != null) {
            this.c.setSchemaValidationMode(validationMode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.c.getSchemaValidationMode());
    }

    public void setSource(Source source) {
        if (source instanceof NodeInfo) {
            this.setContextItem(new XdmNode((NodeInfo)source));
            return;
        }
        if (source instanceof DOMSource) {
            XQueryEvaluator xQueryEvaluator = this;
            xQueryEvaluator.setContextItem(xQueryEvaluator.a.newDocumentBuilder().wrap(source));
            return;
        }
        XQueryEvaluator xQueryEvaluator = this;
        xQueryEvaluator.setContextItem(xQueryEvaluator.a.newDocumentBuilder().build(source));
    }

    public void setContextItem(XdmItem xdmItem) {
        if (xdmItem != null) {
            GlobalContextRequirement globalContextRequirement = this.b.getExecutable().getGlobalContextRequirement();
            if (globalContextRequirement != null && !globalContextRequirement.isExternal()) {
                throw new SaxonApiException("The context item for the query is not defined as external");
            }
            this.c.setContextItem((Item)xdmItem.getUnderlyingValue());
        }
    }

    public XdmItem getContextItem() {
        Item item = this.c.getContextItem();
        if (item == null) {
            return null;
        }
        return (XdmItem)XdmValue.wrap(item);
    }

    public void setExternalVariable(QName qName, XdmValue xdmValue) {
        try {
            this.c.setParameter(qName.getStructuredQName(), xdmValue == null ? null : xdmValue.getUnderlyingValue().materialize());
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public XdmValue getExternalVariable(QName object) {
        if ((object = this.c.getParameter(((QName)object).getStructuredQName())) == null) {
            return null;
        }
        return XdmValue.wrap(object);
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.c.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.c.getURIResolver();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.c.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.c.getErrorListener();
    }

    public void setTraceListener(TraceListener traceListener) {
        this.c.setTraceListener(traceListener);
    }

    public TraceListener getTraceListener() {
        return this.c.getTraceListener();
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.c.setTraceFunctionDestination(logger);
    }

    public Logger getTraceFunctionDestination() {
        return this.c.getTraceFunctionDestination();
    }

    public void setDestination(Destination destination) {
        this.e = destination;
    }

    public void run() {
        block5: {
            try {
                if (this.b.isUpdateQuery()) {
                    Object object = this.b.runUpdate(this.c);
                    this.f = new HashSet<XdmNode>();
                    object = object.iterator();
                    while (object.hasNext()) {
                        MutableNodeInfo mutableNodeInfo = (MutableNodeInfo)object.next();
                        this.f.add(XdmNode.wrapItem(mutableNodeInfo));
                    }
                    break block5;
                }
                if (this.e == null) {
                    throw new IllegalStateException("No destination supplied");
                }
                XQueryEvaluator xQueryEvaluator = this;
                xQueryEvaluator.run(xQueryEvaluator.e);
                return;
            }
            catch (TransformerException transformerException) {
                throw new SaxonApiException(transformerException);
            }
        }
    }

    public void run(Destination destination) {
        if (this.b.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            Destination destination2 = destination;
            Object object = this;
            Executable executable = ((XQueryEvaluator)object).b.getExecutable();
            object = ((XQueryEvaluator)object).b.getConfiguration().makePipelineConfiguration();
            object = destination2.getReceiver((PipelineConfiguration)object, executable.getPrimarySerializationProperties());
            object = Configuration.isAssertionsEnabled() ? new RegularSequenceChecker((Receiver)object) : object;
            this.b.run(this.c, (Result)object, null);
            destination.closeAndNotify();
            return;
        }
        catch (TransformerException transformerException) {
            throw new SaxonApiException(transformerException);
        }
    }

    public void runStreamed(Source source, Destination object) {
        Object object2;
        if (this.b.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating; cannot run with streaming");
        }
        Configuration configuration = this.c.getConfiguration();
        if (configuration.isTiming()) {
            object2 = source.getSystemId();
            if (object2 == null) {
                object2 = "";
            }
            configuration.getStandardErrorOutput().println("Processing streamed input " + (String)object2);
        }
        try {
            object2 = this.b.getExecutable().getPrimarySerializationProperties();
            object = object.getReceiver(configuration.makePipelineConfiguration(), (SerializationProperties)object2);
            this.b.runStreamed(this.c, source, (Result)object, null);
            return;
        }
        catch (TransformerException transformerException) {
            throw new SaxonApiException(transformerException);
        }
    }

    public XdmValue evaluate() {
        if (this.b.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            SequenceIterator<?> sequenceIterator = this.b.iterator(this.c);
            return XdmValue.wrap(sequenceIterator.materialize());
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XdmItem evaluateSingle() {
        try {
            SequenceIterator<?> sequenceIterator = this.b.iterator(this.c);
            sequenceIterator = sequenceIterator.next();
            if (sequenceIterator == null) {
                return null;
            }
            return (XdmItem)XdmValue.wrap(sequenceIterator);
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    @Override
    public XdmSequenceIterator<XdmItem> iterator() {
        if (this.b.isUpdateQuery()) {
            throw new IllegalStateException("Query is updating");
        }
        try {
            return new XdmSequenceIterator<XdmItem>(this.b.iterator(this.c));
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    @Override
    public Receiver getReceiver(PipelineConfiguration object, SerializationProperties serializationProperties) {
        if (this.e == null) {
            throw new IllegalStateException("No destination has been supplied");
        }
        try {
            if (this.d == null) {
                this.d = this.b.newController(this.c);
            } else {
                this.c.initializeController(this.d);
            }
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        this.g = this.d.makeBuilder();
        if (this.g instanceof TinyBuilder) {
            ((TinyBuilder)this.g).setStatistics(this.c.getConfiguration().getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
        }
        object = this.d.makeStripper(this.g);
        object = serializationProperties.makeSequenceNormalizer((Receiver)object);
        ((SequenceNormalizer)object).onClose(() -> {
            NodeInfo nodeInfo = this.g.getCurrentRoot();
            nodeInfo.getTreeInfo().setSpaceStrippingRule(this.d.getSpaceStrippingRule());
            this.setSource(nodeInfo);
            this.g = null;
            if (nodeInfo == null) {
                throw new SaxonApiException("No source document has been built by the previous pipeline stage");
            }
            XQueryEvaluator xQueryEvaluator = this;
            xQueryEvaluator.run(xQueryEvaluator.e);
            this.e.closeAndNotify();
        });
        return object;
    }

    @Override
    public void close() {
    }

    public Iterator<XdmNode> getUpdatedDocuments() {
        return this.f.iterator();
    }

    public XdmValue callFunction(QName qName, XdmValue[] xdmValueArray) {
        UserFunction userFunction = this.b.getMainModule().getUserDefinedFunction(qName.getNamespaceURI(), qName.getLocalName(), xdmValueArray.length);
        if (userFunction == null) {
            throw new SaxonApiException("No function with name " + qName.getClarkName() + " and arity " + xdmValueArray.length + " has been declared in the query");
        }
        try {
            if (this.d == null) {
                this.d = this.b.newController(this.c);
            } else {
                this.c.initializeController(this.d);
            }
            Configuration configuration = this.a.getUnderlyingConfiguration();
            Sequence[] sequenceArray = SequenceTool.makeSequenceArray(xdmValueArray.length);
            for (int i2 = 0; i2 < xdmValueArray.length; ++i2) {
                SequenceType sequenceType = userFunction.getParameterDefinitions()[i2].getRequiredType();
                sequenceArray[i2] = xdmValueArray[i2].getUnderlyingValue();
                TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
                if (sequenceType.matches(sequenceArray[i2], typeHierarchy)) continue;
                RoleDiagnostic roleDiagnostic = new RoleDiagnostic(0, qName.getStructuredQName().getDisplayName(), i2);
                sequenceArray[i2] = typeHierarchy.applyFunctionConversionRules(sequenceArray[i2], sequenceType, roleDiagnostic, ExplicitLocation.UNKNOWN_LOCATION);
            }
            Sequence<?> sequence = userFunction.call(sequenceArray, this.d);
            return XdmValue.wrap(sequence);
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public DynamicQueryContext getUnderlyingQueryContext() {
        return this.c;
    }
}

