/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XdmArray
extends XdmFunctionItem {
    public XdmArray() {
        this.setValue(SimpleArrayItem.EMPTY_ARRAY);
    }

    public XdmArray(ArrayItem arrayItem) {
        this.setValue(arrayItem);
    }

    public XdmArray(XdmValue[] xdmValueArray) {
        ArrayList arrayList = new ArrayList();
        for (XdmValue xdmValue : xdmValueArray) {
            arrayList.add(xdmValue.getUnderlyingValue());
        }
        this.setValue(new SimpleArrayItem(arrayList));
    }

    public XdmArray(Iterable<? extends XdmValue> object) {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            XdmValue xdmValue = (XdmValue)object.next();
            arrayList.add(xdmValue.getUnderlyingValue());
        }
        this.setValue(new SimpleArrayItem(arrayList));
    }

    public int arrayLength() {
        return this.getUnderlyingValue().arrayLength();
    }

    public XdmValue get(int n2) {
        try {
            GroundedValue<?> groundedValue = this.getUnderlyingValue().get(n2);
            return XdmValue.wrap(groundedValue);
        }
        catch (XPathException xPathException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public XdmArray put(int n2, XdmValue iterable) {
        try {
            iterable = iterable.getUnderlyingValue();
            return (XdmArray)XdmValue.wrap(this.getUnderlyingValue().put(n2, (GroundedValue<?>)iterable));
        }
        catch (XPathException xPathException) {
            throw new IndexOutOfBoundsException();
        }
    }

    public XdmArray addMember(XdmValue iterable) {
        try {
            iterable = iterable.getUnderlyingValue();
            iterable = ArrayFunctionSet.ArrayAppend.append(this.getUnderlyingValue(), iterable);
            return (XdmArray)XdmValue.wrap(iterable);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public XdmArray concat(XdmArray iterable) {
        iterable = iterable.getUnderlyingValue();
        iterable = this.getUnderlyingValue().concat((ArrayItem)iterable);
        return (XdmArray)XdmValue.wrap(iterable);
    }

    public List<XdmValue> asList() {
        Iterator<GroundedValue<?>> iterator = this.getUnderlyingValue().members().iterator();
        ArrayList<XdmValue> arrayList = new ArrayList<XdmValue>(this.getUnderlyingValue().getLength());
        while (iterator.hasNext()) {
            arrayList.add(XdmValue.wrap((Sequence)iterator.next()));
        }
        return arrayList;
    }

    @Override
    public ArrayItem getUnderlyingValue() {
        return (ArrayItem)super.getUnderlyingValue();
    }

    public static XdmArray makeArray(Object[] objectArray) {
        ArrayList<XdmValue> arrayList = new ArrayList<XdmValue>(objectArray.length);
        for (Object object : objectArray) {
            arrayList.add(XdmValue.makeValue(object));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }

    public static XdmArray makeArray(boolean[] blArray) {
        ArrayList<XdmAtomicValue> arrayList = new ArrayList<XdmAtomicValue>(blArray.length);
        for (boolean bl2 : blArray) {
            arrayList.add(new XdmAtomicValue(bl2));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }

    public static XdmArray makeArray(long[] lArray) {
        ArrayList<XdmAtomicValue> arrayList = new ArrayList<XdmAtomicValue>(lArray.length);
        for (long l2 : lArray) {
            arrayList.add(new XdmAtomicValue(l2));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }

    public static XdmArray makeArray(int[] nArray) {
        ArrayList<XdmAtomicValue> arrayList = new ArrayList<XdmAtomicValue>(nArray.length);
        for (int n2 : nArray) {
            arrayList.add(new XdmAtomicValue(n2));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }

    public static XdmArray makeArray(short[] sArray) {
        ArrayList<XdmAtomicValue> arrayList = new ArrayList<XdmAtomicValue>(sArray.length);
        for (short s2 : sArray) {
            arrayList.add(new XdmAtomicValue(s2));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }

    public static XdmArray makeArray(byte[] byArray) {
        ArrayList<XdmAtomicValue> arrayList = new ArrayList<XdmAtomicValue>(byArray.length);
        for (byte by : byArray) {
            arrayList.add(new XdmAtomicValue(by));
        }
        return new XdmArray((Iterable<? extends XdmValue>)arrayList);
    }
}

