/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringToDouble11;
import net.sf.saxon.value.StringValue;

public class XdmAtomicValue
extends XdmItem {
    private XdmAtomicValue() {
    }

    protected XdmAtomicValue(AtomicValue atomicValue, boolean bl2) {
        this.setValue(atomicValue);
    }

    public XdmAtomicValue(boolean bl2) {
        this(BooleanValue.get(bl2), true);
    }

    public XdmAtomicValue(long l2) {
        this(Int64Value.makeDerived(l2, BuiltInAtomicType.LONG), true);
    }

    public XdmAtomicValue(int n2) {
        this(Int64Value.makeDerived(n2, BuiltInAtomicType.INT), true);
    }

    public XdmAtomicValue(short s2) {
        this(Int64Value.makeDerived(s2, BuiltInAtomicType.SHORT), true);
    }

    public XdmAtomicValue(byte by) {
        this(Int64Value.makeDerived(by, BuiltInAtomicType.BYTE), true);
    }

    public XdmAtomicValue(BigDecimal bigDecimal) {
        this(new BigDecimalValue(bigDecimal), true);
    }

    public XdmAtomicValue(double d2) {
        this(new DoubleValue(d2), true);
    }

    public XdmAtomicValue(float f2) {
        this(new FloatValue(f2), true);
    }

    public XdmAtomicValue(String string) {
        this(new StringValue(string), true);
    }

    public XdmAtomicValue(URI uRI) {
        this(new AnyURIValue(uRI.toString()), true);
    }

    public XdmAtomicValue(QName qName) {
        this(new QNameValue(qName.getStructuredQName(), BuiltInAtomicType.QNAME), true);
    }

    public XdmAtomicValue(String string, ItemType object) {
        net.sf.saxon.type.ItemType itemType = ((ItemType)object).getUnderlyingItemType();
        if (!itemType.isPlainType()) {
            throw new SaxonApiException("Requested type is not atomic");
        }
        if (((AtomicType)itemType).isAbstract()) {
            throw new SaxonApiException("Requested type is an abstract type");
        }
        if (((AtomicType)itemType).isNamespaceSensitive()) {
            throw new SaxonApiException("Requested type is namespace-sensitive");
        }
        try {
            object = ((AtomicType)itemType).getStringConverter(((ItemType)object).getConversionRules());
            this.setValue(((StringConverter)object).convertString(string).asAtomic());
            return;
        }
        catch (ValidationException validationException) {
            throw new SaxonApiException(validationException);
        }
    }

    public static XdmAtomicValue makeAtomicValue(Object object) {
        if (object instanceof AtomicValue) {
            return new XdmAtomicValue((AtomicValue)object, true);
        }
        if (object instanceof Boolean) {
            return new XdmAtomicValue((Boolean)object);
        }
        if (object instanceof Integer) {
            return new XdmAtomicValue((Integer)object);
        }
        if (object instanceof Long) {
            return new XdmAtomicValue((Long)object);
        }
        if (object instanceof Short) {
            return new XdmAtomicValue((Short)object);
        }
        if (object instanceof Character) {
            return new XdmAtomicValue(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return new XdmAtomicValue((Byte)object);
        }
        if (object instanceof String) {
            return new XdmAtomicValue((String)object);
        }
        if (object instanceof Double) {
            return new XdmAtomicValue((Double)object);
        }
        if (object instanceof Float) {
            return new XdmAtomicValue(((Float)object).floatValue());
        }
        if (object instanceof BigDecimal) {
            return new XdmAtomicValue((BigDecimal)object);
        }
        if (object instanceof BigInteger) {
            return new XdmAtomicValue(IntegerValue.makeIntegerValue((BigInteger)object), true);
        }
        if (object instanceof URI) {
            return new XdmAtomicValue((URI)object);
        }
        if (object instanceof QName) {
            return new XdmAtomicValue((QName)object);
        }
        if (object instanceof XdmAtomicValue) {
            return (XdmAtomicValue)object;
        }
        throw new IllegalArgumentException(object.toString());
    }

    @Override
    public AtomicValue getUnderlyingValue() {
        return (AtomicValue)super.getUnderlyingValue();
    }

    @Override
    public String toString() {
        return this.getStringValue();
    }

    public QName getPrimitiveTypeName() {
        Object object = this.getUnderlyingValue();
        object = ((AtomicValue)object).getPrimitiveType();
        return new QName(((BuiltInAtomicType)object).getStructuredQName());
    }

    public QName getTypeName() {
        Object object = this.getUnderlyingValue();
        object = ((AtomicValue)object).getItemType();
        return new QName(object.getStructuredQName());
    }

    public Object getValue() {
        AtomicValue atomicValue = this.getUnderlyingValue();
        if (atomicValue instanceof StringValue) {
            return atomicValue.getStringValue();
        }
        if (atomicValue instanceof IntegerValue) {
            return ((IntegerValue)atomicValue).asBigInteger();
        }
        if (atomicValue instanceof DoubleValue) {
            return ((NumericValue)((DoubleValue)atomicValue)).getDoubleValue();
        }
        if (atomicValue instanceof FloatValue) {
            return Float.valueOf(((NumericValue)((FloatValue)atomicValue)).getFloatValue());
        }
        if (atomicValue instanceof BooleanValue) {
            return ((BooleanValue)atomicValue).getBooleanValue();
        }
        if (atomicValue instanceof BigDecimalValue) {
            return ((NumericValue)((BigDecimalValue)atomicValue)).getDecimalValue();
        }
        if (atomicValue instanceof QNameValue) {
            atomicValue = (QNameValue)atomicValue;
            return new QName(((QualifiedNameValue)atomicValue).getPrefix(), ((QualifiedNameValue)atomicValue).getNamespaceURI(), ((QualifiedNameValue)atomicValue).getLocalName());
        }
        return atomicValue.getStringValue();
    }

    public boolean getBooleanValue() {
        Object object = this.getUnderlyingValue();
        if (object instanceof BooleanValue) {
            return ((BooleanValue)object).getBooleanValue();
        }
        if (object instanceof NumericValue) {
            return !((AtomicValue)object).isNaN() && ((NumericValue)object).signum() != 0;
        }
        if (object instanceof StringValue) {
            return "1".equals(object = ((AtomicValue)object).getStringValue().trim()) || "true".equals(object);
        }
        throw new SaxonApiException("Cannot cast item to a boolean");
    }

    public long getLongValue() {
        AtomicValue atomicValue = this.getUnderlyingValue();
        if (atomicValue instanceof BooleanValue) {
            if (((BooleanValue)atomicValue).getBooleanValue()) {
                return 0L;
            }
            return 1L;
        }
        if (atomicValue instanceof NumericValue) {
            try {
                return ((NumericValue)atomicValue).longValue();
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException("Cannot cast item to an integer");
            }
        }
        if (atomicValue instanceof StringValue) {
            StringToDouble stringToDouble = StringToDouble.getInstance();
            return (long)stringToDouble.stringToNumber(atomicValue.getStringValueCS());
        }
        throw new SaxonApiException("Cannot cast item to an integer");
    }

    public double getDoubleValue() {
        AtomicValue atomicValue = this.getUnderlyingValue();
        if (atomicValue instanceof BooleanValue) {
            if (((BooleanValue)atomicValue).getBooleanValue()) {
                return 0.0;
            }
            return 1.0;
        }
        if (atomicValue instanceof NumericValue) {
            return ((NumericValue)atomicValue).getDoubleValue();
        }
        if (atomicValue instanceof StringValue) {
            try {
                StringToDouble11 stringToDouble11 = StringToDouble11.getInstance();
                return stringToDouble11.stringToNumber(atomicValue.getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                throw new SaxonApiException(numberFormatException.getMessage());
            }
        }
        throw new SaxonApiException("Cannot cast item to a double");
    }

    public BigDecimal getDecimalValue() {
        AtomicValue atomicValue = this.getUnderlyingValue();
        if (atomicValue instanceof BooleanValue) {
            if (((BooleanValue)atomicValue).getBooleanValue()) {
                return BigDecimal.ZERO;
            }
            return BigDecimal.ONE;
        }
        if (atomicValue instanceof NumericValue) {
            try {
                return ((NumericValue)atomicValue).getDecimalValue();
            }
            catch (XPathException xPathException) {
                throw new SaxonApiException("Cannot cast item to a decimal");
            }
        }
        if (atomicValue instanceof StringValue) {
            return new BigDecimal(atomicValue.getStringValueCS().toString());
        }
        throw new SaxonApiException("Cannot cast item to a decimal");
    }

    public QName getQNameValue() {
        AtomicValue atomicValue = this.getUnderlyingValue();
        if (atomicValue instanceof QualifiedNameValue) {
            return new QName(((QualifiedNameValue)atomicValue).getStructuredQName());
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof XdmAtomicValue) {
            AtomicMatchKey atomicMatchKey = this.getUnderlyingValue().asMapKey();
            object = ((XdmAtomicValue)object).getUnderlyingValue().asMapKey();
            return atomicMatchKey.equals(object);
        }
        return false;
    }

    public int hashCode() {
        return this.getUnderlyingValue().asMapKey().hashCode();
    }
}

