/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceNormalizer;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.s9api.AbstractDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.serialize.SerializationProperties;

public class XdmDestination
extends AbstractDestination {
    private TreeModel a = TreeModel.TINY_TREE;
    private Builder b;

    public void setBaseURI(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI must be absolute");
        }
        this.setDestinationBaseURI(uRI);
    }

    public URI getBaseURI() {
        return this.getDestinationBaseURI();
    }

    public void setTreeModel(TreeModel treeModel) {
        this.a = treeModel;
    }

    public TreeModel getTreeModel() {
        return this.a;
    }

    @Override
    public Receiver getReceiver(PipelineConfiguration object, SerializationProperties serializationProperties) {
        TreeModel treeModel = this.a;
        if (treeModel == null) {
            int n2 = ((PipelineConfiguration)object).getParseOptions().getTreeModel();
            if (n2 != -1) {
                treeModel = TreeModel.getTreeModel(n2);
            }
            if (treeModel == null) {
                treeModel = TreeModel.TINY_TREE;
            }
        }
        this.b = treeModel.makeBuilder((PipelineConfiguration)object);
        String string = this.getBaseURI() == null ? null : this.getBaseURI().toASCIIString();
        if (string != null) {
            this.b.setUseEventLocation(false);
            this.b.setBaseURI(string);
        }
        object = serializationProperties.makeSequenceNormalizer(this.b);
        ((SequenceReceiver)object).setSystemId(string);
        ((SequenceNormalizer)object).onClose(this.helper.getListeners());
        return object;
    }

    @Override
    public void close() {
    }

    public XdmNode getXdmNode() {
        if (this.b == null) {
            throw new IllegalStateException("The document has not yet been built");
        }
        NodeInfo nodeInfo = this.b.getCurrentRoot();
        if (nodeInfo == null) {
            return null;
        }
        return (XdmNode)XdmValue.wrap(nodeInfo);
    }

    public void reset() {
        this.b = null;
    }
}

