/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.stream.Stream;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class XdmFunctionItem
extends XdmItem {
    protected XdmFunctionItem() {
    }

    public XdmFunctionItem(Function function) {
        this.setValue(function);
    }

    public QName getName() {
        Object object = (Function)this.getUnderlyingValue();
        if ((object = object.getFunctionName()) == null) {
            return null;
        }
        return new QName((StructuredQName)object);
    }

    public int getArity() {
        Function function = (Function)this.getUnderlyingValue();
        return function.getArity();
    }

    @Override
    public boolean isAtomicValue() {
        return false;
    }

    public static XdmFunctionItem getSystemFunction(Processor object, QName qName, int n2) {
        try {
            object = ((Processor)object).getUnderlyingConfiguration();
            object = ((Configuration)object).getSystemFunction(qName.getStructuredQName(), n2);
            if (object == null) {
                return null;
            }
            return new XdmFunctionItem((Function)object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public java.util.function.Function<? super XdmValue, ? extends XdmValue> asFunction(Processor processor) {
        if (this.getArity() == 1) {
            return xdmValue -> {
                try {
                    return this.call(processor, (XdmValue)xdmValue);
                }
                catch (SaxonApiException saxonApiException) {
                    throw new SaxonApiUncheckedException(saxonApiException);
                }
            };
        }
        throw new IllegalStateException("Function arity must be one");
    }

    public Step<XdmItem> asStep(Processor processor) {
        if (this.getArity() == 1) {
            return new Step<XdmItem>(this, processor){
                private /* synthetic */ Processor a;
                private /* synthetic */ XdmFunctionItem b;
                {
                    this.b = xdmFunctionItem;
                    this.a = processor;
                }

                private Stream<? extends XdmItem> a(XdmItem xdmItem) {
                    try {
                        return this.b.call(this.a, xdmItem).stream();
                    }
                    catch (SaxonApiException saxonApiException) {
                        throw new SaxonApiUncheckedException(saxonApiException);
                    }
                }

                @Override
                public final /* synthetic */ Object apply(Object object) {
                    return this.a((XdmItem)object);
                }
            };
        }
        throw new IllegalStateException("Function arity must be one");
    }

    public XdmValue call(Processor object, XdmValue ... object2) {
        if (((XdmValue[])object2).length != this.getArity()) {
            throw new SaxonApiException("Supplied " + ((XdmValue[])object2).length + " arguments, required " + this.getArity());
        }
        try {
            Sequence<Object> sequence;
            Sequence<?> sequence2;
            Object object3;
            Function function = (Function)this.getUnderlyingValue();
            FunctionItemType functionItemType = function.getFunctionItemType();
            Sequence[] sequenceArray = new Sequence[((XdmValue[])object2).length];
            TypeHierarchy typeHierarchy = ((Processor)object).getUnderlyingConfiguration().getTypeHierarchy();
            for (int i2 = 0; i2 < ((XdmValue[])object2).length; ++i2) {
                object3 = functionItemType.getArgumentTypes()[i2];
                if (!((SequenceType)object3).matches(sequence2 = object2[i2].getUnderlyingValue(), typeHierarchy)) {
                    sequence = new RoleDiagnostic(0, "", i2);
                    sequence2 = typeHierarchy.applyFunctionConversionRules(sequence2, (SequenceType)object3, (RoleDiagnostic)((Object)sequence), ExplicitLocation.UNKNOWN_LOCATION);
                }
                sequenceArray[i2] = sequence2;
            }
            Configuration configuration = ((Processor)object).getUnderlyingConfiguration();
            object3 = new Controller(configuration);
            sequence2 = ((Controller)object3).newXPathContext();
            sequence2 = function.makeNewContext((XPathContext)((Object)sequence2), (ContextOriginator)object3);
            sequence = function.call((XPathContext)((Object)sequence2), sequenceArray);
            if (!function.isTrustedResultType()) {
                sequence = sequence.materialize();
                object = functionItemType.getResultType();
                if (!((SequenceType)object).matches(sequence, typeHierarchy)) {
                    object2 = new RoleDiagnostic(5, "", 0);
                    sequence = typeHierarchy.applyFunctionConversionRules(sequence.materialize(), (SequenceType)object, (RoleDiagnostic)object2, ExplicitLocation.UNKNOWN_LOCATION);
                }
            }
            object = sequence.iterate().materialize();
            return XdmValue.wrap(object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }
}

