/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.tree.jiter.MappingJavaIterator;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.StringValue;

public class XdmMap
extends XdmFunctionItem {
    public XdmMap() {
        this.setValue(new HashTrieMap());
    }

    public XdmMap(MapItem mapItem) {
        this.setValue(mapItem);
    }

    public XdmMap(Map<? extends XdmAtomicValue, ? extends XdmValue> object) {
        HashTrieMap hashTrieMap = new HashTrieMap();
        for (Map.Entry entry : object.entrySet()) {
            hashTrieMap.initialPut(((XdmAtomicValue)entry.getKey()).getUnderlyingValue(), ((XdmValue)entry.getValue()).getUnderlyingValue());
        }
        this.setValue(hashTrieMap);
    }

    @Override
    public MapItem getUnderlyingValue() {
        return (MapItem)super.getUnderlyingValue();
    }

    public int mapSize() {
        return this.getUnderlyingValue().size();
    }

    public XdmMap put(XdmAtomicValue xdmAtomicValue, XdmValue xdmValue) {
        XdmMap xdmMap = new XdmMap();
        xdmMap.setValue(this.getUnderlyingValue().addEntry(xdmAtomicValue.getUnderlyingValue(), xdmValue.getUnderlyingValue()));
        return xdmMap;
    }

    public XdmMap remove(XdmAtomicValue xdmAtomicValue) {
        XdmMap xdmMap = new XdmMap();
        xdmMap.setValue(this.getUnderlyingValue().remove(xdmAtomicValue.getUnderlyingValue()));
        return xdmMap;
    }

    public Set<XdmAtomicValue> keySet() {
        return new AbstractSet<XdmAtomicValue>(this){
            private /* synthetic */ XdmMap a;
            {
                this.a = xdmMap;
            }

            @Override
            public final Iterator<XdmAtomicValue> iterator() {
                return new MappingJavaIterator<KeyValuePair, XdmAtomicValue>(this.a.getUnderlyingValue().keyValuePairs().iterator(), keyValuePair -> (XdmAtomicValue)XdmValue.wrap(keyValuePair.key));
            }

            @Override
            public final int size() {
                return this.a.getUnderlyingValue().size();
            }

            @Override
            public final boolean contains(Object object) {
                return this.a.getUnderlyingValue().get(((XdmAtomicValue)object).getUnderlyingValue()) != null;
            }
        };
    }

    public Map<XdmAtomicValue, XdmValue> asImmutableMap() {
        XdmMap xdmMap = this;
        return new AbstractMap<XdmAtomicValue, XdmValue>(this, xdmMap){
            private /* synthetic */ XdmMap a;
            private /* synthetic */ XdmMap b;
            {
                this.b = xdmMap;
                this.a = xdmMap2;
            }

            @Override
            public final Set<Map.Entry<XdmAtomicValue, XdmValue>> entrySet() {
                return this.a.entrySet();
            }

            @Override
            public final int size() {
                return this.a.mapSize();
            }

            @Override
            public final boolean isEmpty() {
                return this.a.isEmpty();
            }

            @Override
            public final boolean containsKey(Object object) {
                return object instanceof XdmAtomicValue && this.a.containsKey((XdmAtomicValue)object);
            }

            @Override
            public final void putAll(Map<? extends XdmAtomicValue, ? extends XdmValue> map) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public final Set<XdmAtomicValue> keySet() {
                return this.a.keySet();
            }

            @Override
            public final Collection<XdmValue> values() {
                return this.a.values();
            }

            @Override
            public final /* synthetic */ Object remove(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public final /* synthetic */ Object put(Object object, Object object2) {
                XdmAtomicValue cfr_ignored_0 = (XdmAtomicValue)object;
                XdmValue cfr_ignored_1 = (XdmValue)object2;
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Map<XdmAtomicValue, XdmValue> asMap() {
        return new HashMap<XdmAtomicValue, XdmValue>(this.asImmutableMap());
    }

    public void clear() {
        throw new UnsupportedOperationException("XdmMap is immutable");
    }

    public boolean isEmpty() {
        return this.getUnderlyingValue().isEmpty();
    }

    public boolean containsKey(XdmAtomicValue xdmAtomicValue) {
        return this.getUnderlyingValue().get(xdmAtomicValue.getUnderlyingValue()) != null;
    }

    public XdmValue get(XdmAtomicValue iterable) {
        if (iterable == null) {
            throw new NullPointerException();
        }
        iterable = this.getUnderlyingValue().get(iterable.getUnderlyingValue());
        if (iterable == null) {
            return null;
        }
        return XdmValue.wrap(iterable);
    }

    public XdmValue get(String groundedValue) {
        if (groundedValue == null) {
            throw new NullPointerException();
        }
        groundedValue = this.getUnderlyingValue().get(new StringValue((CharSequence)((Object)groundedValue)));
        if (groundedValue == null) {
            return null;
        }
        return XdmValue.wrap(groundedValue);
    }

    public XdmValue get(long l2) {
        GroundedValue<?> groundedValue = this.getUnderlyingValue().get(new Int64Value(l2));
        if (groundedValue == null) {
            return null;
        }
        return XdmValue.wrap(groundedValue);
    }

    public XdmValue get(double d2) {
        GroundedValue<?> groundedValue = this.getUnderlyingValue().get(new DoubleValue(d2));
        if (groundedValue == null) {
            return null;
        }
        return XdmValue.wrap(groundedValue);
    }

    public Collection<XdmValue> values() {
        ArrayList<XdmValue> arrayList = new ArrayList<XdmValue>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue().keyValuePairs()) {
            arrayList.add(XdmValue.wrap(keyValuePair.value));
        }
        return arrayList;
    }

    public Set<Map.Entry<XdmAtomicValue, XdmValue>> entrySet() {
        HashSet<Map.Entry<XdmAtomicValue, XdmValue>> hashSet = new HashSet<Map.Entry<XdmAtomicValue, XdmValue>>();
        for (KeyValuePair keyValuePair : this.getUnderlyingValue().keyValuePairs()) {
            hashSet.add(new a(keyValuePair));
        }
        return hashSet;
    }

    public static XdmMap makeMap(Map object) {
        HashTrieMap hashTrieMap = new HashTrieMap();
        for (Map.Entry entry : object.entrySet()) {
            Object object2 = entry.getKey();
            Object v2 = entry.getValue();
            object2 = XdmAtomicValue.makeAtomicValue(object2);
            XdmValue object22 = XdmValue.makeValue(v2);
            hashTrieMap.initialPut(((XdmAtomicValue)object2).getUnderlyingValue(), object22.getUnderlyingValue());
        }
        return new XdmMap(hashTrieMap);
    }

    private static final class a
    implements Map.Entry<XdmAtomicValue, XdmValue> {
        private KeyValuePair a;

        public a(KeyValuePair keyValuePair) {
            this.a = keyValuePair;
        }

        @Override
        public final /* synthetic */ Object setValue(Object object) {
            XdmValue cfr_ignored_0 = (XdmValue)object;
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object getValue() {
            a a2 = this;
            return XdmValue.wrap(a2.a.value);
        }

        @Override
        public final /* synthetic */ Object getKey() {
            a a2 = this;
            return (XdmAtomicValue)XdmValue.wrap(a2.a.key);
        }
    }
}

