/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Steps;
import net.sf.saxon.s9api.streams.XdmStream;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.VirtualNode;

public class XdmNode
extends XdmItem {
    private XdmNode() {
    }

    public XdmNode(NodeInfo nodeInfo) {
        this.setValue(nodeInfo);
    }

    public XdmNodeKind getNodeKind() {
        switch (this.getUnderlyingNode().getNodeKind()) {
            case 9: {
                return XdmNodeKind.DOCUMENT;
            }
            case 1: {
                return XdmNodeKind.ELEMENT;
            }
            case 2: {
                return XdmNodeKind.ATTRIBUTE;
            }
            case 3: {
                return XdmNodeKind.TEXT;
            }
            case 8: {
                return XdmNodeKind.COMMENT;
            }
            case 7: {
                return XdmNodeKind.PROCESSING_INSTRUCTION;
            }
            case 13: {
                return XdmNodeKind.NAMESPACE;
            }
        }
        throw new IllegalStateException("nodeKind");
    }

    public Processor getProcessor() {
        Configuration configuration = this.getUnderlyingNode().getConfiguration();
        Configuration.ApiProvider apiProvider = configuration.getProcessor();
        if (apiProvider instanceof Processor) {
            return (Processor)apiProvider;
        }
        return new Processor(configuration);
    }

    @Override
    public NodeInfo getUnderlyingValue() {
        return (NodeInfo)super.getUnderlyingValue();
    }

    public QName getNodeName() {
        NodeInfo nodeInfo = this.getUnderlyingNode();
        switch (nodeInfo.getNodeKind()) {
            case 3: 
            case 8: 
            case 9: {
                return null;
            }
            case 7: 
            case 13: {
                if (nodeInfo.getLocalPart().isEmpty()) {
                    return null;
                }
                return new QName(new StructuredQName("", "", nodeInfo.getLocalPart()));
            }
            case 1: 
            case 2: {
                return new QName(nodeInfo.getPrefix(), nodeInfo.getURI(), nodeInfo.getLocalPart());
            }
        }
        return null;
    }

    public XdmValue getTypedValue() {
        try {
            AtomicSequence atomicSequence = this.getUnderlyingNode().atomize();
            return XdmValue.wrap(atomicSequence);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public int getLineNumber() {
        return this.getUnderlyingNode().getLineNumber();
    }

    public int getColumnNumber() {
        return this.getUnderlyingNode().getColumnNumber();
    }

    public Source asSource() {
        return this.getUnderlyingNode();
    }

    public Iterable<XdmNode> children() {
        return this.select(Steps.child()).asListOfNodes();
    }

    public Iterable<XdmNode> children(String string) {
        return this.select(Steps.child(string)).asListOfNodes();
    }

    public Iterable<XdmNode> children(String string, String string2) {
        return this.select(Steps.child(string, string2)).asListOfNodes();
    }

    public Iterable<XdmNode> children(Predicate<? super XdmNode> predicate) {
        return this.select(Steps.child(predicate)).asListOfNodes();
    }

    public XdmSequenceIterator<XdmNode> axisIterator(Axis object) {
        object = this.getUnderlyingNode().iterateAxis(object.getAxisNumber());
        return XdmSequenceIterator.ofNodes((AxisIterator)object);
    }

    public XdmSequenceIterator<XdmNode> axisIterator(Axis object, QName object2) {
        int n2;
        switch (object) {
            case ATTRIBUTE: {
                n2 = 2;
                break;
            }
            case NAMESPACE: {
                n2 = 13;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        NodeInfo nodeInfo = this.getUnderlyingNode();
        object2 = new NameTest(n2, ((QName)object2).getNamespaceURI(), ((QName)object2).getLocalName(), nodeInfo.getConfiguration().getNamePool());
        object = nodeInfo.iterateAxis(object.getAxisNumber(), (NodeTest)object2);
        return XdmSequenceIterator.ofNodes((AxisIterator)object);
    }

    public XdmNode getParent() {
        NodeInfo nodeInfo = this.getUnderlyingNode().getParent();
        if (nodeInfo == null) {
            return null;
        }
        return (XdmNode)XdmValue.wrap(nodeInfo);
    }

    public XdmNode getRoot() {
        NodeInfo nodeInfo = this.getUnderlyingNode().getRoot();
        if (nodeInfo == null) {
            return null;
        }
        return (XdmNode)XdmValue.wrap(nodeInfo);
    }

    public String getAttributeValue(QName qName) {
        NodeInfo nodeInfo = this.getUnderlyingNode();
        return nodeInfo.getAttributeValue(qName.getNamespaceURI(), qName.getLocalName());
    }

    public String attribute(String string) {
        return this.getUnderlyingNode().getAttributeValue("", string);
    }

    public URI getBaseURI() {
        try {
            String string = this.getUnderlyingNode().getBaseURI();
            if (string == null) {
                return null;
            }
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("baseURI", uRISyntaxException);
        }
    }

    public URI getDocumentURI() {
        try {
            String string = this.getUnderlyingNode().getSystemId();
            if (string == null || string.isEmpty()) {
                return null;
            }
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException("documentURI", uRISyntaxException);
        }
    }

    public int hashCode() {
        return this.getUnderlyingNode().hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof XdmNode && this.getUnderlyingNode().equals(((XdmNode)object).getUnderlyingNode());
    }

    @Override
    public String toString() {
        Object object = this.getUnderlyingNode();
        if (object.getNodeKind() == 2) {
            String string = object.getStringValue().replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;");
            return object.getDisplayName() + "=\"" + string + '\"';
        }
        if (object.getNodeKind() == 13) {
            String string = object.getStringValue().replace("&", "&amp;").replace("\"", "&quot;").replace("<", "&lt;");
            object = ((String)(object = object.getDisplayName())).equals("") ? "xmlns" : "xmlns:" + (String)object;
            return (String)object + "=\"" + string + '\"';
        }
        if (object.getNodeKind() == 3) {
            return object.getStringValue().replace("&", "&amp;").replace("<", "&lt;").replace("]]>", "]]&gt;");
        }
        try {
            return QueryResult.serialize((NodeInfo)object).trim();
        }
        catch (XPathException xPathException) {
            throw new IllegalStateException(xPathException);
        }
    }

    public NodeInfo getUnderlyingNode() {
        return this.getUnderlyingValue();
    }

    public Object getExternalNode() {
        Object object = this.getUnderlyingNode();
        if (object instanceof VirtualNode) {
            if ((object = ((VirtualNode)object).getRealNode()) instanceof NodeInfo) {
                return null;
            }
            return object;
        }
        return null;
    }

    public XdmSequenceIterator<XdmNode> nodeIterator() {
        return XdmSequenceIterator.ofNode(this);
    }

    public XdmStream<XdmNode> stream() {
        return new XdmStream<XdmNode>(Stream.of(this));
    }
}

