/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.Closeable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceCopier;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmEmptySequence;
import net.sf.saxon.s9api.XdmExternalObject;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.XdmStream;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.SequenceExtent;

public class XdmValue
implements Iterable<XdmItem> {
    private GroundedValue<?> a;

    protected XdmValue() {
    }

    public XdmValue(Iterable<? extends XdmItem> object) {
        ArrayList<GroundedValue> arrayList = new ArrayList<GroundedValue>();
        object = object.iterator();
        while (object.hasNext()) {
            XdmItem xdmItem = (XdmItem)object.next();
            arrayList.add(xdmItem.getUnderlyingValue());
        }
        this.a = new SequenceExtent(arrayList);
    }

    public XdmValue(Iterator<? extends XdmItem> iterator) {
        try {
            ArrayList<GroundedValue> arrayList = new ArrayList<GroundedValue>();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().getUnderlyingValue());
            }
            this.a = new SequenceExtent(arrayList);
            return;
        }
        catch (SaxonApiUncheckedException saxonApiUncheckedException) {
            throw new SaxonApiException(saxonApiUncheckedException.getCause());
        }
    }

    public XdmValue(Stream<? extends XdmItem> stream) {
        this(stream.iterator());
    }

    protected static XdmValue fromGroundedValue(GroundedValue<?> groundedValue) {
        XdmValue xdmValue = new XdmValue();
        xdmValue.setValue(groundedValue);
        return xdmValue;
    }

    protected void setValue(GroundedValue<?> groundedValue) {
        this.a = groundedValue;
    }

    public static XdmValue wrap(Sequence<?> sequence) {
        if (sequence == null) {
            return XdmEmptySequence.getInstance();
        }
        try {
            sequence = sequence.materialize();
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
        if (sequence.getLength() == 0) {
            return XdmEmptySequence.getInstance();
        }
        if (sequence.getLength() == 1) {
            if ((sequence = sequence.head()) instanceof NodeInfo) {
                return new XdmNode((NodeInfo)sequence);
            }
            if (sequence instanceof AtomicValue) {
                return new XdmAtomicValue((AtomicValue)sequence, true);
            }
            if (sequence instanceof MapItem) {
                return new XdmMap((MapItem)sequence);
            }
            if (sequence instanceof ArrayItem) {
                return new XdmArray((ArrayItem)sequence);
            }
            if (sequence instanceof Function) {
                return new XdmFunctionItem((Function)sequence);
            }
            if (sequence instanceof ExternalObject) {
                return new XdmExternalObject(sequence);
            }
            throw new IllegalArgumentException("Unknown item type " + sequence.getClass());
        }
        return XdmValue.fromGroundedValue(sequence);
    }

    public static XdmValue wrap(AtomicSequence atomicSequence) {
        switch (atomicSequence.getLength()) {
            case 0: {
                return XdmEmptySequence.getInstance();
            }
            case 1: {
                return new XdmAtomicValue(atomicSequence.head(), true);
            }
        }
        return XdmValue.fromGroundedValue(atomicSequence);
    }

    public XdmValue append(XdmValue xdmValue) {
        ArrayList<GroundedValue> arrayList = new ArrayList<GroundedValue>();
        for (XdmItem xdmItem : this) {
            arrayList.add(xdmItem.getUnderlyingValue());
        }
        for (XdmItem xdmItem : xdmValue) {
            arrayList.add(xdmItem.getUnderlyingValue());
        }
        GroundedValue groundedValue = SequenceExtent.makeSequenceExtent(arrayList);
        return XdmValue.fromGroundedValue(groundedValue);
    }

    public int size() {
        try {
            return SequenceTool.getLength(this.a);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public XdmItem itemAt(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException("" + n2);
        }
        try {
            Object obj = SequenceTool.itemAt(this.a, n2);
            return (XdmItem)XdmItem.wrap(obj);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    @Override
    public Iterator<XdmItem> iterator() {
        try {
            GroundedValue<?> groundedValue = this.getUnderlyingValue();
            return new XdmSequenceIterator<XdmItem>(groundedValue.iterate());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public GroundedValue<?> getUnderlyingValue() {
        return this.a;
    }

    public String toString() {
        try {
            Object object;
            Object object2 = null;
            Closeable closeable = this.a.iterate();
            while ((object = closeable.next()) != null) {
                if (!(object instanceof NodeInfo)) continue;
                object2 = ((NodeInfo)object).getConfiguration();
                break;
            }
            if (object2 == null) {
                object2 = Configuration.newConfiguration();
            }
            closeable = new StringWriter();
            object = new StreamResult((Writer)closeable);
            SerializationProperties serializationProperties = new SerializationProperties();
            serializationProperties.setProperty("method", "adaptive");
            serializationProperties.setProperty("indent", "true");
            serializationProperties.setProperty("omit-xml-declaration", "true");
            object2 = ((Configuration)object2).getSerializerFactory().getReceiver((Result)object, serializationProperties);
            SequenceCopier.copySequence(this.a.iterate(), (Receiver)object2);
            return ((StringWriter)closeable).toString();
        }
        catch (XPathException xPathException) {
            return super.toString();
        }
    }

    public static XdmValue makeSequence(Iterable<?> object) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            if ((object2 = XdmValue.makeValue(object2)) instanceof XdmItem) {
                arrayList.add((Item)((XdmValue)object2).getUnderlyingValue());
                continue;
            }
            arrayList.add(new XdmArray((Iterable<? extends XdmValue>)object2).getUnderlyingValue());
        }
        return XdmValue.wrap(SequenceExtent.makeSequenceExtent(arrayList));
    }

    public static XdmValue makeValue(Object object) {
        if (object instanceof Sequence) {
            return XdmValue.wrap((Sequence)object);
        }
        if (object instanceof XdmValue) {
            return (XdmValue)object;
        }
        if (object instanceof Map) {
            return XdmMap.makeMap((Map)object);
        }
        if (object instanceof Object[]) {
            return XdmArray.makeArray((Object[])object);
        }
        if (object instanceof Iterable) {
            return XdmValue.makeSequence((Iterable)object);
        }
        return XdmAtomicValue.makeAtomicValue(object);
    }

    public XdmValue documentOrder() {
        try {
            SequenceIterator sequenceIterator = this.a.iterate();
            sequenceIterator = new DocumentOrderIterator(sequenceIterator, GlobalOrderComparer.getInstance());
            return XdmValue.fromGroundedValue(sequenceIterator.materialize());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XdmStream<? extends XdmItem> stream() {
        return new XdmStream(StreamSupport.stream(this.spliterator(), false));
    }

    public <T extends XdmItem> XdmStream<T> select(Step<T> step) {
        return this.stream().flatMapToXdm(step);
    }
}

