/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.lib.ErrorGatherer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.StaticError;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltPackage;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.PackageVersionRanges;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.IPackageLoader;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.VersionedPackageName;
import net.sf.saxon.tree.linked.DocumentImpl;

public class XsltCompiler {
    private Processor a;
    private Configuration b;
    private CompilerInfo c;

    protected XsltCompiler(Processor processor) {
        this.a = processor;
        this.b = processor.getUnderlyingConfiguration();
        this.c = new CompilerInfo(this.b.getDefaultXsltCompilerInfo());
        this.c.setGenerateByteCode(this.b.isGenerateByteCode(50));
        this.c.setTargetEdition(this.b.getEditionCode());
        this.c.setJustInTimeCompilation(this.b.isJITEnabled());
    }

    public Processor getProcessor() {
        return this.a;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.c.setURIResolver(uRIResolver);
    }

    public void setParameter(QName qName, XdmValue xdmValue) {
        try {
            this.c.setParameter(qName.getStructuredQName(), xdmValue.getUnderlyingValue().materialize());
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiUncheckedException(xPathException);
        }
    }

    public void clearParameters() {
        this.c.clearParameters();
    }

    public URIResolver getURIResolver() {
        return this.c.getURIResolver();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.c.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        return this.c.getErrorListener();
    }

    public void setSchemaAware(boolean bl2) {
        this.c.setSchemaAware(bl2);
    }

    public boolean isSchemaAware() {
        return this.c.isSchemaAware();
    }

    public boolean isRelocatable() {
        return this.c.isRelocatable();
    }

    public void setRelocatable(boolean bl2) {
        this.c.setRelocatable(bl2);
    }

    public void setTargetEdition(String string) {
        if (!("EE".equals(string) || "PE".equals(string) || "HE".equals(string) || "JS".equals(string) || "JS2".equals(string))) {
            throw new IllegalArgumentException("Unknown Saxon edition " + string);
        }
        this.c.setTargetEdition(string);
    }

    public String getTargetEdition() {
        return this.c.getTargetEdition();
    }

    public void declareDefaultCollation(String string) {
        StringCollator stringCollator;
        try {
            stringCollator = this.getProcessor().getUnderlyingConfiguration().getCollation(string);
        }
        catch (XPathException xPathException) {
            stringCollator = null;
        }
        if (stringCollator == null) {
            throw new IllegalStateException("Unknown collation " + string);
        }
        this.c.setDefaultCollation(string);
    }

    public String getDefaultCollation() {
        return this.c.getDefaultCollation();
    }

    public void setXsltLanguageVersion(String string) {
    }

    public String getXsltLanguageVersion() {
        return "3.0";
    }

    public boolean isAssertionsEnabled() {
        return this.c.isAssertionsEnabled();
    }

    public void setAssertionsEnabled(boolean bl2) {
        this.c.setAssertionsEnabled(bl2);
    }

    public void setFastCompilation(boolean bl2) {
        if (bl2) {
            this.c.setOptimizerOptions(new OptimizerOptions(1024));
            return;
        }
        this.c.setOptimizerOptions(this.getProcessor().getUnderlyingConfiguration().getOptimizerOptions());
    }

    public boolean isFastCompilation() {
        return this.c.getOptimizerOptions().getOptions() == 1024;
    }

    public void setCompileWithTracing(boolean bl2) {
        if (bl2) {
            this.c.setCodeInjector(new XSLTTraceCodeInjector());
            return;
        }
        this.c.setCodeInjector(null);
    }

    public boolean isCompileWithTracing() {
        return this.c.isCompileWithTracing();
    }

    public void setGenerateByteCode(boolean bl2) {
        this.c.setGenerateByteCode(bl2);
    }

    public boolean isGenerateByteCode() {
        return this.c.isGenerateByteCode();
    }

    public void importXQueryEnvironment(XQueryCompiler xQueryCompiler) {
        this.c.setXQueryLibraries(xQueryCompiler.getUnderlyingStaticContext().getCompiledLibraries());
    }

    public Source getAssociatedStylesheet(Source source, String string, String string2, String string3) {
        try {
            return StylesheetModule.getAssociatedStylesheet(this.b, this.c.getURIResolver(), source, string, string2, string3);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XsltPackage compilePackage(Source object) {
        try {
            Compilation compilation = object instanceof DocumentImpl && ((DocumentImpl)object).getDocumentElement() instanceof StyleElement ? ((StyleElement)((DocumentImpl)object).getDocumentElement()).getCompilation() : new Compilation(this.b, new CompilerInfo(this.c));
            compilation.setLibraryPackage(true);
            object = new XsltPackage(this, compilation.compilePackage((Source)object).getStylesheetPackage());
            int n2 = compilation.getErrorCount();
            if (n2 > 0) {
                object = n2 == 1 ? "one error" : n2 + " errors";
                throw new SaxonApiException("Package compilation failed: " + (String)object + " reported");
            }
            return object;
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public Iterable<XsltPackage> compilePackages(Iterable<Source> iterable) {
        throw new UnsupportedOperationException("XsltCompiler#compilePackages() was dropped in Saxon 9.8");
    }

    public Iterable<XsltPackage> addCompilePackages(Iterable<Source> iterable, boolean bl2) {
        throw new UnsupportedOperationException("XsltCompiler.addCompilePackages is dropped from Saxon 9.8");
    }

    public XsltPackage loadLibraryPackage(URI object) {
        try {
            object = new StreamSource(((URI)object).toString());
            IPackageLoader iPackageLoader = this.a.getUnderlyingConfiguration().makePackageLoader();
            if (iPackageLoader != null) {
                object = iPackageLoader.loadPackage((Source)object);
                return new XsltPackage(this, (StylesheetPackage)object);
            }
            throw new SaxonApiException("Loading library package requires Saxon PE or higher");
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XsltExecutable loadExecutablePackage(URI uRI) {
        return this.loadLibraryPackage(uRI).link();
    }

    public void importPackage(XsltPackage xsltPackage) {
        if (xsltPackage.getProcessor() != this.a) {
            throw new SaxonApiException("The imported package and the XsltCompiler must belong to the same Processor");
        }
        this.c.getPackageLibrary().addPackage(xsltPackage.getUnderlyingPreparedPackage());
    }

    public void importPackage(XsltPackage xsltPackage, String string, String string2) {
        try {
            if (xsltPackage.getProcessor() != this.a) {
                throw new SaxonApiException("The imported package and the XsltCompiler must belong to the same Processor");
            }
            PackageDetails packageDetails = new PackageDetails();
            if (string == null) {
                string = xsltPackage.getName();
            }
            if (string2 == null) {
                string2 = xsltPackage.getVersion();
            }
            packageDetails.nameAndVersion = new VersionedPackageName(string, string2);
            packageDetails.loadedPackage = xsltPackage.getUnderlyingPreparedPackage();
            this.c.getPackageLibrary().addPackage(packageDetails);
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XsltPackage obtainPackage(String object, String object2) {
        try {
            object2 = new PackageVersionRanges((String)object2);
            XsltCompiler xsltCompiler = this;
            object = xsltCompiler.c.getPackageLibrary().findPackage((String)object, (PackageVersionRanges)object2);
            if (object != null) {
                if (((PackageDetails)object).loadedPackage != null) {
                    return new XsltPackage(this, ((PackageDetails)object).loadedPackage);
                }
                if (((PackageDetails)object).sourceLocation != null) {
                    object2 = this.compilePackage(((PackageDetails)object).sourceLocation);
                    ((PackageDetails)object).loadedPackage = ((XsltPackage)object2).getUnderlyingPreparedPackage();
                    return object2;
                }
            }
            return null;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XsltPackage obtainPackageWithAlias(String object) {
        XsltCompiler xsltCompiler = this;
        PackageDetails packageDetails = xsltCompiler.c.getPackageLibrary().findDetailsForAlias((String)object);
        if (packageDetails == null) {
            throw new SaxonApiException("No package with alias " + (String)object + " found in package library");
        }
        try {
            xsltCompiler = this;
            object = xsltCompiler.c.getPackageLibrary().obtainLoadedPackage(packageDetails, new ArrayList<VersionedPackageName>());
            return new XsltPackage(this, (StylesheetPackage)object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public XsltExecutable compile(Source object) {
        Objects.requireNonNull(object);
        try {
            CompilerInfo compilerInfo = new CompilerInfo(this.c);
            object = Compilation.compileSingletonPackage(this.b, compilerInfo, (Source)object);
            return new XsltExecutable(this.a, (PreparedStylesheet)object);
        }
        catch (UncheckedXPathException uncheckedXPathException) {
            throw new SaxonApiException(uncheckedXPathException.getXPathException());
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public CompilerInfo getUnderlyingCompilerInfo() {
        return this.c;
    }

    public void setErrorList(List<StaticError> list) {
        this.c.setErrorListener(new ErrorGatherer(list));
    }

    public void setJustInTimeCompilation(boolean bl2) {
        if (bl2 && !this.b.isLicensedFeature(2)) {
            throw new UnsupportedOperationException("XSLT just-in-time compilation requires a Saxon-EE license");
        }
        this.c.setJustInTimeCompilation(bl2);
    }

    public boolean isJustInTimeCompilation() {
        return this.c.isJustInTimeCompilation();
    }
}

