/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.Xslt30Transformer;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.s9api.b;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XsltExecutable {
    Processor a;
    private PreparedStylesheet b;

    protected XsltExecutable(Processor processor, PreparedStylesheet preparedStylesheet) {
        this.a = processor;
        this.b = preparedStylesheet;
    }

    public Processor getProcessor() {
        return this.a;
    }

    public XsltTransformer load() {
        XsltTransformer xsltTransformer = new XsltTransformer(this.a, this.b.newController(), this.b.getCompileTimeParams());
        StructuredQName structuredQName = this.b.getDefaultInitialTemplateName();
        if (structuredQName != null) {
            xsltTransformer.setInitialTemplate(new QName(structuredQName));
        }
        return xsltTransformer;
    }

    public Xslt30Transformer load30() {
        return new Xslt30Transformer(this.a, this.b.newController(), this.b.getCompileTimeParams());
    }

    public void explain(Destination object) {
        Configuration configuration = this.a.getUnderlyingConfiguration();
        try {
            object = object.getReceiver(configuration.makePipelineConfiguration(), configuration.obtainDefaultSerializationProperties());
            this.b.explain(new ExpressionPresenter(configuration, (Receiver)object));
            return;
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void export(OutputStream outputStream) {
        String string = this.b.getTopLevelPackage().getTargetEdition();
        if (string == null) {
            string = this.getProcessor().getSaxonEdition();
        }
        this.export(outputStream, string);
    }

    public void export(OutputStream outputStream, String object) {
        Configuration configuration = this.a.getUnderlyingConfiguration();
        try {
            StylesheetPackage stylesheetPackage = this.b.getTopLevelPackage();
            object = configuration.newExpressionExporter((String)object, outputStream, stylesheetPackage);
            ((ExpressionPresenter)object).setRelocatable(stylesheetPackage.isRelocatable());
            stylesheetPackage.export((ExpressionPresenter)object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            throw new SaxonApiException(iOException);
        }
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        StylesheetPackage stylesheetPackage = this.b.getTopLevelPackage();
        if (stylesheetPackage.isStripsWhitespace()) {
            return new WhitespaceStrippingPolicy(this.b.getTopLevelPackage());
        }
        return WhitespaceStrippingPolicy.UNSPECIFIED;
    }

    public HashMap<QName, ParameterDetails> getGlobalParameters() {
        Map<StructuredQName, GlobalParam> map = this.b.getGlobalParameters();
        HashMap<QName, ParameterDetails> hashMap = new HashMap<QName, ParameterDetails>();
        for (GlobalParam globalParam : map.values()) {
            ParameterDetails parameterDetails = new ParameterDetails(this, globalParam.getRequiredType(), globalParam.isRequiredParam());
            hashMap.put(new QName(globalParam.getVariableQName()), parameterDetails);
        }
        return hashMap;
    }

    public PreparedStylesheet getUnderlyingCompiledStylesheet() {
        return this.b;
    }

    public class ParameterDetails {
        private SequenceType a;
        private boolean b;
        private /* synthetic */ XsltExecutable c;

        protected ParameterDetails(XsltExecutable xsltExecutable, SequenceType sequenceType, boolean bl2) {
            this.c = xsltExecutable;
            this.a = sequenceType;
            this.b = bl2;
        }

        public ItemType getDeclaredItemType() {
            return new b(this.a.getPrimaryType(), this.c.a);
        }

        public OccurrenceIndicator getDeclaredCardinality() {
            return OccurrenceIndicator.getOccurrenceIndicator(this.a.getCardinality());
        }

        public SequenceType getUnderlyingDeclaredType() {
            return this.a;
        }

        public boolean isRequired() {
            return this.b;
        }
    }
}

