/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Query;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.WhitespaceStrippingPolicy;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.PackageVersion;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.XPathException;

public class XsltPackage {
    private XsltCompiler a;
    private StylesheetPackage b;

    protected XsltPackage(XsltCompiler xsltCompiler, StylesheetPackage stylesheetPackage) {
        this.a = xsltCompiler;
        this.b = stylesheetPackage;
    }

    public Processor getProcessor() {
        return this.a.getProcessor();
    }

    public String getName() {
        return this.b.getPackageName();
    }

    public String getVersion() {
        return this.b.getPackageVersion().toString();
    }

    public PackageVersion getPackageVersion() {
        return this.b.getPackageVersion();
    }

    public WhitespaceStrippingPolicy getWhitespaceStrippingPolicy() {
        return new WhitespaceStrippingPolicy(this.b);
    }

    public XsltExecutable link() {
        try {
            Object object = this.getProcessor().getUnderlyingConfiguration();
            CompilerInfo compilerInfo = this.a.getUnderlyingCompilerInfo();
            object = new Compilation((Configuration)object, compilerInfo);
            ((Compilation)object).setPackageData(this.b);
            this.b.checkForAbstractComponents();
            object = new PreparedStylesheet((Compilation)object);
            this.b.updatePreparedStylesheet((PreparedStylesheet)object);
            ((Executable)object).addPackage(this.b);
            return new XsltExecutable(this.getProcessor(), (PreparedStylesheet)object);
        }
        catch (XPathException xPathException) {
            throw new SaxonApiException(xPathException);
        }
    }

    public void save(File file) {
        String string = this.b.getTargetEdition();
        if (string == null) {
            string = this.getProcessor().getSaxonEdition();
        }
        this.save(file, string);
    }

    public void save(File object, String string) {
        try {
            Query.createFileIfNecessary((File)object);
            object = this.getProcessor().getUnderlyingConfiguration().newExpressionExporter(string, new FileOutputStream((File)object), this.b);
            ((ExpressionPresenter)object).setRelocatable(this.b.isRelocatable());
            this.b.export((ExpressionPresenter)object);
            return;
        }
        catch (IOException | XPathException exception) {
            throw new SaxonApiException(exception);
        }
    }

    public StylesheetPackage getUnderlyingPreparedPackage() {
        return this.b;
    }
}

