/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.function.Function;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.RegularSequenceChecker;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.DelegatingErrorListener;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.ResultDocumentResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.MessageListener2;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.ValidationMode;
import net.sf.saxon.s9api.c;
import net.sf.saxon.s9api.d;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.tiny.TinyBuilder;

abstract class a {
    protected Processor processor;
    protected XsltController controller;
    protected boolean baseOutputUriWasSet = false;
    private ResultDocumentResolver a = null;
    private MessageListener b;
    private MessageListener2 c;

    a(Processor processor, XsltController xsltController) {
        this.processor = processor;
        this.controller = xsltController;
    }

    public void setBaseOutputURI(String string) {
        this.controller.setBaseOutputURI(string);
        this.baseOutputUriWasSet = string != null;
    }

    public String getBaseOutputURI() {
        return this.controller.getBaseOutputURI();
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.controller.setURIResolver(uRIResolver);
    }

    public URIResolver getURIResolver() {
        return this.controller.getURIResolver();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.controller.setErrorListener(errorListener);
    }

    public ErrorListener getErrorListener() {
        UnfailingErrorListener unfailingErrorListener = this.controller.getErrorListener();
        if (unfailingErrorListener instanceof DelegatingErrorListener) {
            return ((DelegatingErrorListener)unfailingErrorListener).getBaseErrorListener();
        }
        return unfailingErrorListener;
    }

    public void setResultDocumentHandler(Function<URI, Destination> function) {
        this.controller.setResultDocumentResolver(new ResultDocumentResolver(this, function){
            private /* synthetic */ Function a;
            private /* synthetic */ a b;
            {
                this.b = a2;
                this.a = function;
            }

            @Override
            public final Receiver resolve(XPathContext object, String object2, String string, SerializationProperties serializationProperties) {
                try {
                    object2 = ResolveURI.makeAbsolute((String)object2, string);
                    try {
                        object2 = (Destination)this.a.apply(object2);
                    }
                    catch (SaxonApiUncheckedException saxonApiUncheckedException) {
                        object = saxonApiUncheckedException;
                        object = XPathException.makeXPathException(saxonApiUncheckedException);
                        ((XPathException)object).maybeSetErrorCode("SXRD0001");
                        throw object;
                    }
                    try {
                        return object2.getReceiver(object.getReceiver().getPipelineConfiguration(), serializationProperties);
                    }
                    catch (SaxonApiException saxonApiException) {
                        object = saxonApiException;
                        throw XPathException.makeXPathException(saxonApiException);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    object2 = uRISyntaxException;
                    throw XPathException.makeXPathException(uRISyntaxException);
                }
            }
        });
    }

    public void setMessageListener(MessageListener messageListener) {
        this.b = messageListener;
        this.controller.setMessageFactory(() -> new d(messageListener, this.controller.makePipelineConfiguration()));
    }

    public void setMessageListener(MessageListener2 messageListener2) {
        this.c = messageListener2;
        this.controller.setMessageFactory(() -> new c(messageListener2, this.controller.makePipelineConfiguration()));
    }

    public MessageListener getMessageListener() {
        return this.b;
    }

    public MessageListener2 getMessageListener2() {
        return this.c;
    }

    public void setAssertionsEnabled(boolean bl2) {
        this.controller.setAssertionsEnabled(bl2);
    }

    public boolean isAssertionsEnabled() {
        return this.controller.isAssertionsEnabled();
    }

    public void setTraceListener(TraceListener traceListener) {
        this.controller.setTraceListener(traceListener);
    }

    public TraceListener getTraceListener() {
        return this.controller.getTraceListener();
    }

    public void setTraceFunctionDestination(Logger logger) {
        this.controller.setTraceFunctionDestination(logger);
    }

    public Logger getTraceFunctionDestination() {
        return this.controller.getTraceFunctionDestination();
    }

    protected void applyTemplatesToSource(Source source, Receiver receiver) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(receiver);
        if (this.controller.getInitialMode().isDeclaredStreamable() && this.isStreamableSource(source)) {
            this.controller.applyStreamingTemplates(source, receiver);
            return;
        }
        source = source instanceof NodeInfo ? (NodeInfo)source : this.controller.makeSourceTree(source, this.controller.getSchemaValidationMode());
        this.controller.applyTemplates((Sequence<?>)((Object)source), receiver);
    }

    protected boolean isStreamableSource(Source source) {
        if (source instanceof AugmentedSource) {
            return this.isStreamableSource(((AugmentedSource)source).getContainedSource());
        }
        Configuration configuration = this.controller.getConfiguration();
        try {
            source = configuration.getSourceResolver().resolveSource(source, configuration);
        }
        catch (XPathException xPathException) {
            return false;
        }
        return source instanceof SAXSource || source instanceof StreamSource || source instanceof EventSource;
    }

    public void setSchemaValidationMode(ValidationMode validationMode) {
        if (validationMode != null) {
            this.controller.setSchemaValidationMode(validationMode.getNumber());
        }
    }

    public ValidationMode getSchemaValidationMode() {
        return ValidationMode.get(this.controller.getSchemaValidationMode());
    }

    public void setInitialMode(QName qName) {
        try {
            this.controller.setInitialMode(qName == null ? null : qName.getStructuredQName());
            return;
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException);
        }
    }

    public QName getInitialMode() {
        StructuredQName structuredQName = this.controller.getInitialModeName();
        if (structuredQName == null) {
            return null;
        }
        return new QName(structuredQName);
    }

    public XsltController getUnderlyingController() {
        return this.controller;
    }

    public Receiver getDestinationReceiver(XsltController xsltController, Destination destination) {
        xsltController.setPrincipalDestination(destination);
        Object object = xsltController.makePipelineConfiguration();
        SerializationProperties serializationProperties = xsltController.getExecutable().getPrimarySerializationProperties();
        object = destination.getReceiver((PipelineConfiguration)object, serializationProperties);
        if (Configuration.isAssertionsEnabled()) {
            object = new RegularSequenceChecker((Receiver)object);
        }
        object.getPipelineConfiguration().setController(xsltController);
        if (this.baseOutputUriWasSet) {
            try {
                if (destination.getDestinationBaseURI() == null) {
                    destination.setDestinationBaseURI(new URI(xsltController.getBaseOutputURI()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (destination.getDestinationBaseURI() != null) {
            xsltController.setBaseOutputURI(destination.getDestinationBaseURI().toASCIIString());
        }
        object.setSystemId(xsltController.getBaseOutputURI());
        return object;
    }

    protected Receiver getReceivingTransformer(XsltController xsltController, GlobalParameterSet globalParameterSet, Destination destination) {
        Object object = xsltController.getConfiguration();
        if (xsltController.getInitialMode().isDeclaredStreamable()) {
            Receiver receiver = this.getDestinationReceiver(xsltController, destination);
            try {
                xsltController.initializeController(globalParameterSet);
                XsltController xsltController2 = xsltController;
                return xsltController2.getStreamingReceiver(xsltController2.getInitialMode(), receiver);
            }
            catch (TransformerException transformerException) {
                throw new SaxonApiException(transformerException);
            }
        }
        Builder builder = xsltController.makeBuilder();
        if (builder instanceof TinyBuilder) {
            ((TinyBuilder)builder).setStatistics(((Configuration)object).getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
        }
        object = xsltController.makeStripper(builder);
        if (xsltController.isStylesheetStrippingTypeAnnotations()) {
            object = xsltController.getConfiguration().getAnnotationStripper((Receiver)object);
        }
        return new TreeReceiver(this, (Receiver)object, builder, xsltController, destination, globalParameterSet){
            private boolean a;
            private /* synthetic */ Builder b;
            private /* synthetic */ XsltController c;
            private /* synthetic */ Destination d;
            private /* synthetic */ GlobalParameterSet e;
            private /* synthetic */ a f;
            {
                this.f = a2;
                this.b = builder;
                this.c = xsltController;
                this.d = destination;
                this.e = globalParameterSet;
                super(receiver);
                this.a = false;
            }

            @Override
            public final void close() {
                if (!this.a) {
                    block5: {
                        try {
                            NodeInfo nodeInfo = this.b.getCurrentRoot();
                            if (nodeInfo == null) break block5;
                            nodeInfo.getTreeInfo().setSpaceStrippingRule(this.c.getSpaceStrippingRule());
                            Receiver receiver = this.f.getDestinationReceiver(this.c, this.d);
                            try {
                                this.c.setGlobalContextItem(nodeInfo);
                                this.c.initializeController(this.e);
                                this.c.applyTemplates(nodeInfo, receiver);
                            }
                            catch (TransformerException transformerException) {
                                throw new SaxonApiException(transformerException);
                            }
                        }
                        catch (SaxonApiException saxonApiException) {
                            SaxonApiException saxonApiException2 = saxonApiException;
                            throw XPathException.makeXPathException(saxonApiException);
                        }
                    }
                    this.a = true;
                }
            }
        };
    }
}

