/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api.streams;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmFunctionItem;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmMap;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.streams.Step;

public class Predicates {
    public static Predicate<XdmItem> isNode() {
        return xdmItem -> xdmItem instanceof XdmNode;
    }

    public static Predicate<XdmItem> isElement() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.ELEMENT;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isAttribute() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.ATTRIBUTE;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isText() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.TEXT;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isComment() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.COMMENT;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isProcessingInstruction() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.PROCESSING_INSTRUCTION;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isDocument() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.DOCUMENT;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isNamespace() {
        XdmNodeKind xdmNodeKind = XdmNodeKind.NAMESPACE;
        return xdmItem -> xdmItem instanceof XdmNode && ((XdmNode)xdmItem).getNodeKind() == xdmNodeKind;
    }

    public static Predicate<XdmItem> isAtomic() {
        return xdmItem -> xdmItem instanceof XdmAtomicValue;
    }

    public static Predicate<XdmItem> isFunction() {
        return xdmItem -> xdmItem instanceof XdmFunctionItem;
    }

    public static Predicate<XdmItem> isMap() {
        return xdmItem -> xdmItem instanceof XdmMap;
    }

    public static Predicate<XdmItem> isArray() {
        return xdmItem -> xdmItem instanceof XdmArray;
    }

    public static <T extends XdmItem> Predicate<XdmItem> empty(Step<T> step) {
        return xdmItem -> !((Stream)step.apply(xdmItem)).findFirst().isPresent();
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T extends XdmItem> Predicate<XdmItem> exists(Step<T> step) {
        return xdmItem -> ((Stream)step.apply(xdmItem)).findFirst().isPresent();
    }

    public static Predicate<? super XdmNode> hasName(String string, String string2) {
        return object -> (object = ((XdmNode)object).getNodeName()) != null && ((QName)object).getLocalName().equals(string2) && ((QName)object).getNamespaceURI().equals(string);
    }

    public static Predicate<XdmNode> hasLocalName(String string) {
        return object -> (object = ((XdmNode)object).getNodeName()) != null && ((QName)object).getLocalName().equals(string);
    }

    public static Predicate<XdmNode> hasNamespace(String string) {
        return object -> (object = ((XdmNode)object).getNodeName()) != null && ((QName)object).getNamespaceURI().equals(string);
    }

    public static Predicate<XdmNode> hasAttribute(String string) {
        return xdmNode -> xdmNode.attribute(string) != null;
    }

    public static Predicate<XdmNode> attributeEq(String string, String string2) {
        return xdmNode -> string2.equals(xdmNode.attribute(string));
    }

    public static Predicate<XdmItem> hasType(ItemType itemType) {
        return itemType::matches;
    }

    public static <T extends XdmItem> Predicate<XdmItem> some(Step<T> step, Predicate<? super T> predicate) {
        return xdmItem -> ((Stream)step.apply(xdmItem)).anyMatch(predicate);
    }

    public static <T extends XdmItem> Predicate<XdmItem> every(Step<T> step, Predicate<? super XdmItem> predicate) {
        return xdmItem -> ((Stream)step.apply(xdmItem)).allMatch(predicate);
    }

    public static Predicate<XdmAtomicValue> eq(XdmAtomicValue object) {
        object = ((XdmAtomicValue)object).getUnderlyingValue().asMapKey();
        return arg_0 -> Predicates.a((AtomicMatchKey)object, arg_0);
    }

    public static Predicate<XdmItem> eq(String string) {
        return xdmItem -> xdmItem.getStringValue().equals(string);
    }

    public static Predicate<XdmItem> matchesRegex(String object) {
        object = Pattern.compile((String)object);
        return arg_0 -> Predicates.a((Pattern)object, arg_0);
    }

    public static <T extends XdmItem> Predicate<XdmItem> eq(Step<T> step, String string) {
        return Predicates.some(step, Predicates.eq(string));
    }

    private static /* synthetic */ boolean a(Pattern pattern, XdmItem xdmItem) {
        return pattern.matcher(xdmItem.getStringValue()).find();
    }

    private static /* synthetic */ boolean a(AtomicMatchKey atomicMatchKey, XdmAtomicValue xdmAtomicValue) {
        return xdmAtomicValue.getUnderlyingValue().asMapKey().equals(atomicMatchKey);
    }
}

