/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api.streams;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmArray;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Predicates;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.a;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Whitespace;

public class Steps {
    private static final Step<XdmNode> a = new a(Axis.ANCESTOR);
    private static final Step<XdmNode> b = new a(Axis.ANCESTOR_OR_SELF);
    private static final Step<XdmNode> c = new a(Axis.ATTRIBUTE);
    private static final Step<XdmNode> d = new a(Axis.CHILD);
    private static final Step<XdmNode> e = new a(Axis.DESCENDANT);
    private static final Step<XdmNode> f = new a(Axis.DESCENDANT_OR_SELF);
    private static final Step<XdmNode> g = new a(Axis.FOLLOWING);
    private static final Step<XdmNode> h = new a(Axis.FOLLOWING_SIBLING);
    private static final Step<XdmNode> i = new a(Axis.NAMESPACE);
    private static final Step<XdmNode> j = new a(Axis.PARENT);
    private static final Step<XdmNode> k = new a(Axis.PRECEDING_SIBLING);
    private static final Step<XdmNode> l = new a(Axis.PRECEDING);
    private static final Step<XdmNode> m = new a(Axis.SELF);

    public static Step<XdmNode> root() {
        return new Step<XdmNode>(){

            @Override
            public final /* synthetic */ Object apply(Object object) {
                if ((object = (XdmItem)object) instanceof XdmNode) {
                    return Stream.of(((XdmNode)object).getRoot());
                }
                return Stream.empty();
            }
        };
    }

    public static Step<XdmAtomicValue> atomize() {
        return new Step<XdmAtomicValue>(){

            private static Stream<? extends XdmAtomicValue> a(XdmItem iterable) {
                if (iterable instanceof XdmAtomicValue) {
                    return Stream.of((XdmAtomicValue)iterable);
                }
                if (iterable instanceof XdmNode) {
                    try {
                        return ((XdmNode)iterable).getTypedValue().stream();
                    }
                    catch (SaxonApiException saxonApiException) {
                        throw new SaxonApiUncheckedException(saxonApiException);
                    }
                }
                if (iterable instanceof XdmArray) {
                    try {
                        iterable = ((XdmArray)iterable).getUnderlyingValue();
                        iterable = iterable.atomize();
                        return XdmValue.wrap((AtomicSequence)iterable).stream();
                    }
                    catch (XPathException xPathException) {
                        throw new SaxonApiUncheckedException(new SaxonApiException(xPathException));
                    }
                }
                throw new SaxonApiUncheckedException(new SaxonApiException("Cannot atomize supplied value"));
            }

            @Override
            public final /* synthetic */ Object apply(Object object) {
                return 2.a((XdmItem)object);
            }
        };
    }

    public static Step<XdmAtomicValue> castAs(ItemType object) {
        if (!ItemType.ANY_ATOMIC_VALUE.subsumes((ItemType)object)) {
            throw new IllegalArgumentException("Target of castAs must be an atomic type");
        }
        net.sf.saxon.type.ItemType itemType = ((ItemType)object).getUnderlyingItemType().getPrimitiveItemType();
        object = ((ItemType)object).getConversionRules();
        return Steps.atomize().then(new Step<XdmAtomicValue>((ConversionRules)object, itemType){
            private /* synthetic */ ConversionRules a;
            private /* synthetic */ net.sf.saxon.type.ItemType b;
            {
                this.a = conversionRules;
                this.b = itemType;
            }

            private Stream<? extends XdmAtomicValue> a(XdmItem iterable) {
                try {
                    iterable = ((XdmAtomicValue)iterable).getUnderlyingValue();
                    Converter converter = this.a.getConverter(((AtomicValue)iterable).getItemType(), (AtomicType)this.b);
                    iterable = converter.convert((AtomicValue)iterable).asAtomic();
                    return Stream.of((XdmAtomicValue)XdmValue.wrap((AtomicSequence)iterable));
                }
                catch (ValidationException validationException) {
                    throw new SaxonApiUncheckedException(new SaxonApiException(validationException));
                }
            }

            @Override
            public final /* synthetic */ Object apply(Object object) {
                return this.a((XdmItem)object);
            }
        });
    }

    public static <U extends XdmItem> Step<U> nothing() {
        return new Step<U>(){

            @Override
            public final /* synthetic */ Object apply(Object object) {
                XdmItem cfr_ignored_0 = (XdmItem)object;
                return Stream.empty();
            }
        };
    }

    private static Predicate<? super XdmNode> a(String string) {
        if ("*".equals(string)) {
            return Predicates.isElement();
        }
        return iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string);
    }

    public static Step<XdmNode> ancestor() {
        return a;
    }

    public static Step<XdmNode> ancestor(String string) {
        return Steps.ancestor().where(Steps.a(string));
    }

    public static Step<XdmNode> ancestor(String string, String string2) {
        return Steps.ancestor().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> ancestor(Predicate<? super XdmNode> predicate) {
        return Steps.ancestor().where(predicate);
    }

    public static Step<XdmNode> ancestorOrSelf() {
        return b;
    }

    public static Step<XdmNode> ancestorOrSelf(String string) {
        return Steps.ancestorOrSelf().where(Steps.a(string));
    }

    public static Step<XdmNode> ancestorOrSelf(String string, String string2) {
        return Steps.ancestorOrSelf().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> ancestorOrSelf(Predicate<? super XdmNode> predicate) {
        return Steps.ancestorOrSelf().where(predicate);
    }

    public static Step<XdmNode> attribute() {
        return c;
    }

    public static Step<XdmNode> attribute(String string) {
        if ("*".equals(string)) {
            return Steps.attribute();
        }
        return Steps.attribute().where(Predicates.hasLocalName(string));
    }

    public static Step<XdmNode> attribute(String string, String string2) {
        return Steps.attribute().where(Predicates.hasName(string, string2));
    }

    public static Step<XdmNode> attribute(Predicate<? super XdmNode> predicate) {
        return Steps.attribute().where(predicate);
    }

    public static Step<XdmNode> child() {
        return d;
    }

    public static Step<XdmNode> child(String string) {
        return Steps.child().where(Steps.a(string));
    }

    public static Step<XdmNode> child(String string, String string2) {
        return Steps.child().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> child(Predicate<? super XdmNode> predicate) {
        return Steps.child().where(predicate);
    }

    public static Step<XdmNode> descendant() {
        return e;
    }

    public static Step<XdmNode> descendant(String string) {
        return Steps.descendant().where(Steps.a(string));
    }

    public static Step<XdmNode> descendant(String string, String string2) {
        return Steps.descendant().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> descendantOrSelf() {
        return f;
    }

    public static Step<XdmNode> descendant(Predicate<? super XdmNode> predicate) {
        return Steps.descendant().where(predicate);
    }

    public static Step<XdmNode> descendantOrSelf(String string) {
        return Steps.descendantOrSelf().where(Steps.a(string));
    }

    public static Step<XdmNode> descendantOrSelf(String string, String string2) {
        return Steps.descendantOrSelf().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> descendantOrSelf(Predicate<? super XdmNode> predicate) {
        return Steps.descendantOrSelf().where(predicate);
    }

    public static Step<XdmNode> following() {
        return g;
    }

    public static Step<XdmNode> following(String string) {
        return Steps.following().where(Steps.a(string));
    }

    public static Step<XdmNode> following(String string, String string2) {
        return Steps.following().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> following(Predicate<? super XdmNode> predicate) {
        return Steps.following().where(predicate);
    }

    public static Step<XdmNode> followingSibling() {
        return h;
    }

    public static Step<XdmNode> followingSibling(String string) {
        return Steps.followingSibling().where(Steps.a(string));
    }

    public static Step<XdmNode> followingSibling(String string, String string2) {
        return Steps.followingSibling().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> followingSibling(Predicate<? super XdmNode> predicate) {
        return Steps.followingSibling().where(predicate);
    }

    public static Step<XdmNode> namespace() {
        return i;
    }

    public static Step<XdmNode> namespace(String string) {
        if ("*".equals(string)) {
            return Steps.namespace();
        }
        return Steps.namespace().where(Predicates.hasLocalName(string));
    }

    public static Step<XdmNode> namespace(Predicate<? super XdmNode> predicate) {
        return Steps.namespace().where(predicate);
    }

    public static Step<XdmNode> parent() {
        return j;
    }

    public static Step<XdmNode> parent(String string) {
        return Steps.parent().where(Predicates.isElement()).where(Steps.a(string));
    }

    public static Step<XdmNode> parent(String string, String string2) {
        return Steps.parent().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> parent(Predicate<? super XdmNode> predicate) {
        return Steps.parent().where(predicate);
    }

    public static Step<XdmNode> precedingSibling() {
        return k;
    }

    public static Step<XdmNode> precedingSibling(String string) {
        return Steps.precedingSibling().where(Steps.a(string));
    }

    public static Step<XdmNode> precedingSibling(String string, String string2) {
        return Steps.precedingSibling().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> precedingSibling(Predicate<? super XdmNode> predicate) {
        return Steps.precedingSibling().where(predicate);
    }

    public static Step<XdmNode> preceding() {
        return l;
    }

    public static Step<XdmNode> preceding(String string) {
        return Steps.preceding().where(Steps.a(string));
    }

    public static Step<XdmNode> preceding(String string, String string2) {
        return Steps.preceding().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> preceding(Predicate<? super XdmNode> predicate) {
        return Steps.preceding().where(predicate);
    }

    public static Step<XdmNode> self() {
        return m;
    }

    public static Step<XdmNode> self(String string) {
        return Steps.self().where(Steps.a(string));
    }

    public static Step<XdmNode> self(String string, String string2) {
        return Steps.self().where(iterable -> (iterable = ((XdmNode)iterable).getUnderlyingNode()).getNodeKind() == 1 && iterable.getLocalPart().equals(string2) && iterable.getURI().equals(string));
    }

    public static Step<XdmNode> self(Predicate<? super XdmNode> predicate) {
        return Steps.self().where(predicate);
    }

    public static Step<XdmNode> text() {
        return Steps.child().where(Predicates.isText());
    }

    @SafeVarargs
    public static Step<? extends XdmNode> path(Step<? extends XdmNode> ... stepArray) {
        return Steps.a(Arrays.asList(stepArray));
    }

    private static Step<? extends XdmNode> a(List<Step<? extends XdmNode>> list) {
        if (list.isEmpty()) {
            return Steps.nothing();
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return list.get(0).then(Steps.a(list.subList(1, list.size())));
    }

    public static Step<? extends XdmNode> path(String ... stringArray) {
        ArrayList<Step<? extends XdmNode>> arrayList = new ArrayList<Step<? extends XdmNode>>();
        for (String string : stringArray) {
            if (string.equals("/")) {
                arrayList.add(Steps.root().where(Predicates.isDocument()));
                continue;
            }
            if (string.equals("..")) {
                arrayList.add(Steps.parent());
                continue;
            }
            if (string.equals("*")) {
                arrayList.add(Steps.child(Predicates.isElement()));
                continue;
            }
            if (string.equals("//")) {
                arrayList.add(Steps.descendantOrSelf());
                continue;
            }
            if (string.startsWith("@")) {
                if (!NameChecker.isValidNCName(string = string.substring(1))) {
                    throw new IllegalArgumentException("Invalid attribute name " + string);
                }
                arrayList.add(Steps.attribute(string));
                continue;
            }
            if (!NameChecker.isValidNCName(string)) {
                throw new IllegalArgumentException("Invalid element name " + string);
            }
            arrayList.add(Steps.child(string));
        }
        return Steps.a(arrayList);
    }

    public static Step<XdmAtomicValue> tokenize() {
        return new Step<XdmAtomicValue>(){

            @Override
            public final /* synthetic */ Object apply(Object object) {
                object = (XdmItem)object;
                object = new Whitespace.Tokenizer(((XdmItem)object).getStringValue());
                return XdmSequenceIterator.ofAtomicValues((UnfailingIterator<? extends AtomicValue>)object).stream();
            }
        };
    }

    public static Step<XdmNode> id(XdmNode xdmNode) {
        return new Step<XdmNode>(xdmNode){
            private /* synthetic */ XdmNode a;
            {
                this.a = xdmNode;
            }

            @Override
            public final /* synthetic */ Object apply(Object object) {
                XdmItem xdmItem = (XdmItem)object;
                object = this;
                if (object.a.getNodeKind() != XdmNodeKind.DOCUMENT) {
                    throw new IllegalArgumentException("id() - argument is not a document node");
                }
                object = object.a.getUnderlyingNode().getTreeInfo().selectID(xdmItem.getStringValue(), true);
                if (object == null) {
                    return Stream.empty();
                }
                return Stream.of((XdmNode)XdmNode.wrap(object));
            }
        };
    }
}

