/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api.streams;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.streams.Step;
import net.sf.saxon.s9api.streams.XdmCollectors;

public class XdmStream<T extends XdmItem>
implements Stream<T> {
    private Stream<T> a;

    public XdmStream(Stream<T> stream) {
        this.a = stream;
    }

    public XdmStream(Optional<T> optional) {
        this.a = optional.map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public XdmStream<T> filter(Predicate<? super T> predicate) {
        return new XdmStream<T>(this.a.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super T, ? extends R> function) {
        return this.a.map(function);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> toIntFunction) {
        return this.a.mapToInt(toIntFunction);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> toLongFunction) {
        return this.a.mapToLong(toLongFunction);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> toDoubleFunction) {
        return this.a.mapToDouble(toDoubleFunction);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> function) {
        return this.a.flatMap(function);
    }

    public <U extends XdmItem> XdmStream<U> flatMapToXdm(Step<U> step) {
        return new XdmStream(this.a.flatMap(step));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> function) {
        return this.a.flatMapToInt(function);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> function) {
        return this.a.flatMapToLong(function);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> function) {
        return this.a.flatMapToDouble(function);
    }

    @Override
    public XdmStream<T> distinct() {
        return new XdmStream<T>(this.a.distinct());
    }

    @Override
    public XdmStream<T> sorted() {
        return new XdmStream<T>(this.a.sorted());
    }

    @Override
    public XdmStream<T> sorted(Comparator<? super T> comparator) {
        return new XdmStream<T>(this.a.sorted(comparator));
    }

    @Override
    public XdmStream<T> peek(Consumer<? super T> consumer) {
        return new XdmStream<T>(this.a.peek(consumer));
    }

    @Override
    public XdmStream<T> limit(long l2) {
        return new XdmStream<T>(this.a.limit(l2));
    }

    @Override
    public XdmStream<T> skip(long l2) {
        return new XdmStream<T>(this.a.skip(l2));
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.a.forEach(consumer);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> consumer) {
        this.a.forEachOrdered(consumer);
    }

    @Override
    public Object[] toArray() {
        return this.a.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> intFunction) {
        return this.a.toArray(intFunction);
    }

    @Override
    public T reduce(T t2, BinaryOperator<T> binaryOperator) {
        return (T)((XdmItem)this.a.reduce(t2, binaryOperator));
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> binaryOperator) {
        return this.a.reduce(binaryOperator);
    }

    @Override
    public <U> U reduce(U u2, BiFunction<U, ? super T, U> biFunction, BinaryOperator<U> binaryOperator) {
        return this.a.reduce(u2, biFunction, binaryOperator);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> biConsumer, BiConsumer<R, R> biConsumer2) {
        return this.a.collect(supplier, biConsumer, biConsumer2);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.a.collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.a.min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.a.max(comparator);
    }

    @Override
    public long count() {
        return this.a.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.a.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.a.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.a.noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.a.findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.a.findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.a.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.a.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.a.isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return new XdmStream<T>((Stream)this.a.sequential());
    }

    @Override
    public Stream<T> parallel() {
        return new XdmStream<T>((Stream)this.a.parallel());
    }

    @Override
    public Stream<T> unordered() {
        return new XdmStream<T>((Stream)this.a.unordered());
    }

    @Override
    public Stream<T> onClose(Runnable runnable) {
        return new XdmStream<T>((Stream)this.a.onClose(runnable));
    }

    @Override
    public void close() {
        this.a.close();
    }

    public XdmValue asXdmValue() {
        return (XdmValue)this.a.collect(XdmCollectors.asXdmValue());
    }

    public List<T> asList() {
        return this.a.collect(Collectors.toList());
    }

    public List<XdmNode> asListOfNodes() {
        return (List)this.a.collect(XdmCollectors.asListOfNodes());
    }

    public Optional<XdmNode> asOptionalNode() {
        return (Optional)this.a.collect(XdmCollectors.asOptionalNode());
    }

    public XdmNode asNode() {
        return (XdmNode)this.a.collect(XdmCollectors.asNode());
    }

    public List<XdmAtomicValue> asListOfAtomic() {
        return (List)this.a.collect(XdmCollectors.asListOfAtomic());
    }

    public Optional<XdmAtomicValue> asOptionalAtomic() {
        return (Optional)this.a.collect(XdmCollectors.asOptionalAtomic());
    }

    public XdmAtomicValue asAtomic() {
        return (XdmAtomicValue)this.a.collect(XdmCollectors.asAtomic());
    }

    public Optional<String> asOptionalString() {
        return (Optional)this.a.collect(XdmCollectors.asOptionalString());
    }

    public String asString() {
        return (String)this.a.collect(XdmCollectors.asString());
    }

    public XdmStream<T> first() {
        Optional<T> optional = this.a.findFirst();
        return new XdmStream<T>(optional);
    }

    public boolean exists() {
        Optional<T> optional = this.a.findFirst();
        return optional.isPresent();
    }

    public XdmStream<T> last() {
        Optional<T> optional = this.a.reduce((xdmItem, xdmItem2) -> xdmItem2);
        return new XdmStream<T>(optional);
    }

    public Optional<T> at(int n2) {
        return this.a.skip(n2).findFirst();
    }

    public XdmStream<T> subStream(int n2, int n3) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 <= n2) {
            return new XdmStream(Stream.empty());
        }
        return new XdmStream<T>(this.a.skip(n2).limit(n3 - n2));
    }

    public XdmStream<T> untilFirstInclusive(Predicate<? super XdmItem> object) {
        object = this.a.peek((? super T xdmItem) -> {
            if (object.test(xdmItem)) {
                this.a.close();
            }
        });
        return new XdmStream<T>(object);
    }

    public XdmStream<T> untilFirstExclusive(Predicate<? super XdmItem> predicate) {
        Stream<XdmItem> stream = this.a.peek((? super T xdmItem) -> {
            if (predicate.test((XdmItem)xdmItem)) {
                this.a.close();
            }
        });
        return new XdmStream<XdmItem>(stream.filter(predicate.negate()));
    }
}

