/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceiverWithOutputProperties;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.functions.FormatNumber;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.QualifiedNameValue;

public class AdaptiveEmitter
extends SequenceWriter
implements ReceiverWithOutputProperties {
    private Writer a;
    private Normalizer b;
    private CharacterMap c;
    private Properties d;
    private String e = "\n";
    private boolean f = false;

    public AdaptiveEmitter(PipelineConfiguration pipelineConfiguration, Writer writer) {
        super(pipelineConfiguration);
        this.a = writer;
    }

    public void setOutputProperties(Properties object) {
        this.d = object;
        if ((object = ((Properties)object).getProperty("item-separator")) != null && !"#absent".equals(object)) {
            this.e = object;
        }
    }

    @Override
    public Properties getOutputProperties() {
        return this.d;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.b = normalizer;
    }

    public void setCharacterMap(CharacterMap characterMap) {
        this.c = characterMap;
    }

    private void a(CharSequence charSequence) {
        try {
            this.a.append(charSequence);
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    @Override
    public void write(Item item) {
        if (this.f) {
            AdaptiveEmitter adaptiveEmitter = this;
            adaptiveEmitter.a(adaptiveEmitter.e);
        } else {
            this.f = true;
        }
        this.a(item);
    }

    private void a(Item item) {
        if (item instanceof AtomicValue) {
            AdaptiveEmitter adaptiveEmitter = this;
            adaptiveEmitter.a(adaptiveEmitter.a((AtomicValue)item));
            return;
        }
        if (item instanceof NodeInfo) {
            this.a((NodeInfo)item);
            return;
        }
        if (item instanceof MapItem) {
            this.a((MapItem)item);
            return;
        }
        if (item instanceof ArrayItem) {
            this.a((ArrayItem)item);
            return;
        }
        if (item instanceof Function) {
            this.a((Function)item);
        }
    }

    private String a(AtomicValue object) {
        switch (((AtomicValue)object).getPrimitiveType().getFingerprint()) {
            case 513: 
            case 529: 
            case 631: {
                object = ((AtomicValue)object).getStringValue();
                if (((String)object).contains("\"")) {
                    object = ((String)object).replace("\"", "\"\"");
                }
                if (this.c != null) {
                    object = this.c.map((CharSequence)object, false).toString();
                }
                return "\"" + (String)object + "\"";
            }
            case 514: {
                if (((AtomicValue)object).effectiveBooleanValue()) {
                    return "true()";
                }
                return "false()";
            }
            case 515: 
            case 533: {
                return ((AtomicValue)object).getStringValue();
            }
            case 517: {
                return FormatNumber.formatExponential((DoubleValue)object);
            }
            case 516: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 526: 
            case 527: 
            case 528: {
                return ((AtomicValue)object).getPrimitiveType().getDisplayName() + "(\"" + ((AtomicValue)object).getStringValue() + "\")";
            }
            case 633: 
            case 634: {
                return "xs:duration(\"" + ((AtomicValue)object).getStringValue() + "\")";
            }
            case 530: 
            case 531: {
                return ((QualifiedNameValue)object).getStructuredQName().getEQName();
            }
        }
        return "***";
    }

    private void a(Function function) {
        StructuredQName structuredQName = function.getFunctionName();
        if (structuredQName == null || structuredQName.hasURI("http://ns.saxonica.com/anonymous-type")) {
            this.a("(anonymous-function)");
        } else if (structuredQName.hasURI("http://www.w3.org/2005/xpath-functions")) {
            this.a("fn:" + structuredQName.getLocalPart());
        } else if (structuredQName.hasURI("http://www.w3.org/2005/xpath-functions/math")) {
            this.a("math:" + structuredQName.getLocalPart());
        } else if (structuredQName.hasURI("http://www.w3.org/2005/xpath-functions/map")) {
            this.a("map:" + structuredQName.getLocalPart());
        } else if (structuredQName.hasURI("http://www.w3.org/2005/xpath-functions/array")) {
            this.a("array:" + structuredQName.getLocalPart());
        } else if (structuredQName.hasURI("http://www.w3.org/2001/XMLSchema")) {
            this.a("xs:" + structuredQName.getLocalPart());
        } else {
            this.a(structuredQName.getEQName());
        }
        this.a("#" + function.getArity());
    }

    private void a(NodeInfo nodeInfo) {
        switch (nodeInfo.getNodeKind()) {
            case 2: {
                this.a(nodeInfo.getDisplayName());
                this.a("=\"");
                this.a(nodeInfo.getStringValueCS());
                this.a("\"");
                return;
            }
            case 13: {
                this.a(nodeInfo.getLocalPart().isEmpty() ? "xmlns" : "xmlns:" + nodeInfo.getLocalPart());
                this.a("=\"");
                this.a(nodeInfo.getStringValueCS());
                this.a("\"");
                return;
            }
        }
        StringWriter stringWriter = new StringWriter();
        Object object = new Properties(this.d);
        ((Properties)object).setProperty("method", "xml");
        ((Properties)object).setProperty("indent", "no");
        ((Properties)object).setProperty("omit-xml-declaration", "yes");
        ((Properties)object).setProperty("{http://saxon.sf.net/}unfailing", "yes");
        CharacterMapIndex characterMapIndex = null;
        if (this.c != null) {
            characterMapIndex = new CharacterMapIndex();
            characterMapIndex.putCharacterMap(this.c.getName(), this.c);
        }
        object = new SerializationProperties((Properties)object, characterMapIndex);
        QueryResult.serialize(nodeInfo, (Result)new StreamResult(stringWriter), (SerializationProperties)object);
        this.a(stringWriter.toString().trim());
    }

    private void a(ArrayItem object) {
        this.a("[");
        boolean bl2 = true;
        for (Sequence sequence : object.members()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.a(",");
            }
            this.a(sequence);
        }
        this.a("]");
    }

    private void a(MapItem object) {
        this.a("map{");
        boolean bl2 = true;
        for (KeyValuePair keyValuePair : object.keyValuePairs()) {
            if (bl2) {
                bl2 = false;
            } else {
                this.a(",");
            }
            this.a((Item)keyValuePair.key);
            this.a(":");
            GroundedValue<?> object2 = keyValuePair.value;
            this.a(object2);
        }
        this.a("}");
    }

    private void a(Sequence sequence) {
        boolean bl2 = true;
        SequenceIterator sequenceIterator = sequence.iterate();
        boolean bl3 = sequence instanceof GroundedValue && ((GroundedValue)sequence).getLength() == 1;
        if (!bl3) {
            this.a("(");
        }
        while ((sequence = sequenceIterator.next()) != null) {
            if (!bl2) {
                this.a(",");
            }
            bl2 = false;
            this.a((Item)sequence);
        }
        if (!bl3) {
            this.a(")");
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.a != null) {
            try {
                this.a.close();
                return;
            }
            catch (IOException iOException) {
                throw new XPathException(iOException);
            }
        }
    }
}

