/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.HexBinaryValue;

public class BinaryTextDecoder
extends ProxyReceiver {
    private String a = "utf8";

    public BinaryTextDecoder(Receiver receiver, Properties properties) {
        super(receiver);
        this.setOutputProperties(properties);
    }

    public void setOutputProperties(Properties properties) {
        this.a = properties.getProperty("encoding", "utf8");
    }

    @Override
    public void processingInstruction(String object, CharSequence charSequence, Location location, int n2) {
        Object object2;
        byte[] byArray = null;
        int n3 = ((String)object).indexOf(46);
        if (n3 >= 0 && n3 != ((String)object).length() - 1) {
            object2 = ((String)object).substring(n3 + 1);
            object = ((String)object).substring(0, n3);
        } else {
            object2 = this.a;
        }
        if (((String)object).equals("hex")) {
            byArray = new HexBinaryValue(charSequence).getBinaryValue();
        } else if (((String)object).equals("b64")) {
            byArray = new Base64BinaryValue(charSequence).getBinaryValue();
        }
        if (byArray != null) {
            try {
                object = new ByteArrayInputStream(byArray);
                object = new InputStreamReader((InputStream)object, (String)object2);
                object2 = new char[byArray.length];
                int n4 = ((InputStreamReader)object).read((char[])object2, 0, ((Object)object2).length);
                this.nextReceiver.characters(new CharSlice((char[])object2, 0, n4), location, n2);
                return;
            }
            catch (IOException iOException) {
                throw new XPathException("Text output method: failed to decode binary data " + Err.wrap(charSequence.toString(), 4));
            }
        }
    }
}

