/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.UnicodeNormalizer;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;

public class CDATAFilter
extends ProxyReceiver {
    private FastStringBuffer a = new FastStringBuffer(256);
    private Stack<NodeName> b = new Stack();
    private Set<NodeName> c;
    private CharacterSet d;

    public CDATAFilter(Receiver receiver) {
        super(receiver);
    }

    public void setOutputProperties(Properties properties) {
        Object object = properties;
        CDATAFilter cDATAFilter = this;
        boolean bl2 = "html".equals(((Properties)object).getProperty("method"));
        boolean bl3 = bl2 && "5.0".equals(((Properties)object).getProperty("version"));
        boolean bl4 = bl2 && !bl3;
        if ((object = ((Properties)object).getProperty("cdata-section-elements")) == null) {
            cDATAFilter.c = new HashSet<NodeName>(0);
        } else {
            cDATAFilter.c = new HashSet<NodeName>(10);
            object = new StringTokenizer((String)object, " \t\n\r", false);
            while (((StringTokenizer)object).hasMoreTokens()) {
                Object object2 = ((StringTokenizer)object).nextToken();
                object2 = StructuredQName.fromClarkName((String)object2);
                String string = ((StructuredQName)object2).getURI();
                if (bl2 && (!bl4 || string.equals("")) && (!bl3 || string.equals("") || string.equals("http://www.w3.org/1999/xhtml"))) continue;
                cDATAFilter.c.add(new FingerprintedQName("", ((StructuredQName)object2).getURI(), ((StructuredQName)object2).getLocalPart()));
            }
        }
        this.d = this.getConfiguration().getCharacterSetFactory().getCharacterSet(properties);
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        this.a();
        this.b.push(nodeName);
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
    }

    @Override
    public void endElement() {
        this.a();
        this.b.pop();
        this.nextReceiver.endElement();
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        this.a();
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if ((n2 & 1) == 0) {
            this.a.append(charSequence.toString());
            return;
        }
        this.a();
        this.nextReceiver.characters(charSequence, location, n2);
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        this.a();
        this.nextReceiver.comment(charSequence, location, n2);
    }

    private void a() {
        int n2;
        int n3 = this.a.length();
        if (n3 == 0) {
            return;
        }
        if (this.b.isEmpty()) {
            n2 = 0;
        } else {
            NodeName nodeName = this.b.peek();
            n2 = this.isCDATA(nodeName);
        }
        if (n2 != 0) {
            if (this.getNextReceiver() instanceof UnicodeNormalizer) {
                this.a = new FastStringBuffer(((UnicodeNormalizer)this.getNextReceiver()).normalize(this.a, true));
                n3 = this.a.length();
            }
            n2 = 0;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.a.charAt(n4);
                int n6 = 1;
                if (UTF16CharacterSet.isHighSurrogate((char)n5)) {
                    n5 = UTF16CharacterSet.combinePair((char)n5, this.a.charAt(n4 + 1));
                    n6 = 2;
                }
                if (n5 != 0 && this.d.inCharset(n5)) {
                    ++n4;
                    continue;
                }
                char[] cArray = new char[n4 - n2];
                this.a.getChars(n2, n4, cArray, 0);
                this.a(cArray, n4 - n2);
                while (n4 < n3) {
                    int n7 = n4;
                    this.nextReceiver.characters(this.a.subSequence(n7, n7 + n6), ExplicitLocation.UNKNOWN_LOCATION, 2);
                    if ((n4 += n6) >= n3) break;
                    int n8 = this.a.charAt(n4);
                    n6 = 1;
                    if (UTF16CharacterSet.isHighSurrogate((char)n8)) {
                        n8 = UTF16CharacterSet.combinePair((char)n8, this.a.charAt(n4 + 1));
                        n6 = 2;
                    }
                    if (!this.d.inCharset(n8)) continue;
                }
                n2 = n4;
            }
            char[] cArray = new char[n3 - n2];
            this.a.getChars(n2, n3, cArray, 0);
            this.a(cArray, n3 - n2);
        } else {
            this.nextReceiver.characters(this.a, ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        this.a.setLength(0);
    }

    private void a(char[] cArray, int n2) {
        if (n2 == 0) {
            return;
        }
        ExplicitLocation explicitLocation = ExplicitLocation.UNKNOWN_LOCATION;
        this.nextReceiver.characters("<![CDATA[", explicitLocation, 3);
        int n3 = 0;
        for (int i2 = 0; i2 < n2 - 2; ++i2) {
            if (cArray[i2] == ']' && cArray[i2 + 1] == ']' && cArray[i2 + 2] == '>') {
                this.nextReceiver.characters(new CharSlice(cArray, n3, i2 + 2 - n3), explicitLocation, 3);
                this.nextReceiver.characters("]]><![CDATA[", explicitLocation, 3);
                n3 = i2 + 2;
                continue;
            }
            if (cArray[i2] != '\u0000') continue;
            this.nextReceiver.characters(new CharSlice(cArray, n3, i2 - n3), explicitLocation, 3);
            n3 = i2 + 1;
        }
        this.nextReceiver.characters(new CharSlice(cArray, n3, n2 - n3), explicitLocation, 3);
        this.nextReceiver.characters("]]>", explicitLocation, 3);
    }

    protected boolean isCDATA(NodeName nodeName) {
        return this.c.contains(nodeName);
    }
}

