/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.trans.XPathException;

public class CharacterMapIndex
implements Iterable<CharacterMap> {
    private HashMap<StructuredQName, CharacterMap> a = new HashMap(10);

    public CharacterMap getCharacterMap(StructuredQName structuredQName) {
        return this.a.get(structuredQName);
    }

    public void putCharacterMap(StructuredQName structuredQName, CharacterMap characterMap) {
        this.a.put(structuredQName, characterMap);
    }

    @Override
    public Iterator<CharacterMap> iterator() {
        return this.a.values().iterator();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public CharacterMapIndex copy() {
        CharacterMapIndex characterMapIndex = new CharacterMapIndex();
        new CharacterMapIndex().a = new HashMap<StructuredQName, CharacterMap>(this.a);
        return characterMapIndex;
    }

    public CharacterMapExpander makeCharacterMapExpander(String object, Receiver receiver, SerializerFactory serializerFactory) {
        CharacterMapExpander characterMapExpander = null;
        ArrayList<CharacterMap> arrayList = new ArrayList<CharacterMap>(5);
        object = new StringTokenizer((String)object, " \t\n\r", false);
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            Object object2 = StructuredQName.fromClarkName(string);
            if ((object2 = this.getCharacterMap((StructuredQName)object2)) == null) {
                throw new XPathException("Character map '" + string + "' has not been defined", "SEPM0016");
            }
            arrayList.add((CharacterMap)object2);
        }
        if (!arrayList.isEmpty()) {
            characterMapExpander = serializerFactory.newCharacterMapExpander(receiver);
            if (arrayList.size() == 1) {
                characterMapExpander.setCharacterMap((CharacterMap)arrayList.get(0));
            } else {
                characterMapExpander.setCharacterMap(new CharacterMap(arrayList));
            }
        }
        return characterMapExpander;
    }
}

