/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.ReceiverWithOutputProperties;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.serialize.UTF8Writer;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;

public abstract class Emitter
extends SequenceReceiver
implements ReceiverWithOutputProperties {
    protected StreamResult streamResult;
    protected Writer writer;
    protected OutputStream outputStream;
    protected Properties outputProperties;
    protected CharacterSet characterSet;
    protected boolean allCharactersEncodable = false;
    private boolean a = false;

    public Emitter() {
        super(null);
    }

    public void setOutputProperties(Properties properties) {
        if (this.characterSet == null) {
            this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(properties);
            this.allCharactersEncodable = this.characterSet instanceof UTF8CharacterSet || this.characterSet instanceof UTF16CharacterSet;
        }
        this.outputProperties = properties;
    }

    @Override
    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setStreamResult(StreamResult streamResult) {
        this.streamResult = streamResult;
        if (this.systemId == null) {
            this.systemId = streamResult.getSystemId();
        }
    }

    protected void makeWriter() {
        OutputStream outputStream;
        if (this.writer != null) {
            return;
        }
        if (this.streamResult == null) {
            throw new IllegalStateException("Emitter must have either a Writer or a StreamResult to write to");
        }
        this.writer = this.streamResult.getWriter();
        if (this.writer == null && (outputStream = this.streamResult.getOutputStream()) != null) {
            this.setOutputStream(outputStream);
        }
        if (this.writer == null) {
            this.makeOutputStream();
        }
    }

    protected OutputStream makeOutputStream() {
        Object object = this.streamResult.getSystemId();
        if (object == null) {
            throw new XPathException("Result has no system ID, writer, or output stream defined");
        }
        try {
            object = ExpandedStreamResult.makeWritableOutputFile((String)object);
            this.setOutputStream(new FileOutputStream((File)object));
            this.streamResult.setOutputStream(this.outputStream);
            this.a = true;
        }
        catch (FileNotFoundException | IllegalArgumentException | URISyntaxException exception) {
            XPathException xPathException = new XPathException("Unable to write to output destination", exception);
            xPathException.setErrorCode("SXRD0004");
            throw xPathException;
        }
        return this.outputStream;
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer object) {
        this.writer = object;
        if (object instanceof OutputStreamWriter && this.outputProperties != null) {
            object = ((OutputStreamWriter)object).getEncoding();
            this.outputProperties.setProperty("encoding", (String)object);
            this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(this.outputProperties);
            this.allCharactersEncodable = this.characterSet instanceof UTF8CharacterSet || this.characterSet instanceof UTF16CharacterSet;
        }
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setOutputStream(OutputStream object) {
        this.outputStream = object;
        if (this.usesWriter()) {
            Object object2;
            if (this.outputProperties == null) {
                this.outputProperties = new Properties();
            }
            if ((object = this.outputProperties.getProperty("encoding")) == null) {
                object = "UTF8";
                this.allCharactersEncodable = true;
            } else if (((String)object).equalsIgnoreCase("UTF-8")) {
                object = "UTF8";
                this.allCharactersEncodable = true;
            } else if (((String)object).equalsIgnoreCase("UTF-16")) {
                object = "UTF16";
            }
            if (this.characterSet == null) {
                this.characterSet = this.getConfiguration().getCharacterSetFactory().getCharacterSet(this.outputProperties);
            }
            if ("no".equals(object2 = this.outputProperties.getProperty("byte-order-mark")) && "UTF16".equals(object)) {
                object = "UTF-16BE";
            } else if (!(this.characterSet instanceof UTF8CharacterSet)) {
                object = this.characterSet.getCanonicalName();
            }
            while (true) {
                try {
                    object2 = object;
                    if (((String)object).equalsIgnoreCase("iso-646") || ((String)object).equalsIgnoreCase("iso646")) {
                        object2 = "US-ASCII";
                    }
                    if (!((String)object).equalsIgnoreCase("UTF8")) {
                        this.writer = new BufferedWriter(new OutputStreamWriter(this.outputStream, (String)object2));
                        return;
                    }
                    this.writer = new UTF8Writer(this.outputStream);
                }
                catch (Exception exception) {
                    if (((String)object).equalsIgnoreCase("UTF8")) {
                        throw new XPathException("Failed to create a UTF8 output writer");
                    }
                    object = new XPathException("Encoding " + (String)object + " is not supported: using UTF8");
                    ((XPathException)object).setErrorCode("SESU0007");
                    this.getPipelineConfiguration().getErrorListener().error((TransformerException)object);
                    object = "UTF8";
                    this.characterSet = UTF8CharacterSet.getInstance();
                    this.allCharactersEncodable = true;
                    this.outputProperties.setProperty("encoding", "UTF-8");
                    continue;
                }
                break;
            }
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setUnparsedEntity(String string, String string2, String string3) {
    }

    @Override
    public void close() {
        if (this.a && this.outputStream != null) {
            try {
                this.outputStream.close();
                return;
            }
            catch (IOException iOException) {
                throw new XPathException("Failed to close output stream");
            }
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    @Override
    public void append(Item item, Location location, int n2) {
        if (item instanceof NodeInfo) {
            this.decompose(item, location, n2);
            return;
        }
        this.characters(item.getStringValueCS(), location, 0);
    }
}

