/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.serialize.UTF8Writer;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;

public class ExpandedStreamResult {
    private Configuration a;
    private Properties b;
    private String c;
    private Writer d;
    private OutputStream e;
    private CharacterSet f;
    private String g;
    private boolean h;
    private boolean i;

    public ExpandedStreamResult(Configuration object, StreamResult streamResult, Properties properties) {
        this.a = object;
        this.c = streamResult.getSystemId();
        this.d = streamResult.getWriter();
        this.e = streamResult.getOutputStream();
        this.g = properties.getProperty("encoding");
        if (this.g == null) {
            this.g = "UTF8";
            this.i = true;
        } else if (this.g.equalsIgnoreCase("UTF-8")) {
            this.g = "UTF8";
            this.i = true;
        } else if (this.g.equalsIgnoreCase("UTF-16")) {
            this.g = "UTF16";
        }
        if (this.f == null) {
            this.f = ((Configuration)object).getCharacterSetFactory().getCharacterSet(this.g);
        }
        if ("no".equals(object = properties.getProperty("byte-order-mark")) && "UTF16".equals(this.g)) {
            this.g = "UTF-16BE";
            return;
        }
        if (!(this.f instanceof UTF8CharacterSet)) {
            this.g = this.f.getCanonicalName();
        }
    }

    public Writer obtainWriter() {
        if (this.d != null) {
            return this.d;
        }
        OutputStream outputStream = this.obtainOutputStream();
        this.d = this.a(outputStream);
        return this.d;
    }

    protected OutputStream obtainOutputStream() {
        if (this.e != null) {
            return this.e;
        }
        Object object = this.c;
        if (object == null) {
            throw new XPathException("Result has no system ID, writer, or output stream defined");
        }
        try {
            object = ExpandedStreamResult.makeWritableOutputFile((String)object);
            this.e = new FileOutputStream((File)object);
            this.h = true;
        }
        catch (FileNotFoundException | IllegalArgumentException | URISyntaxException exception) {
            throw new XPathException(exception);
        }
        return this.e;
    }

    public static File makeWritableOutputFile(String string) {
        URI uRI = new URI(string);
        if (!uRI.isAbsolute()) {
            try {
                uRI = new File(string).getAbsoluteFile().toURI();
            }
            catch (Exception exception) {}
        }
        File file = new File(uRI);
        try {
            if ("file".equals(uRI.getScheme()) && !file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists()) {
                    file2.mkdirs();
                }
                file.createNewFile();
            }
            if (file.isDirectory()) {
                throw new XPathException("Cannot write to a directory: " + string, "SXRD0004");
            }
            if (!file.canWrite()) {
                throw new XPathException("Cannot write to URI " + string, "SXRD0004");
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failed to create output file " + uRI, iOException);
        }
        return file;
    }

    public boolean usesWriter() {
        return true;
    }

    public void setWriter(Writer writer) {
        this.d = writer;
        if (writer instanceof OutputStreamWriter) {
        }
    }

    public Writer getWriter() {
        return this.d;
    }

    private Writer a(OutputStream object) {
        this.e = object;
        try {
            object = this.g;
            if (this.g.equalsIgnoreCase("iso-646") || this.g.equalsIgnoreCase("iso646")) {
                object = "US-ASCII";
            }
            this.d = this.g.equalsIgnoreCase("UTF8") ? new UTF8Writer(this.e) : new BufferedWriter(new OutputStreamWriter(this.e, (String)object));
            return this.d;
        }
        catch (Exception exception) {
            if (this.g.equalsIgnoreCase("UTF8")) {
                throw new XPathException("Failed to create a UTF8 output writer");
            }
            throw new XPathException("Encoding " + this.g + " is not supported", "SESU0007");
        }
    }

    public OutputStream getOutputStream() {
        return this.e;
    }

    public CharacterSet getCharacterSet() {
        return this.f;
    }
}

