/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.trans.XPathException;

public class HTML40Emitter
extends HTMLEmitter {
    @Override
    protected boolean isHTMLElement(NodeName nodeName) {
        return nodeName.getURI().equals("");
    }

    @Override
    protected void openDocument() {
        Object object = this.outputProperties.getProperty("html-version");
        if (object == null) {
            object = this.outputProperties.getProperty("version");
        }
        if (object != null) {
            if (((String)object).equals("4.0") || ((String)object).equals("4.01")) {
                this.version = 4;
            } else {
                object = new XPathException("Unsupported HTML version: " + (String)object);
                ((XPathException)object).setErrorCode("SESU0013");
                throw object;
            }
        }
        object = this.outputProperties.getProperty("doctype-system");
        String string = this.outputProperties.getProperty("doctype-public");
        if ("".equals(object)) {
            object = null;
        }
        if ("".equals(string)) {
            string = null;
        }
        super.openDocument();
        if (object != null || string != null) {
            this.writeDocType(null, "html", (String)object, string);
        }
    }

    @Override
    protected boolean rejectControlCharacters() {
        return true;
    }

    static {
        HTML40Emitter.setEmptyTag("area");
        HTML40Emitter.setEmptyTag("base");
        HTML40Emitter.setEmptyTag("basefont");
        HTML40Emitter.setEmptyTag("br");
        HTML40Emitter.setEmptyTag("col");
        HTML40Emitter.setEmptyTag("embed");
        HTML40Emitter.setEmptyTag("frame");
        HTML40Emitter.setEmptyTag("hr");
        HTML40Emitter.setEmptyTag("img");
        HTML40Emitter.setEmptyTag("input");
        HTML40Emitter.setEmptyTag("isindex");
        HTML40Emitter.setEmptyTag("link");
        HTML40Emitter.setEmptyTag("meta");
        HTML40Emitter.setEmptyTag("param");
    }
}

