/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.trans.XPathException;

public class HTML50Emitter
extends HTMLEmitter {
    public HTML50Emitter() {
        this.version = 5;
    }

    @Override
    protected boolean isHTMLElement(NodeName object) {
        return ((String)(object = object.getURI())).equals("") || ((String)object).equals("http://www.w3.org/1999/xhtml");
    }

    @Override
    protected void openDocument() {
        this.version = 5;
        String string = this.outputProperties.getProperty("doctype-system");
        String string2 = this.outputProperties.getProperty("doctype-public");
        if ("".equals(string)) {
            string = null;
        }
        if ("".equals(string2)) {
            string2 = null;
        }
        super.openDocument();
        this.writeDocType(null, "html", string, string2);
    }

    @Override
    protected void writeDocType(NodeName nodeName, String string, String string2, String string3) {
        try {
            if (string2 != null || string3 != null) {
                super.writeDocType(nodeName, string, string2, string3);
                return;
            }
            this.writer.write("<!DOCTYPE HTML>\n");
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    @Override
    protected boolean writeDocTypeWithNullSystemId() {
        return true;
    }

    @Override
    protected boolean rejectControlCharacters() {
        return false;
    }

    static {
        HTML50Emitter.setEmptyTag("area");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("base");
        HTML50Emitter.setEmptyTag("basefont");
        HTML50Emitter.setEmptyTag("br");
        HTML50Emitter.setEmptyTag("col");
        HTML50Emitter.setEmptyTag("embed");
        HTML50Emitter.setEmptyTag("frame");
        HTML50Emitter.setEmptyTag("hr");
        HTML50Emitter.setEmptyTag("img");
        HTML50Emitter.setEmptyTag("input");
        HTML50Emitter.setEmptyTag("isindex");
        HTML50Emitter.setEmptyTag("keygen");
        HTML50Emitter.setEmptyTag("link");
        HTML50Emitter.setEmptyTag("meta");
        HTML50Emitter.setEmptyTag("param");
        HTML50Emitter.setEmptyTag("source");
        HTML50Emitter.setEmptyTag("track");
        HTML50Emitter.setEmptyTag("wbr");
    }
}

