/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Stack;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.type.SchemaType;

public abstract class HTMLEmitter
extends XMLEmitter {
    private int c = 0;
    private int d = 1;
    private int e;
    protected int version = 4;
    private String f;
    private String g;
    private boolean h = false;
    private Stack<NodeName> i = new Stack();
    private static HTMLTagHashSet j = new HTMLTagHashSet(31);
    private static HTMLTagHashSet k = new HTMLTagHashSet(43);
    private static HTMLTagHashSet l = new HTMLTagHashSet(57);

    protected static void setEmptyTag(String string) {
        j.add(string);
    }

    protected static boolean isEmptyTag(String string) {
        return j.contains(string);
    }

    private static void a(String string, String string2) {
        k.add(string2);
        l.add(string + '+' + string2);
    }

    @Override
    public void setEscapeNonAscii(Boolean bl2) {
        this.h = bl2;
    }

    protected abstract boolean isHTMLElement(NodeName var1);

    @Override
    public void open() {
    }

    @Override
    protected void openDocument() {
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        String string = this.outputProperties.getProperty("byte-order-mark");
        if ("yes".equals(string) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException iOException) {}
        }
        if ("yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}single-quotes"))) {
            this.delimiter = (char)39;
            this.attSpecials = b;
        }
        this.e = -1000000;
    }

    @Override
    protected void writeDocType(NodeName nodeName, String string, String string2, String string3) {
        super.writeDocType(nodeName, string, string2, string3);
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        super.startElement(nodeName, schemaType, location, n2);
        this.g = nodeName.getURI();
        this.f = this.elementStack.peek();
        if (nodeName.hasURI("") && (this.f.equalsIgnoreCase("script") || this.f.equalsIgnoreCase("style"))) {
            this.e = 0;
        }
        ++this.e;
        this.i.push(nodeName);
    }

    @Override
    public void startContent() {
        this.closeStartTag();
    }

    @Override
    protected void writeAttribute(NodeName nodeName, String string, CharSequence charSequence, int n2) {
        try {
            if (this.g.isEmpty()) {
                String string2 = charSequence.toString();
                String string3 = string;
                String string4 = this.f;
                if (string3.equalsIgnoreCase(string2) && k.contains(string3) && (l.contains(string4 + '+' + string3) || l.contains("*+" + string3))) {
                    this.writer.write(string);
                    return;
                }
            }
            super.writeAttribute(nodeName, string, charSequence, n2);
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void writeEscape(CharSequence var1_1, boolean var2_2) {
        var3_3 = 0;
        v0 = var4_5 = var2_2 != false ? this.attSpecials : HTMLEmitter.a;
        if (var1_1 instanceof CompressedWhitespace) {
            ((CompressedWhitespace)var1_1).writeEscape(var4_5, this.writer);
            return;
        }
        var5_6 = false;
        while (var3_3 < var1_1.length()) {
            block47: {
                block46: {
                    if (this.h) {
                        for (var6_7 = var3_3; var6_7 < var1_1.length() && (var7_8 = var1_1.charAt(var6_7)) < '\u007f' && !var4_5[var7_8]; ++var6_7) {
                        }
                    } else {
                        while (var6_7 < var1_1.length() && ((var7_8 = var1_1.charAt(var6_7)) < '\u007f' ? var4_5[var7_8] == false : this.characterSet.inCharset(var7_8) != false && var7_8 > '\u00a0')) {
                            ++var6_7;
                        }
                    }
                    if (var6_7 == var1_1.length()) {
                        if (var3_3 == 0) {
                            this.writeCharSequence(var1_1);
                            return;
                        }
                        this.writeCharSequence(var1_1.subSequence(var3_3, var6_7));
                        return;
                    }
                    if (var6_7 > var3_3) {
                        this.writeCharSequence(var1_1.subSequence(var3_3, var6_7));
                    }
                    if ((var7_8 = var1_1.charAt(var6_7)) != '\u0000') break block46;
                    var5_6 = var5_6 == false;
                    break block47;
                }
                if (var5_6) ** GOTO lbl-1000
                if (var7_8 <= '\u007f') {
                    if (var2_2) {
                        if (var7_8 == '<') {
                            this.writer.write(60);
                        } else if (var7_8 == '>') {
                            this.writer.write("&gt;");
                        } else if (var7_8 == '&') {
                            if (var6_7 + 1 < var1_1.length() && var1_1.charAt(var6_7 + 1) == '{') {
                                this.writer.write(38);
                            } else {
                                this.writer.write("&amp;");
                            }
                        } else if (var7_8 == '\"') {
                            this.writer.write("&#34;");
                        } else if (var7_8 == '\'') {
                            this.writer.write("&#39;");
                        } else if (var7_8 == '\n') {
                            this.writer.write("&#xA;");
                        } else if (var7_8 == '\t') {
                            this.writer.write("&#x9;");
                        } else if (var7_8 == '\r') {
                            this.writer.write("&#xD;");
                        }
                    } else if (var7_8 == '<') {
                        this.writer.write("&lt;");
                    } else if (var7_8 == '>') {
                        this.writer.write("&gt;");
                    } else if (var7_8 == '&') {
                        this.writer.write("&amp;");
                    } else if (var7_8 == '\r') {
                        this.writer.write("&#xD;");
                    }
                } else if (var7_8 < '\u00a0') {
                    if (this.rejectControlCharacters()) {
                        var3_4 = new XPathException("Illegal HTML character: decimal " + var7_8);
                        var3_4.setErrorCode("SERE0014");
                        throw var3_4;
                    }
                    this.characterReferenceGenerator.outputCharacterReference(var7_8, this.writer);
                } else if (var7_8 == '\u00a0') {
                    this.writer.write("&nbsp;");
                } else if (var7_8 >= '\ud800' && var7_8 <= '\udbff') {
                    var3_3 = (var7_8 - 55296 << 10) + (var1_1.charAt(var6_7 + 1) - 56320) + 65536;
                    this.characterReferenceGenerator.outputCharacterReference(var3_3, this.writer);
                    ++var6_7;
                } else if (this.h || !this.characterSet.inCharset(var7_8)) {
                    this.characterReferenceGenerator.outputCharacterReference(var7_8, this.writer);
                } else lbl-1000:
                // 2 sources

                {
                    this.writer.write(var7_8);
                }
            }
            var3_3 = ++var6_7;
        }
    }

    @Override
    public void endElement() {
        NodeName nodeName = this.i.pop();
        String string = this.elementStack.peek();
        --this.e;
        if (this.e == 0) {
            this.e = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(string) && this.isHTMLElement(nodeName)) {
            this.elementStack.pop();
            return;
        }
        super.endElement();
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        int n3 = n2;
        if (this.e > 0) {
            n3 = n2 | 1;
        }
        super.characters(charSequence, location, n3);
    }

    @Override
    public void processingInstruction(String object, CharSequence charSequence, Location location, int n2) {
        if (!this.started) {
            this.openDocument();
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) != '>') continue;
            object = new XPathException("A processing instruction in HTML must not contain a > character");
            ((XPathException)object).setErrorCode("SERE0015");
            throw object;
        }
        try {
            this.writer.write("<?");
            this.writer.write((String)object);
            this.writer.write(32);
            this.writeCharSequence(charSequence);
            this.writer.write(62);
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    protected abstract boolean rejectControlCharacters();

    static {
        HTMLEmitter.a("*", "hidden");
        HTMLEmitter.a("area", "nohref");
        HTMLEmitter.a("audio", "autoplay");
        HTMLEmitter.a("audio", "controls");
        HTMLEmitter.a("audio", "loop");
        HTMLEmitter.a("audio", "muted");
        HTMLEmitter.a("button", "disabled");
        HTMLEmitter.a("button", "autofocus");
        HTMLEmitter.a("button", "formnovalidate");
        HTMLEmitter.a("details", "open");
        HTMLEmitter.a("dialog", "open");
        HTMLEmitter.a("dir", "compact");
        HTMLEmitter.a("dl", "compact");
        HTMLEmitter.a("fieldset", "disabled");
        HTMLEmitter.a("form", "novalidate");
        HTMLEmitter.a("frame", "noresize");
        HTMLEmitter.a("hr", "noshade");
        HTMLEmitter.a("img", "ismap");
        HTMLEmitter.a("input", "checked");
        HTMLEmitter.a("input", "disabled");
        HTMLEmitter.a("input", "multiple");
        HTMLEmitter.a("input", "readonly");
        HTMLEmitter.a("input", "required");
        HTMLEmitter.a("input", "autofocus");
        HTMLEmitter.a("input", "formnovalidate");
        HTMLEmitter.a("iframe", "seamless");
        HTMLEmitter.a("keygen", "autofocus");
        HTMLEmitter.a("keygen", "disabled");
        HTMLEmitter.a("menu", "compact");
        HTMLEmitter.a("object", "declare");
        HTMLEmitter.a("object", "typemustmatch");
        HTMLEmitter.a("ol", "compact");
        HTMLEmitter.a("ol", "reversed");
        HTMLEmitter.a("optgroup", "disabled");
        HTMLEmitter.a("option", "selected");
        HTMLEmitter.a("option", "disabled");
        HTMLEmitter.a("script", "defer");
        HTMLEmitter.a("script", "async");
        HTMLEmitter.a("select", "multiple");
        HTMLEmitter.a("select", "disabled");
        HTMLEmitter.a("select", "autofocus");
        HTMLEmitter.a("select", "required");
        HTMLEmitter.a("style", "scoped");
        HTMLEmitter.a("td", "nowrap");
        HTMLEmitter.a("textarea", "disabled");
        HTMLEmitter.a("textarea", "readonly");
        HTMLEmitter.a("textarea", "autofocus");
        HTMLEmitter.a("textarea", "required");
        HTMLEmitter.a("th", "nowrap");
        HTMLEmitter.a("track", "default");
        HTMLEmitter.a("ul", "compact");
        HTMLEmitter.a("video", "autoplay");
        HTMLEmitter.a("video", "controls");
        HTMLEmitter.a("video", "loop");
        HTMLEmitter.a("video", "muted");
    }
}

