/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.type.SchemaType;

public class HTMLIndenter
extends ProxyReceiver {
    private static final String[] a = new String[]{"pre", "script", "style", "textarea", "title", "xmp"};
    private static final String[] b = new String[]{"a", "abbr", "acronym", "applet", "area", "audio", "b", "basefont", "bdi", "bdo", "big", "br", "button", "canvas", "cite", "code", "data", "datalist", "del", "dfn", "em", "embed", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "mark", "math", "meter", "noscript", "object", "output", "picture", "progress", "q", "ruby", "s", "samp", "script", "select", "small", "span", "strike", "strong", "sub", "sup", "svg", "template", "textarea", "time", "tt", "u", "var", "video", "wbr"};
    private static final Set<String> c = new HashSet<String>(70);
    private static final Set<String> d = new HashSet<String>(10);
    protected char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private int e = 0;
    private boolean f = false;
    private boolean g = false;
    private boolean h = false;
    private boolean i = false;
    private int[] j = new int[20];
    private Set<String> k = null;

    public HTMLIndenter(Receiver receiver, String string) {
        super(receiver);
    }

    public void setOutputProperties(Properties object) {
        if ((object = ((Properties)object).getProperty("suppress-indentation")) != null) {
            this.k = new HashSet<String>(8);
            object = new StringTokenizer((String)object, " \t\r\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string = ((StringTokenizer)object).nextToken();
                this.k.add(FingerprintedQName.fromClarkName(string).getLocalPart().toLowerCase());
            }
        }
    }

    public int classifyTag(NodeName nodeName) {
        int n2 = 0;
        if (c.contains(nodeName.getLocalPart().toLowerCase())) {
            n2 = 1;
        }
        if (d.contains(nodeName.getLocalPart().toLowerCase())) {
            n2 |= 2;
        }
        if (this.k != null && this.k.contains(nodeName.getLocalPart().toLowerCase())) {
            n2 |= 4;
        }
        return n2;
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        int n3 = this.e == 0 ? 0 : this.j[this.e - 1] & 4;
        int n4 = this.classifyTag(nodeName) | n3;
        if (this.e >= this.j.length) {
            this.j = Arrays.copyOf(this.j, this.e << 1);
        }
        this.j[this.e] = n4;
        boolean bl2 = (n4 & 1) != 0;
        if (!(bl2 || this.g || this.h || n3 != 0 || this.e == 0)) {
            this.a();
        }
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
        this.g = this.g || (n4 & 2) != 0;
        ++this.e;
        this.f = true;
        this.h = false;
        this.i = false;
    }

    @Override
    public void endElement() {
        boolean bl2;
        --this.e;
        boolean bl3 = (this.j[this.e] & 1) != 0;
        boolean bl4 = (this.j[this.e] & 2) != 0;
        boolean bl5 = bl2 = (this.j[this.e] & 4) != 0;
        if (!(!this.i || bl3 || bl2 || this.h || this.f || this.g)) {
            this.a();
            this.h = false;
        } else {
            this.h = bl3;
        }
        this.nextReceiver.endElement();
        this.g = this.g && !bl4;
        this.f = false;
        this.i = true;
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if (this.g || (n2 & 0x100) != 0 || (n2 & 1) != 0) {
            this.nextReceiver.characters(charSequence, location, n2);
        } else {
            int n3 = 0;
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                if (charSequence.charAt(i2) != '\n' && (i2 - n3 <= this.getLineLength() || charSequence.charAt(i2) != ' ')) continue;
                this.f = false;
                this.nextReceiver.characters(charSequence.subSequence(n3, i2), location, n2);
                this.a();
                for (n3 = i2 + 1; n3 < charSequence.length() && charSequence.charAt(n3) == ' '; ++n3) {
                }
            }
            if (n3 < charSequence.length()) {
                this.nextReceiver.characters(charSequence.subSequence(n3, charSequence.length()), location, n2);
            }
        }
        this.h = false;
        this.i = false;
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        if (this.i && this.e != 0 && (this.j[this.e - 1] & 1) == 0) {
            this.a();
        }
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
        this.i = false;
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        if (this.i && this.e != 0 && (this.j[this.e - 1] & 1) == 0) {
            this.a();
        }
        this.nextReceiver.comment(charSequence, location, n2);
        this.i = false;
    }

    protected int getLineLength() {
        return 80;
    }

    private void a() {
        int n2 = this.e * this.getIndentation();
        if (n2 + 1 >= this.indentChars.length) {
            int n3 = 5 * this.getIndentation();
            if (n2 + 1 > this.indentChars.length + n3) {
                n3 += n2 + 1;
            }
            char[] cArray = new char[this.indentChars.length + n3];
            System.arraycopy(this.indentChars, 0, cArray, 0, this.indentChars.length);
            Arrays.fill(cArray, this.indentChars.length, cArray.length, ' ');
            this.indentChars = cArray;
        }
        this.nextReceiver.characters(new CharSlice(this.indentChars, 0, n2 + 1), ExplicitLocation.UNKNOWN_LOCATION, 0);
        this.f = false;
    }

    protected int getIndentation() {
        return 3;
    }

    static {
        Collections.addAll(c, b);
        Collections.addAll(d, a);
    }
}

