/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class HTMLURIEscaper
extends ProxyReceiver {
    private static HTMLTagHashSet a = new HTMLTagHashSet(47);
    private static HTMLTagHashSet b = new HTMLTagHashSet(101);
    protected NodeName currentElement;
    protected boolean escapeURIAttributes = true;
    protected NamePool pool;

    private static void a(String string, String string2) {
        a.add(string2);
        b.add(string + '+' + string2);
    }

    public boolean isUrlAttribute(NodeName object, NodeName object2) {
        if (this.pool == null) {
            this.pool = ((SequenceReceiver)this).getNamePool();
        }
        if (!a.contains((String)(object2 = object2.getDisplayName()))) {
            return false;
        }
        object = object.getDisplayName();
        return b.contains((String)object + '+' + (String)object2);
    }

    public HTMLURIEscaper(Receiver receiver) {
        super(receiver);
    }

    @Override
    public void startDocument(int n2) {
        this.nextReceiver.startDocument(n2);
        this.pool = this.getPipelineConfiguration().getConfiguration().getNamePool();
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        this.currentElement = nodeName;
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (this.escapeURIAttributes) {
            HTMLURIEscaper hTMLURIEscaper = this;
            if (hTMLURIEscaper.isUrlAttribute(hTMLURIEscaper.currentElement, nodeName) && (n2 & 1) == 0) {
                this.nextReceiver.attribute(nodeName, simpleType, HTMLURIEscaper.escapeURL(charSequence, true, this.getConfiguration()), location, n2 | 2);
                return;
            }
        }
        this.nextReceiver.attribute(nodeName, simpleType, charSequence, location, n2);
    }

    public static CharSequence escapeURL(CharSequence charSequence, boolean bl2, Configuration configuration) {
        for (int i2 = charSequence.length() - 1; i2 >= 0; --i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= ' ' && c2 <= '~') continue;
            if (bl2) {
                charSequence = Normalizer.make(2, configuration).normalize(charSequence);
                return HTMLURIEscaper.a(charSequence);
            }
            return HTMLURIEscaper.a(charSequence);
        }
        return charSequence;
    }

    private static FastStringBuffer a(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length() + 20);
        byte[] byArray = new byte[4];
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n2 = charSequence.charAt(i2);
            if (n2 < 32 || n2 > 126) {
                n2 = UTF8CharacterSet.getUTF8Encoding((char)n2, i2 + 1 < charSequence.length() ? charSequence.charAt(i2 + 1) : (char)' ', byArray);
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n3 = byArray[i3] & 0xFF;
                    fastStringBuffer.append('%');
                    fastStringBuffer.append("0123456789ABCDEF".charAt(n3 / 16));
                    fastStringBuffer.append("0123456789ABCDEF".charAt(n3 % 16));
                }
                continue;
            }
            fastStringBuffer.append((char)n2);
        }
        return fastStringBuffer;
    }

    static {
        HTMLURIEscaper.a("form", "action");
        HTMLURIEscaper.a("object", "archive");
        HTMLURIEscaper.a("body", "background");
        HTMLURIEscaper.a("q", "cite");
        HTMLURIEscaper.a("blockquote", "cite");
        HTMLURIEscaper.a("del", "cite");
        HTMLURIEscaper.a("ins", "cite");
        HTMLURIEscaper.a("object", "classid");
        HTMLURIEscaper.a("object", "codebase");
        HTMLURIEscaper.a("applet", "codebase");
        HTMLURIEscaper.a("object", "data");
        HTMLURIEscaper.a("button", "datasrc");
        HTMLURIEscaper.a("div", "datasrc");
        HTMLURIEscaper.a("input", "datasrc");
        HTMLURIEscaper.a("object", "datasrc");
        HTMLURIEscaper.a("select", "datasrc");
        HTMLURIEscaper.a("span", "datasrc");
        HTMLURIEscaper.a("table", "datasrc");
        HTMLURIEscaper.a("textarea", "datasrc");
        HTMLURIEscaper.a("script", "for");
        HTMLURIEscaper.a("a", "href");
        HTMLURIEscaper.a("a", "name");
        HTMLURIEscaper.a("area", "href");
        HTMLURIEscaper.a("link", "href");
        HTMLURIEscaper.a("base", "href");
        HTMLURIEscaper.a("img", "longdesc");
        HTMLURIEscaper.a("frame", "longdesc");
        HTMLURIEscaper.a("iframe", "longdesc");
        HTMLURIEscaper.a("head", "profile");
        HTMLURIEscaper.a("script", "src");
        HTMLURIEscaper.a("input", "src");
        HTMLURIEscaper.a("frame", "src");
        HTMLURIEscaper.a("iframe", "src");
        HTMLURIEscaper.a("img", "src");
        HTMLURIEscaper.a("img", "usemap");
        HTMLURIEscaper.a("input", "usemap");
        HTMLURIEscaper.a("object", "usemap");
    }
}

