/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.ma.json.JsonReceiver;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.ExpandedStreamResult;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;

public class JSONEmitter {
    private ExpandedStreamResult a;
    private Writer b;
    private Normalizer c;
    private CharacterMap d;
    private Properties e;
    private CharacterSet f;
    private boolean g;
    private int h = 2;
    private int i;
    private boolean j = true;
    private boolean k = false;
    private int l;
    private Stack<Boolean> m = new Stack();
    private boolean n = false;

    public JSONEmitter(PipelineConfiguration pipelineConfiguration, StreamResult streamResult, Properties properties) {
        this.setOutputProperties(properties);
        this.a = new ExpandedStreamResult(pipelineConfiguration.getConfiguration(), streamResult, properties);
    }

    public void setOutputProperties(Properties object) {
        String string;
        this.e = object;
        if ("yes".equals(((Properties)object).getProperty("indent"))) {
            this.g = true;
        }
        if ("yes".equals(((Properties)object).getProperty("{http://saxon.sf.net/}unfailing"))) {
            this.n = true;
        }
        if ((string = ((Properties)object).getProperty("{http://saxon.sf.net/}line-length")) != null) {
            try {
                this.i = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((object = ((Properties)object).getProperty("{http://saxon.sf.net/}indent-spaces")) != null) {
            try {
                this.h = Integer.parseInt((String)object);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Properties getOutputProperties() {
        return this.e;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.c = normalizer;
    }

    public void setCharacterMap(CharacterMap characterMap) {
        this.d = characterMap;
    }

    public void writeKey(String string) {
        this.a();
        this.a('\"');
        JSONEmitter jSONEmitter = this;
        jSONEmitter.c(jSONEmitter.a(string));
        this.c("\":");
        if (this.g) {
            this.c(" ");
        }
        this.k = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeAtomicValue(AtomicValue atomicValue) {
        this.a();
        if (atomicValue == null) {
            this.c("null");
            return;
        }
        if (atomicValue instanceof NumericValue) {
            NumericValue numericValue = (NumericValue)atomicValue;
            if (numericValue.isNaN()) {
                if (!this.n) throw new XPathException("JSON has no way of representing NaN", "SERE0020");
                this.c("NaN");
                return;
            }
            if (Double.isInfinite(numericValue.getDoubleValue())) {
                if (!this.n) throw new XPathException("JSON has no way of representing Infinity", "SERE0020");
                this.c(numericValue.getDoubleValue() < 0.0 ? "-INF" : "INF");
                return;
            }
            if (atomicValue instanceof IntegerValue) {
                this.c("" + numericValue.longValue());
                return;
            }
            if (numericValue.isWholeNumber() && !numericValue.isNegativeZero() && numericValue.abs().compareTo(1000000000000000000L) < 0) {
                this.c("" + numericValue.longValue());
                return;
            }
            this.c(numericValue.getStringValue());
            return;
        }
        if (atomicValue instanceof BooleanValue) {
            this.c(atomicValue.getStringValue());
            return;
        }
        this.a('\"');
        JSONEmitter jSONEmitter = this;
        jSONEmitter.c(jSONEmitter.a(atomicValue.getStringValue()));
        this.a('\"');
    }

    public void startArray(boolean bl2) {
        this.a('[', bl2);
        ++this.l;
    }

    public void endArray() {
        this.a(']', this.l--);
    }

    public void startMap(boolean bl2) {
        this.a('{', bl2);
        ++this.l;
    }

    public void endMap() {
        this.a('}', this.l--);
    }

    private void a(char c2, boolean bl2) {
        this.a();
        this.m.push(bl2);
        this.a(c2);
        this.j = true;
        if (this.g && bl2) {
            this.a(' ');
        }
    }

    private void a(char c2, int n2) {
        boolean bl2 = this.m.pop();
        if (this.g) {
            if (bl2) {
                this.a(' ');
            } else {
                this.a(n2);
            }
        }
        this.a(c2);
        this.j = false;
    }

    private void a() {
        int n2 = this.j;
        if (this.j) {
            this.j = false;
        } else if (!this.k) {
            this.a(',');
        }
        if (n2 != 0 && this.k) {
            this.a(' ');
        } else if (this.g && !this.k && this.l != 0) {
            this.a('\n');
            for (n2 = 0; n2 < this.h * (this.l + 1); ++n2) {
                this.a(' ');
            }
        }
        this.k = false;
    }

    private void a(int n2) {
        this.a('\n');
        for (int i2 = 0; i2 < this.h * n2; ++i2) {
            this.a(' ');
        }
    }

    private CharSequence a(CharSequence charSequence) {
        if (this.d != null) {
            int n2;
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            charSequence = this.d.map(charSequence, true);
            charSequence = charSequence.toString();
            int n3 = 0;
            while ((n2 = ((String)charSequence).indexOf(0, n3)) >= 0) {
                fastStringBuffer.append(this.b(((String)charSequence).substring(n3, n2)));
                n3 = ((String)charSequence).indexOf(0, n2 + 1);
                fastStringBuffer.append(((String)charSequence).substring(n2 + 1, n3));
                ++n3;
            }
            fastStringBuffer.append(this.b(((String)charSequence).substring(n3)));
            return fastStringBuffer;
        }
        return this.b(charSequence);
    }

    private CharSequence b(CharSequence charSequence) {
        if (this.c != null) {
            charSequence = this.c.normalize(charSequence);
        }
        return JsonReceiver.escape(charSequence, false, n2 -> n2 < 31 || n2 >= 127 && n2 <= 159 || !this.f.inCharset(n2));
    }

    private void c(CharSequence charSequence) {
        if (this.b == null) {
            this.b = this.a.obtainWriter();
            this.f = this.a.getCharacterSet();
        }
        try {
            this.b.append(charSequence);
            return;
        }
        catch (IOException iOException) {
            throw new XPathException(iOException);
        }
    }

    private void a(char c2) {
        this.c("" + c2);
    }

    public void close() {
        if (this.j) {
            this.c("null");
        }
        if (this.b != null) {
            try {
                this.b.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }
}

