/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ReceiverWithOutputProperties;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class JSONSerializer
extends SequenceWriter
implements ReceiverWithOutputProperties {
    private boolean a = false;
    private String b = "xml";
    private int c = 0;
    private int d = 0;
    private int e = 80;
    private JSONEmitter f;
    private Properties g;
    private boolean h;
    private Comparator<AtomicValue> i;
    private boolean j = false;

    public JSONSerializer(PipelineConfiguration pipelineConfiguration, JSONEmitter jSONEmitter, Properties properties) {
        super(pipelineConfiguration);
        this.setOutputProperties(properties);
        this.f = jSONEmitter;
    }

    public void setOutputProperties(Properties object) {
        String string;
        this.g = object;
        if ("yes".equals(((Properties)object).getProperty("allow-duplicate-names"))) {
            this.a = true;
        }
        if ("yes".equals(((Properties)object).getProperty("indent"))) {
            this.h = true;
        }
        if ("yes".equals(((Properties)object).getProperty("{http://saxon.sf.net/}unfailing"))) {
            this.j = true;
            this.a = true;
        }
        if ((string = ((Properties)object).getProperty("json-node-output-method")) != null) {
            this.b = string;
        }
        if ((object = ((Properties)object).getProperty("{http://saxon.sf.net/}line-length")) != null) {
            try {
                this.e = Integer.parseInt((String)object);
                return;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void setPropertySorter(Comparator<AtomicValue> comparator) {
        this.i = comparator;
    }

    @Override
    public Properties getOutputProperties() {
        return this.g;
    }

    public void setNormalizer(Normalizer normalizer) {
        this.f.setNormalizer(normalizer);
    }

    public void setCharacterMap(CharacterMap characterMap) {
        this.f.setCharacterMap(characterMap);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void write(Item var1_1) {
        block25: {
            block24: {
                if (this.c == 0 && ++this.d >= 2) {
                    throw new XPathException("JSON output method cannot handle sequences of two or more items", "SERE0023");
                }
                if (var1_1 instanceof AtomicValue) {
                    this.f.writeAtomicValue((AtomicValue)var1_1);
                    return;
                }
                if (!(var1_1 instanceof MapItem)) break block24;
                var2_2 = null;
                if (!this.a) {
                    var2_2 = new HashSet<GroundedValue<?>>();
                }
                if (!this.h) ** GOTO lbl-1000
                var4_6 = (MapItem)var1_1;
                var3_9 = this;
                var5_14 = 0;
                if (var4_6.size() >= 2) {
                    for (Iterator<E> var4_6 : var4_6.keyValuePairs()) {
                        if (!(var4_6.value instanceof AtomicValue)) {
                            v0 = false;
                        } else {
                            if ((var5_14 += var4_6.key.getStringValueCS().length() + ((AtomicValue)var4_6.value).getStringValueCS().length() + 4) <= var3_9.e) continue;
                            v0 = false;
                        }
                        break;
                    }
                } else {
                    v0 = true;
                }
                if (v0) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                var3_10 = v1;
                this.f.startMap(var3_10);
                var3_11 = new ArrayList<AtomicValue>();
                for (KeyValuePair var5_15 : ((MapItem)var1_1).keyValuePairs()) {
                    var3_11.add(var5_15.key);
                }
                if (this.i != null) {
                    var3_11.sort(this.i);
                }
                for (AtomicValue var5_16 : var3_11) {
                    var3_11 = var5_16.getStringValue();
                    this.f.writeKey((String)var3_11);
                    if (!this.a && !var2_2.add(var3_11)) {
                        throw new XPathException("Key value \"" + var3_11 + "\" occurs more than once in JSON map", "SERE0022");
                    }
                    var3_11 = ((MapItem)var1_1).get(var5_16);
                    this.a(var3_11.materialize());
                }
                this.f.endMap();
                return;
            }
            if (!(var1_1 instanceof ArrayItem)) break block25;
            if (!this.h) ** GOTO lbl-1000
            var4_7 /* !! */  = (ArrayItem)var1_1;
            var3_12 = this;
            var5_17 = 0;
            if (var4_7 /* !! */ .arrayLength() >= 2) {
                for (ArrayItem var4_7 : var4_7 /* !! */ .members()) {
                    if (!(var4_7 /* !! */  instanceof AtomicValue)) {
                        v2 = false;
                    } else {
                        if ((var5_17 += ((AtomicValue)var4_7 /* !! */ ).getStringValueCS().length() + 1) <= var3_12.e) continue;
                        v2 = false;
                    }
                    break;
                }
            } else {
                v2 = true;
            }
            if (v2) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            var2_3 = v3;
            this.f.startArray(var2_3);
            for (Object var3_12 : ((ArrayItem)var1_1).members()) {
                this.a(var3_12.materialize());
            }
            this.f.endArray();
            return;
        }
        if (var1_1 instanceof NodeInfo) {
            var4_8 = (NodeInfo)var1_1;
            var3_13 = this;
            var5_18 = new StringWriter();
            var6_21 = new Properties();
            var6_21.setProperty("method", var3_13.b);
            var6_21.setProperty("indent", "no");
            var6_21.setProperty("omit-xml-declaration", "yes");
            QueryResult.serialize(var4_8, (Result)new StreamResult(var5_18), var6_21);
            var2_4 = var5_18.toString().trim();
            this.f.writeAtomicValue(new StringValue(var2_4));
            return;
        }
        if (this.j) {
            var2_5 = var1_1.getStringValue();
            this.f.writeAtomicValue(new StringValue(var2_5));
            return;
        }
        throw new XPathException("JSON output method cannot handle an item of type " + var1_1.getClass(), "SERE0021");
    }

    private void a(GroundedValue<?> groundedValue) {
        int n2 = groundedValue.getLength();
        if (n2 == 0) {
            this.f.writeAtomicValue(null);
            return;
        }
        if (n2 == 1) {
            ++this.c;
            ((SequenceWriter)this).write((Item)groundedValue.head());
            --this.c;
            return;
        }
        throw new XPathException("JSON serialization: cannot handle a sequence of length " + n2 + Err.depictSequence(groundedValue), "SERE0023");
    }

    @Override
    public void close() {
        if (this.d == 0) {
            this.f.writeAtomicValue(null);
        }
        this.f.close();
        super.close();
    }
}

