/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.serialize.CharacterMap;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.z.IntHashMap;

public class SerializationParamsHandler {
    public static final String NAMESPACE = "http://www.w3.org/2010/xslt-xquery-serialization";
    private Properties a;
    private CharacterMap b;
    private Location c;

    public SerializationParamsHandler() {
    }

    public SerializationParamsHandler(Properties properties) {
        this.a = properties;
    }

    public void setLocator(Location location) {
        this.c = location;
    }

    public void setSerializationParams(NodeInfo nodeInfo) {
        Object object;
        if (this.a == null) {
            this.a = new Properties();
        }
        if (nodeInfo.getNodeKind() == 9) {
            nodeInfo = Navigator.getOutermostElement(nodeInfo.getTreeInfo());
        }
        if (nodeInfo.getNodeKind() != 1) {
            throw new XPathException("Serialization params: node must be a document or element node");
        }
        if (!nodeInfo.getLocalPart().equals("serialization-parameters")) {
            throw new XPathException("Serialization params: element name must be 'serialization-parameters");
        }
        if (!nodeInfo.getURI().equals(NAMESPACE)) {
            throw new XPathException("Serialization params: element namespace must be http://www.w3.org/2010/xslt-xquery-serialization");
        }
        SerializationParamsHandler.a(nodeInfo, new String[0]);
        HashSet<NodeName> hashSet = new HashSet<NodeName>();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)3, NodeKindTest.ELEMENT);
        while ((object = axisIterator.next()) != null) {
            Object object2;
            if (!hashSet.add(NameOfNode.makeName((NodeInfo)object))) {
                throw new XPathException("Duplicated serialization parameter " + object.getDisplayName(), "SEPM0019");
            }
            Object object3 = object.getLocalPart();
            CharSequence charSequence = object.getURI();
            if (((String)charSequence).isEmpty()) {
                throw new XPathException("Serialization parameter " + (String)object3 + " is in no namespace", "SEPM0017");
            }
            if (NAMESPACE.equals(charSequence)) {
                charSequence = "";
            }
            if ("".equals(charSequence) && ((String)object3).equals("use-character-maps")) {
                SerializationParamsHandler.a((NodeInfo)object, new String[0]);
                object2 = object.iterateAxis((byte)3, NodeKindTest.ELEMENT);
                object = new IntHashMap();
                while ((object3 = object2.next()) != null) {
                    SerializationParamsHandler.a((NodeInfo)object3, "character", "map-string");
                    if (!(object3.getURI().equals(NAMESPACE) && object3.getLocalPart().equals("character-map") || !object3.getURI().equals(NAMESPACE) && !object3.getURI().isEmpty())) {
                        throw new XPathException("Invalid child of use-character-maps: " + object3.getDisplayName(), "SEPM0017");
                    }
                    charSequence = SerializationParamsHandler.a((NodeInfo)object3, "character");
                    object3 = SerializationParamsHandler.a((NodeInfo)object3, "map-string");
                    if (((UnicodeString)(charSequence = UnicodeString.makeUnicodeString(charSequence))).uLength() != 1) {
                        throw new XPathException("In the serialization parameters, the value of @character in the character map must be a single Unicode character", "SEPM0017");
                    }
                    int n2 = ((UnicodeString)charSequence).uCharAt(0);
                    object3 = (String)((IntHashMap)object).put(n2, object3);
                    if (object3 == null) continue;
                    throw new XPathException("In the serialization parameters, the character map contains two entries for the character \\u" + Integer.toHexString(n2 + 65536).substring(1), "SEPM0018");
                }
                this.b = new CharacterMap(NameOfNode.makeName(nodeInfo).getStructuredQName(), (IntHashMap<String>)object);
                continue;
            }
            SerializationParamsHandler.a((NodeInfo)object, new String[]{"value"});
            object2 = SerializationParamsHandler.a((NodeInfo)object, "value");
            try {
                ResultDocument.setSerializationProperty(this.a, (String)charSequence, (String)object3, (String)object2, new InscopeNamespaceResolver((NodeInfo)object), false, nodeInfo.getConfiguration());
            }
            catch (XPathException xPathException) {
                if ("XQST0109".equals(xPathException.getErrorCodeLocalPart()) || "SEPM0016".equals(xPathException.getErrorCodeLocalPart())) {
                    if (!"".equals(charSequence)) continue;
                    object = new XPathException("Unknown serialization parameter " + Err.depict((Item)object), "SEPM0017");
                    ((TransformerException)object).setLocator(this.c);
                    throw object;
                }
                throw xPathException;
            }
        }
    }

    private static void a(NodeInfo nodeInfo, String ... stringArray) {
        nodeInfo.iterateAxis((byte)2).forEachOrFail(nodeInfo2 -> {
            if ("".equals(nodeInfo2.getURI()) && Arrays.binarySearch(stringArray, nodeInfo2.getLocalPart()) < 0) {
                throw new XPathException("In serialization parameters, attribute @" + nodeInfo2.getLocalPart() + " must not appear on element " + nodeInfo.getDisplayName(), "SEPM0017");
            }
        });
    }

    private static String a(NodeInfo nodeInfo, String string) {
        String string2 = nodeInfo.getAttributeValue("", string);
        if (string2 == null) {
            throw new XPathException("In serialization parameters, attribute @" + string + " is missing on element " + nodeInfo.getDisplayName());
        }
        return string2;
    }

    public SerializationProperties getSerializationProperties() {
        CharacterMapIndex characterMapIndex = new CharacterMapIndex();
        if (this.b != null) {
            characterMapIndex.putCharacterMap(new StructuredQName("", "", "charMap"), this.b);
            this.a.put("use-character-maps", "charMap");
        }
        return new SerializationProperties(this.a, characterMapIndex);
    }

    public CharacterMap getCharacterMap() {
        return this.b;
    }
}

