/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.codenorm.Normalizer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class UnicodeNormalizer
extends ProxyReceiver {
    private Normalizer a;

    public UnicodeNormalizer(String object, Receiver object2) {
        super((Receiver)object2);
        int n2;
        switch (object) {
            case "NFC": {
                n2 = 2;
                break;
            }
            case "NFD": {
                n2 = 0;
                break;
            }
            case "NFKC": {
                n2 = 3;
                break;
            }
            case "NFKD": {
                n2 = 1;
                break;
            }
            default: {
                object = new XPathException("Unknown normalization form " + (String)object);
                ((XPathException)object).setErrorCode("SESU0011");
                throw object;
            }
        }
        this.a = Normalizer.make(n2, this.getConfiguration());
    }

    public Normalizer getNormalizer() {
        return this.a;
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        this.nextReceiver.attribute(nodeName, simpleType, this.normalize(charSequence, (n2 & 0x100) != 0), location, n2);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if (Whitespace.isWhite(charSequence)) {
            this.nextReceiver.characters(charSequence, location, n2);
            return;
        }
        this.nextReceiver.characters(this.normalize(charSequence, (n2 & 0x100) != 0), location, n2);
    }

    public CharSequence normalize(CharSequence charSequence, boolean bl2) {
        if (bl2) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
            charSequence = charSequence.toString();
            int n2 = 0;
            int n3 = ((String)charSequence).indexOf(0);
            while (n3 >= 0) {
                fastStringBuffer.append(this.a.normalize(((String)charSequence).substring(n2, n3)));
                fastStringBuffer.append('\u0000');
                n2 = n3 + 1;
                n3 = ((String)charSequence).indexOf(0, n2);
                fastStringBuffer.append(((String)charSequence).substring(n2, n3));
                fastStringBuffer.append('\u0000');
                n2 = n3 + 1;
                n3 = ((String)charSequence).indexOf(0, n2);
            }
            fastStringBuffer.append(this.a.normalize(((String)charSequence).substring(n2)));
            return fastStringBuffer.condense();
        }
        return this.a.normalize(charSequence);
    }
}

