/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XML10ContentChecker
extends ProxyReceiver {
    public XML10ContentChecker(Receiver receiver) {
        super(receiver);
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        XML10ContentChecker.a(charSequence, location);
        this.nextReceiver.attribute(nodeName, simpleType, charSequence, location, n2);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        XML10ContentChecker.a(charSequence, location);
        this.nextReceiver.characters(charSequence, location, n2);
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        XML10ContentChecker.a(charSequence, location);
        this.nextReceiver.comment(charSequence, location, n2);
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        XML10ContentChecker.a(charSequence, location);
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
    }

    private static void a(CharSequence charSequence, Location location) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = charSequence.charAt(i2);
            if (UTF16CharacterSet.isHighSurrogate(n3)) {
                char c2 = charSequence.charAt(++i2);
                n3 = UTF16CharacterSet.combinePair((char)n3, c2);
            }
            if (XMLCharacterData.isValid10(n3)) continue;
            XPathException xPathException = new XPathException("The result tree contains a character not allowed by XML 1.0 (hex " + Integer.toHexString(n3) + ')');
            xPathException.setErrorCode("SERE0006");
            xPathException.setLocator(location);
            throw xPathException;
        }
    }
}

