/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Stack;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.CharacterReferenceGenerator;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HexCharacterReferenceGenerator;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class XMLEmitter
extends Emitter {
    protected boolean canonical = false;
    protected boolean started = false;
    protected boolean startedElement = false;
    protected boolean openStartTag = false;
    protected boolean declarationIsWritten = false;
    protected NodeName elementCode;
    protected int indentForNextAttribute = -1;
    protected boolean undeclareNamespaces = false;
    protected boolean unfailing = false;
    protected char delimiter = (char)34;
    protected boolean[] attSpecials = f;
    protected Stack<String> elementStack = new Stack();
    private boolean c = false;
    private String d = "\n                                                          ";
    private boolean e = false;
    protected CharacterReferenceGenerator characterReferenceGenerator = HexCharacterReferenceGenerator.THE_INSTANCE;
    static boolean[] a;
    private static boolean[] f;
    static boolean[] b;

    public void setCharacterReferenceGenerator(CharacterReferenceGenerator characterReferenceGenerator) {
        this.characterReferenceGenerator = characterReferenceGenerator;
    }

    public void setEscapeNonAscii(Boolean bl2) {
    }

    @Override
    public void open() {
    }

    @Override
    public void startDocument(int n2) {
    }

    @Override
    public void endDocument() {
    }

    protected void openDocument() {
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.characterSet == null) {
            this.characterSet = UTF8CharacterSet.getInstance();
        }
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        this.undeclareNamespaces = "yes".equals(this.outputProperties.getProperty("undeclare-prefixes"));
        this.canonical = "yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}canonical"));
        this.unfailing = "yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}unfailing"));
        if ("yes".equals(this.outputProperties.getProperty("{http://saxon.sf.net/}single-quotes"))) {
            this.delimiter = (char)39;
            this.attSpecials = b;
        }
        this.writeDeclaration();
    }

    public void writeDeclaration() {
        if (this.declarationIsWritten) {
            return;
        }
        this.declarationIsWritten = true;
        try {
            String string;
            String string2;
            this.c = "yes".equals(this.outputProperties.getProperty("indent"));
            String string3 = this.outputProperties.getProperty("byte-order-mark");
            String string4 = this.outputProperties.getProperty("encoding");
            if (string4 == null || string4.equalsIgnoreCase("utf8") || this.canonical) {
                string4 = "UTF-8";
            }
            if ("yes".equals(string3) && !this.canonical && ("UTF-8".equalsIgnoreCase(string4) || "UTF-16LE".equalsIgnoreCase(string4) || "UTF-16BE".equalsIgnoreCase(string4))) {
                this.writer.write(65279);
            }
            if ((string3 = this.outputProperties.getProperty("omit-xml-declaration")) == null) {
                string3 = "no";
            }
            if (this.canonical) {
                string3 = "yes";
            }
            if ((string2 = this.outputProperties.getProperty("version")) == null) {
                string2 = this.getConfiguration().getXMLVersion() == 10 ? "1.0" : "1.1";
            } else {
                if (!string2.equals("1.0") && !string2.equals("1.1")) {
                    if (this.unfailing) {
                        string2 = "1.0";
                    } else {
                        XPathException xPathException = new XPathException("XML version must be 1.0 or 1.1");
                        xPathException.setErrorCode("SESU0013");
                        throw xPathException;
                    }
                }
                if (!string2.equals("1.0") && string3.equals("yes") && this.outputProperties.getProperty("doctype-system") != null && !this.unfailing) {
                    XPathException xPathException = new XPathException("Values of 'version', 'omit-xml-declaration', and 'doctype-system' conflict");
                    xPathException.setErrorCode("SEPM0009");
                    throw xPathException;
                }
            }
            Object object = this.outputProperties.getProperty("undeclare-prefixes");
            if ("yes".equals(object)) {
                this.undeclareNamespaces = true;
            }
            if (string2.equals("1.0") && this.undeclareNamespaces) {
                if (this.unfailing) {
                    this.undeclareNamespaces = false;
                } else {
                    object = new XPathException("Cannot undeclare namespaces with XML version 1.0");
                    ((XPathException)object).setErrorCode("SEPM0010");
                    throw object;
                }
            }
            if ("omit".equals(object = this.outputProperties.getProperty("standalone"))) {
                object = null;
            }
            if (object != null) {
                this.e = true;
                if (string3.equals("yes") && !this.unfailing) {
                    XPathException xPathException = new XPathException("Values of 'standalone' and 'omit-xml-declaration' conflict");
                    xPathException.setErrorCode("SEPM0009");
                    throw xPathException;
                }
            }
            if ((string = this.outputProperties.getProperty("doctype-system")) != null && !"".equals(string)) {
                this.e = true;
            }
            if (string3.equals("no")) {
                this.writer.write("<?xml version=\"" + string2 + "\" encoding=\"" + string4 + '\"' + (object != null ? " standalone=\"" + (String)object + '\"' : "") + "?>");
            }
            return;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    protected void writeDocType(NodeName object, String string, String string2, String string3) {
        block7: {
            try {
                if (!this.canonical) {
                    if (this.declarationIsWritten && !this.c) {
                        this.writer.write("\n");
                    }
                    this.writer.write("<!DOCTYPE " + string + '\n');
                    object = null;
                    if (string2 != null) {
                        object = string2.contains("\"") ? "'" + string2 + "'" : "\"" + string2 + '\"';
                    }
                    if (string2 != null && string3 == null) {
                        this.writer.write("  SYSTEM " + (String)object + ">\n");
                        break block7;
                    }
                    if (string2 == null && string3 != null) {
                        this.writer.write("  PUBLIC \"" + string3 + "\">\n");
                        break block7;
                    }
                    this.writer.write("  PUBLIC \"" + string3 + "\" " + (String)object + ">\n");
                }
                return;
            }
            catch (IOException iOException) {
                throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
            }
        }
    }

    @Override
    public void close() {
        if (!this.started) {
            this.openDocument();
        }
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
        super.close();
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType object, Location location, int n2) {
        try {
            this.previousAtomic = false;
            if (!this.started) {
                this.openDocument();
            } else if (this.e && this.elementStack.isEmpty() && this.startedElement && !this.unfailing) {
                object = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains more than one top-level element");
                ((XPathException)object).setErrorCode("SEPM0004");
                throw object;
            }
            this.startedElement = true;
            object = nodeName.getDisplayName();
            if (!this.allCharactersEncodable && (n2 = this.testCharacters((CharSequence)object)) != 0) {
                XPathException xPathException = new XPathException("Element name contains a character (decimal + " + n2 + ") not available in the selected encoding");
                xPathException.setErrorCode("SERE0008");
                throw xPathException;
            }
            this.elementStack.push((String)object);
            this.elementCode = nodeName;
            try {
                if (!this.started) {
                    String string = this.outputProperties.getProperty("doctype-system");
                    String string2 = this.outputProperties.getProperty("doctype-public");
                    if ("".equals(string)) {
                        string = null;
                    }
                    if ("".equals(string2)) {
                        string2 = null;
                    }
                    if (string != null) {
                        this.e = true;
                        this.writeDocType(nodeName, (String)object, string, string2);
                    } else if (this.writeDocTypeWithNullSystemId()) {
                        this.writeDocType(nodeName, (String)object, null, string2);
                    }
                    this.started = true;
                }
                if (this.openStartTag) {
                    this.closeStartTag();
                }
                this.writer.write(60);
                this.writer.write((String)object);
                this.openStartTag = true;
                this.indentForNextAttribute = -1;
            }
            catch (IOException iOException) {
                throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
            }
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(location);
            throw object;
        }
    }

    protected boolean writeDocTypeWithNullSystemId() {
        return false;
    }

    @Override
    public void namespace(NamespaceBindingSet object, int n2) {
        try {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (NamespaceBinding)object.next();
                String string = ((NamespaceBinding)object2).getPrefix();
                object2 = ((NamespaceBinding)object2).getURI();
                String string2 = this.getAttributeIndentString();
                if (string.isEmpty()) {
                    this.writer.write(string2);
                    XMLEmitter xMLEmitter = this;
                    xMLEmitter.writeAttribute(xMLEmitter.elementCode, "xmlns", (CharSequence)object2, 0);
                    continue;
                }
                if (string.equals("xml")) continue;
                int n3 = this.testCharacters(string);
                if (n3 != 0) {
                    object = new XPathException("Namespace prefix contains a character (decimal + " + n3 + ") not available in the selected encoding");
                    ((XPathException)object).setErrorCode("SERE0008");
                    throw object;
                }
                if (!this.undeclareNamespaces && ((String)object2).isEmpty()) continue;
                this.writer.write(string2);
                XMLEmitter xMLEmitter = this;
                xMLEmitter.writeAttribute(xMLEmitter.elementCode, "xmlns:" + string, (CharSequence)object2, 0);
            }
            return;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    public void setIndentForNextAttribute(int n2) {
        this.indentForNextAttribute = n2;
    }

    @Override
    public void attribute(NodeName object, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        int n3;
        object = object.getDisplayName();
        if (!this.allCharactersEncodable && (n3 = this.testCharacters((CharSequence)object)) != 0) {
            if (this.unfailing) {
                object = this.convertToAscii((CharSequence)object);
            } else {
                object = new XPathException("Attribute name contains a character (decimal + " + n3 + ") not available in the selected encoding");
                ((XPathException)object).setErrorCode("SERE0008");
                throw object;
            }
        }
        try {
            this.writer.write(this.getAttributeIndentString());
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
        XMLEmitter xMLEmitter = this;
        xMLEmitter.writeAttribute(xMLEmitter.elementCode, (String)object, charSequence, n2);
    }

    protected String getAttributeIndentString() {
        if (this.indentForNextAttribute < 0) {
            return " ";
        }
        int n2 = this.indentForNextAttribute;
        while (n2 >= this.d.length()) {
            this.d = this.d + "                     ";
        }
        return this.d.substring(0, n2);
    }

    @Override
    public void startContent() {
    }

    public void closeStartTag() {
        try {
            if (this.openStartTag) {
                this.writer.write(62);
                this.openStartTag = false;
            }
            return;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    protected String emptyElementTagCloser(String string, NodeName nodeName) {
        if (this.canonical) {
            return "></" + string + ">";
        }
        return "/>";
    }

    protected void writeAttribute(NodeName object, String string, CharSequence charSequence, int n2) {
        block4: {
            try {
                object = charSequence.toString();
                this.writer.write(string);
                if ((n2 & 4) != 0) {
                    this.writer.write(61);
                    this.writer.write(this.delimiter);
                    this.writer.write((String)object);
                    this.writer.write(this.delimiter);
                    break block4;
                }
                if ((n2 & 0x100) != 0) {
                    this.writer.write(61);
                    int n3 = ((String)object).indexOf(34) >= 0 && ((String)object).indexOf(39) < 0 ? 39 : this.delimiter;
                    this.writer.write(n3);
                    this.writeEscape(charSequence, true);
                    this.writer.write(n3);
                    break block4;
                }
                this.writer.write("=");
                this.writer.write(this.delimiter);
                this.writeEscape(charSequence, true);
                this.writer.write(this.delimiter);
                return;
            }
            catch (IOException iOException) {
                throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
            }
        }
    }

    protected int testCharacters(CharSequence charSequence) {
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            int n2 = charSequence.charAt(i2);
            if (n2 <= 127 || !(UTF16CharacterSet.isHighSurrogate(n2) ? !this.characterSet.inCharset(n2 = UTF16CharacterSet.combinePair((char)n2, charSequence.charAt(++i2))) : !this.characterSet.inCharset(n2))) continue;
            return n2;
        }
        return 0;
    }

    protected String convertToAscii(CharSequence charSequence) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 >= '\u0014' && c2 < '\u007f') {
                fastStringBuffer.append(c2);
                continue;
            }
            fastStringBuffer.append("_" + c2 + "_");
        }
        return fastStringBuffer.toString();
    }

    @Override
    public void endElement() {
        String string = this.elementStack.pop();
        try {
            if (!this.openStartTag) {
                this.writer.write("</");
                this.writer.write(string);
                this.writer.write(62);
                return;
            }
            this.writer.write(this.emptyElementTagCloser(string, this.elementCode));
            this.openStartTag = false;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    @Override
    public void characters(CharSequence charSequence, Location object, int n2) {
        block15: {
            if (!this.started) {
                this.openDocument();
            }
            if (this.e && this.elementStack.isEmpty() && !Whitespace.isWhite(charSequence) && !this.unfailing) {
                object = new XPathException("When 'standalone' or 'doctype-system' is specified, the document must be well-formed; but this document contains a top-level text node");
                ((XPathException)object).setErrorCode("SEPM0004");
                throw object;
            }
            try {
                if (this.openStartTag) {
                    this.closeStartTag();
                }
                if ((n2 & 4) != 0) {
                    this.writeCharSequence(charSequence);
                    break block15;
                }
                if ((n2 & 1) == 0) {
                    this.writeEscape(charSequence, false);
                    break block15;
                }
                if (this.testCharacters(charSequence) == 0) {
                    if ((n2 & 0x100) == 0) {
                        this.writeCharSequence(charSequence);
                    } else {
                        int n3 = charSequence.length();
                        for (n2 = 0; n2 < n3; ++n2) {
                            char c2 = charSequence.charAt(n2);
                            if (c2 == '\u0000') continue;
                            this.writer.write(c2);
                        }
                    }
                    break block15;
                }
                int n4 = charSequence.length();
                for (n2 = 0; n2 < n4; ++n2) {
                    char[] cArray;
                    char c3 = charSequence.charAt(n2);
                    if (c3 == '\u0000') continue;
                    if (c3 > '\u007f' && UTF16CharacterSet.isHighSurrogate(c3)) {
                        char[] cArray2 = new char[2];
                        cArray = cArray2;
                        cArray2[0] = c3;
                        cArray[1] = charSequence.charAt(++n2);
                        if (!this.characterSet.inCharset(c3 = UTF16CharacterSet.combinePair(c3, cArray[1]))) {
                            this.writeEscape(new CharSlice(cArray), false);
                            continue;
                        }
                        this.writeCharSequence(new CharSlice(cArray));
                        continue;
                    }
                    cArray = new char[]{c3};
                    if (!this.characterSet.inCharset(c3)) {
                        this.writeEscape(new CharSlice(cArray), false);
                        continue;
                    }
                    this.writeCharSequence(new CharSlice(cArray));
                }
                return;
            }
            catch (IOException iOException) {
                throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
            }
        }
    }

    public void writeCharSequence(CharSequence charSequence) {
        if (charSequence instanceof String) {
            this.writer.write((String)charSequence);
            return;
        }
        if (charSequence instanceof CharSlice) {
            ((CharSlice)charSequence).write(this.writer);
            return;
        }
        if (charSequence instanceof FastStringBuffer) {
            ((FastStringBuffer)charSequence).write(this.writer);
            return;
        }
        if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).write(this.writer);
            return;
        }
        this.writer.write(charSequence.toString());
    }

    @Override
    public void processingInstruction(String object, CharSequence charSequence, Location location, int n2) {
        int n3;
        if (!this.started) {
            this.openDocument();
        }
        if ((n3 = this.testCharacters((CharSequence)object)) != 0) {
            if (this.unfailing) {
                object = this.convertToAscii((CharSequence)object);
            } else {
                object = new XPathException("Character in processing instruction name cannot be represented in the selected encoding (code " + n3 + ')');
                ((XPathException)object).setErrorCode("SERE0008");
                throw object;
            }
        }
        if ((n3 = this.testCharacters(charSequence)) != 0) {
            if (this.unfailing) {
                charSequence = this.convertToAscii(charSequence);
            } else {
                object = new XPathException("Character in processing instruction data cannot be represented in the selected encoding (code " + n3 + ')');
                ((XPathException)object).setErrorCode("SERE0008");
                throw object;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<?" + (String)object + (charSequence.length() > 0 ? " " + charSequence.toString() : "") + "?>");
            return;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    protected void writeEscape(CharSequence charSequence, boolean bl2) {
        boolean[] blArray;
        char c2 = '\u0000';
        boolean bl3 = false;
        boolean[] blArray2 = blArray = bl2 ? this.attSpecials : a;
        if (charSequence instanceof CompressedWhitespace) {
            ((CompressedWhitespace)charSequence).writeEscape(blArray, this.writer);
            return;
        }
        char c3 = charSequence.length();
        while (c2 < c3) {
            char c4;
            char c5 = c2;
            while (c5 < c3) {
                c4 = charSequence.charAt(c5);
                if (c4 < '\u007f') {
                    if (blArray[c4]) break;
                    ++c5;
                    continue;
                }
                if (c4 < '\u00a0' || c4 == '\u2028' || UTF16CharacterSet.isHighSurrogate(c4) || !this.characterSet.inCharset(c4)) break;
                ++c5;
            }
            if (c5 >= c3) {
                if (c2 == '\u0000') {
                    this.writeCharSequence(charSequence);
                    return;
                }
                this.writeCharSequence(charSequence.subSequence(c2, c5));
                return;
            }
            if (c5 > c2) {
                this.writeCharSequence(charSequence.subSequence(c2, c5));
            }
            if ((c4 = charSequence.charAt(c5)) == '\u0000') {
                bl3 = !bl3;
            } else if (bl3) {
                if (c4 > '\u007f') {
                    if (UTF16CharacterSet.isHighSurrogate(c4)) {
                        c2 = UTF16CharacterSet.combinePair(c4, charSequence.charAt(c5 + 1));
                        if (!this.characterSet.inCharset(c2)) {
                            XPathException xPathException = new XPathException("Character x" + Integer.toHexString(c2) + " is not available in the chosen encoding");
                            xPathException.setErrorCode("SERE0008");
                            throw xPathException;
                        }
                    } else if (!this.characterSet.inCharset(c4)) {
                        XPathException xPathException = new XPathException("Character " + c4 + " (x" + Integer.toHexString(c4) + ") is not available in the chosen encoding");
                        xPathException.setErrorCode("SERE0008");
                        throw xPathException;
                    }
                }
                this.writer.write(c4);
            } else if (c4 < '\u007f') {
                switch (c4) {
                    case '<': {
                        this.writer.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.writer.write("&gt;");
                        break;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        break;
                    }
                    case '\"': {
                        this.writer.write("&#34;");
                        break;
                    }
                    case '\'': {
                        this.writer.write("&#39;");
                        break;
                    }
                    case '\n': {
                        this.writer.write("&#xA;");
                        break;
                    }
                    case '\r': {
                        this.writer.write("&#xD;");
                        break;
                    }
                    case '\t': {
                        this.writer.write("&#x9;");
                        break;
                    }
                    default: {
                        this.characterReferenceGenerator.outputCharacterReference(c4, this.writer);
                        break;
                    }
                }
            } else if (c4 < '\u00a0' || c4 == '\u2028') {
                this.characterReferenceGenerator.outputCharacterReference(c4, this.writer);
            } else if (UTF16CharacterSet.isHighSurrogate(c4)) {
                int n2;
                if (this.characterSet.inCharset(n2 = UTF16CharacterSet.combinePair(c4, c2 = (char)charSequence.charAt(++c5)))) {
                    this.writer.write(c4);
                    this.writer.write(c2);
                } else {
                    this.characterReferenceGenerator.outputCharacterReference(n2, this.writer);
                }
            } else {
                this.characterReferenceGenerator.outputCharacterReference(c4, this.writer);
            }
            c2 = ++c5;
        }
    }

    @Override
    public void comment(CharSequence object, Location location, int n2) {
        int n3;
        if (!this.started) {
            this.openDocument();
        }
        if ((n3 = this.testCharacters((CharSequence)object)) != 0) {
            if (this.unfailing) {
                object = this.convertToAscii((CharSequence)object);
            } else {
                object = new XPathException("Character in comment cannot be represented in the selected encoding (code " + n3 + ')');
                ((XPathException)object).setErrorCode("SERE0008");
                throw object;
            }
        }
        try {
            if (this.openStartTag) {
                this.closeStartTag();
            }
            this.writer.write("<!--");
            this.writer.write(object.toString());
            this.writer.write("-->");
            return;
        }
        catch (IOException iOException) {
            throw new XPathException("Failure writing to " + this.getSystemId(), iOException);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public boolean isStarted() {
        return this.started;
    }

    static {
        int n2;
        a = new boolean[128];
        for (n2 = 0; n2 <= 31; ++n2) {
            XMLEmitter.a[n2] = true;
        }
        for (n2 = 32; n2 <= 127; ++n2) {
            XMLEmitter.a[n2] = false;
        }
        XMLEmitter.a[10] = false;
        XMLEmitter.a[9] = false;
        XMLEmitter.a[13] = true;
        XMLEmitter.a[60] = true;
        XMLEmitter.a[62] = true;
        XMLEmitter.a[38] = true;
        f = new boolean[128];
        for (n2 = 0; n2 <= 31; ++n2) {
            XMLEmitter.f[n2] = true;
        }
        for (n2 = 32; n2 <= 127; ++n2) {
            XMLEmitter.f[n2] = false;
        }
        XMLEmitter.f[0] = true;
        XMLEmitter.f[13] = true;
        XMLEmitter.f[10] = true;
        XMLEmitter.f[9] = true;
        XMLEmitter.f[60] = true;
        XMLEmitter.f[62] = true;
        XMLEmitter.f[38] = true;
        XMLEmitter.f[34] = true;
        boolean[] blArray = Arrays.copyOf(f, 128);
        b = blArray;
        blArray[34] = false;
        XMLEmitter.b[39] = true;
    }
}

