/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.sf.saxon.event.Event;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.tree.tiny.CharSlice;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.Whitespace;

public class XMLIndenter
extends ProxyReceiver {
    private int a = 0;
    protected char[] indentChars = new char[]{'\n', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private boolean b = false;
    private boolean c = false;
    private boolean d = true;
    private Event.Text e = null;
    private int f = 0;
    private int g = 0;
    private int h = -1;
    private Set<NodeName> i = null;
    private XMLEmitter j;
    private AttributeCollectionImpl k;
    private List<NamespaceBindingSet> l = new ArrayList<NamespaceBindingSet>(8);

    public XMLIndenter(XMLEmitter xMLEmitter) {
        super(xMLEmitter);
        this.j = xMLEmitter;
        this.k = new AttributeCollectionImpl(this.getConfiguration());
    }

    public void setOutputProperties(Properties object) {
        String string = ((Properties)object).getProperty("omit-xml-declaration");
        this.d = string == null || !"yes".equals(Whitespace.trim(string)) || ((Properties)object).getProperty("doctype-system") != null;
        string = ((Properties)object).getProperty("suppress-indentation");
        if (string == null) {
            string = ((Properties)object).getProperty("{http://saxon.sf.net/}suppress-indentation");
        }
        if (string != null) {
            this.i = new HashSet<NodeName>(8);
            object = new StringTokenizer(string, " \t\r\n");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string = ((StringTokenizer)object).nextToken();
                this.i.add(FingerprintedQName.fromClarkName(string));
            }
        }
    }

    @Override
    public void open() {
        this.nextReceiver.open();
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType schemaType, Location location, int n2) {
        if (this.c || this.d) {
            if (this.isDoubleSpaced(nodeName)) {
                this.nextReceiver.characters("\n", location, 0);
                this.f = 0;
                this.g = 0;
            }
            this.a();
        } else {
            this.b();
        }
        this.nextReceiver.startElement(nodeName, schemaType, location, n2);
        ++this.a;
        this.b = true;
        this.c = true;
        this.d = false;
        this.f = 0;
        if (this.i != null && this.h == -1 && this.i.contains(nodeName)) {
            this.h = this.a;
        }
        if (schemaType != AnyType.getInstance() && schemaType != Untyped.getInstance() && this.h < 0 && schemaType.isComplexType() && ((ComplexType)schemaType).isMixedContent()) {
            this.h = this.a;
        }
        this.k.clear();
        this.l.clear();
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindingSet, int n2) {
        this.l.add(namespaceBindingSet);
    }

    @Override
    public void attribute(NodeName nodeName, SimpleType simpleType, CharSequence charSequence, Location location, int n2) {
        if (charSequence.equals("preserve") && nodeName.hasURI("http://www.w3.org/XML/1998/namespace") && nodeName.getLocalPart().equals("space") && this.h < 0) {
            this.h = this.a;
        }
        this.k.addAttribute(nodeName, simpleType, charSequence.toString(), location, n2);
    }

    @Override
    public void startContent() {
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        AttributeCollectionImpl attributeCollectionImpl = this.k;
        if (this.h < 0) {
            for (NamespaceBindingSet namespaceBindingSet : this.l) {
                for (NamespaceBinding namespaceBinding : namespaceBindingSet) {
                    String string = namespaceBinding.getPrefix();
                    if (string.isEmpty()) {
                        n2 += 9 + namespaceBinding.getURI().length();
                        continue;
                    }
                    n2 += string.length() + 10 + namespaceBinding.getURI().length();
                }
            }
            for (int i2 = 0; i2 < attributeCollectionImpl.getLength(); ++i2) {
                String string = attributeCollectionImpl.getPrefix(i2);
                n2 += attributeCollectionImpl.getLocalName(i2).length() + attributeCollectionImpl.getValue(i2).length() + 4 + (string.isEmpty() ? 4 : string.length() + 5);
            }
            if (n2 > this.getLineLength()) {
                n4 = (this.a - 1) * this.getIndentation() + this.j.elementStack.peek().length() + 3;
            }
        }
        for (NamespaceBindingSet namespaceBindingSet : this.l) {
            for (NamespaceBinding namespaceBinding : namespaceBindingSet) {
                this.nextReceiver.namespace(namespaceBinding, 0);
                if (n4 <= 0 || n3++ != 0) continue;
                this.j.setIndentForNextAttribute(n4);
            }
        }
        for (int i3 = 0; i3 < attributeCollectionImpl.getLength(); ++i3) {
            this.nextReceiver.attribute(attributeCollectionImpl.getNodeName(i3), attributeCollectionImpl.getTypeAnnotation(i3), attributeCollectionImpl.getValue(i3), attributeCollectionImpl.getLocation(i3), attributeCollectionImpl.getProperties(i3));
            if (n4 <= 0 || n3++ != 0) continue;
            this.j.setIndentForNextAttribute(n4);
        }
        this.nextReceiver.startContent();
    }

    @Override
    public void endElement() {
        --this.a;
        if (this.d && !this.b) {
            this.a();
        } else {
            this.b();
        }
        this.nextReceiver.endElement();
        this.b = false;
        this.d = true;
        this.c = false;
        this.f = 0;
        if (this.a == this.h - 1) {
            this.h = -1;
        }
    }

    @Override
    public void processingInstruction(String string, CharSequence charSequence, Location location, int n2) {
        if (this.d) {
            this.a();
        } else {
            this.b();
        }
        this.nextReceiver.processingInstruction(string, charSequence, location, n2);
    }

    @Override
    public void characters(CharSequence charSequence, Location location, int n2) {
        if (this.h < 0 && Whitespace.isWhite(charSequence)) {
            this.e = new Event.Text(charSequence, location, n2);
            return;
        }
        this.b();
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '\n') {
                this.b = false;
                ++this.f;
                this.g = 0;
            }
            ++this.g;
        }
        this.nextReceiver.characters(charSequence, location, n2);
        this.c = false;
        this.d = false;
    }

    @Override
    public void comment(CharSequence charSequence, Location location, int n2) {
        if (this.d) {
            this.a();
        } else {
            this.b();
        }
        this.nextReceiver.comment(charSequence, location, n2);
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void a() {
        if (this.h >= 0) {
            this.b();
            return;
        }
        this.e = null;
        int n2 = this.a * this.getIndentation();
        if (this.f > 0 && (n2 -= this.g) <= 0) {
            return;
        }
        if (n2 + 2 >= this.indentChars.length) {
            int n3 = 5 * this.getIndentation();
            if (n2 + 2 > this.indentChars.length + n3) {
                n3 += n2 + 2;
            }
            char[] cArray = new char[this.indentChars.length + n3];
            System.arraycopy(this.indentChars, 0, cArray, 0, this.indentChars.length);
            Arrays.fill(cArray, this.indentChars.length, cArray.length, ' ');
            this.indentChars = cArray;
        }
        int n4 = this.f == 0 ? 0 : 1;
        this.nextReceiver.characters(new CharSlice(this.indentChars, n4, n2 + 1), ExplicitLocation.UNKNOWN_LOCATION, 4);
        this.b = false;
    }

    private void b() {
        if (this.e != null) {
            ((Event)this.e).replay(this.nextReceiver);
            this.e = null;
        }
    }

    @Override
    public void endDocument() {
        if (this.d) {
            this.nextReceiver.characters("\n", ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        super.endDocument();
    }

    protected int getIndentation() {
        return 3;
    }

    protected boolean isDoubleSpaced(NodeName nodeName) {
        return false;
    }

    protected int getLineLength() {
        return 80;
    }
}

