/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize.charcode;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.serialize.charcode.ASCIICharacterSet;
import net.sf.saxon.serialize.charcode.CharacterSet;
import net.sf.saxon.serialize.charcode.ISO88591CharacterSet;
import net.sf.saxon.serialize.charcode.JavaCharacterSet;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.serialize.charcode.UTF8CharacterSet;
import net.sf.saxon.trans.XPathException;

public class CharacterSetFactory {
    private HashMap<String, CharacterSet> a;

    public CharacterSetFactory() {
        HashMap<String, CharacterSet> hashMap = this.a = new HashMap(10);
        CharacterSet characterSet = UTF8CharacterSet.getInstance();
        hashMap.put("utf8", characterSet);
        characterSet = UTF16CharacterSet.getInstance();
        hashMap.put("utf16", characterSet);
        characterSet = ASCIICharacterSet.getInstance();
        hashMap.put("ascii", characterSet);
        hashMap.put("iso646", characterSet);
        hashMap.put("usascii", characterSet);
        characterSet = ISO88591CharacterSet.getInstance();
        hashMap.put("iso88591", characterSet);
    }

    public void setCharacterSetImplementation(String string, CharacterSet characterSet) {
        this.a.put(CharacterSetFactory.a(string), characterSet);
    }

    private static String a(String string) {
        return string.replace("-", "").replace("_", "").toLowerCase();
    }

    public CharacterSet getCharacterSet(Properties object) {
        if ((object = ((Properties)object).getProperty("encoding")) == null) {
            return UTF8CharacterSet.getInstance();
        }
        return this.getCharacterSet((String)object);
    }

    public CharacterSet getCharacterSet(String object) {
        if (object == null) {
            return UTF8CharacterSet.getInstance();
        }
        String string = CharacterSetFactory.a((String)object);
        Object object2 = this.a.get(string);
        if (object2 != null) {
            return object2;
        }
        try {
            object2 = Charset.forName((String)object);
            object2 = JavaCharacterSet.makeCharSet((Charset)object2);
            this.a.put(string, (CharacterSet)object2);
            return object2;
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            object = new XPathException("Invalid encoding name: " + (String)object);
            ((XPathException)object).setErrorCode("SESU0007");
            throw object;
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            object = new XPathException("Unknown encoding requested: " + (String)object);
            ((XPathException)object).setErrorCode("SESU0007");
            throw object;
        }
    }

    public static void main(String[] object3) {
        System.err.println("Available Character Sets in the java.nio package for this Java VM:");
        for (String string : Charset.availableCharsets().keySet()) {
            System.err.println("    " + string);
        }
        System.err.println("Registered Character Sets in Saxon:");
        CharacterSetFactory characterSetFactory = new CharacterSetFactory();
        for (Map.Entry<String, CharacterSet> entry : characterSetFactory.a.entrySet()) {
            System.err.println("    " + entry.getKey() + " = " + entry.getValue().getClass().getName());
        }
    }
}

